/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim;

import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.present.impl.ModifyGroupNameIconPresent;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.ModifyGroupNameOkView;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.event.ByhCommEvent;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

public class ModifyGroupNameActivity
extends BaseActivity
implements IToolView,
ModifyGroupNameOkView {
    private ModifyGroupNameIconPresent mModifyPresent;
    private String mGroupName;

    public void start() {
        String groupName;
        final RongChatExtraBean chatExtraBean = RongUtil.getInstance().getChatExtraBean();
        this.mModifyPresent = new ModifyGroupNameIconPresent(this);
        final EditText groupNameEdtView = (EditText)this.findViewById(R.id.edt_groupname);
        this.vToolTitleTextView.setText(R.string.byhim_modify_groupname);
        this.vToolRightTextView.setVisibility(0);
        this.vToolRightTextView.setText(R.string.byhim_save);
        this.vToolRightTextView.setTextColor(-1);
        this.vToolRightTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String groupName = groupNameEdtView.getText().toString().trim();
                if (TextUtils.isEmpty((CharSequence)groupName)) {
                    ModifyGroupNameActivity.this.showShortToast("\u6ca1\u6709\u8f93\u5165\u6635\u79f0\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
                    return;
                }
                if (chatExtraBean == null) {
                    return;
                }
                String groupId = chatExtraBean.getTargetId();
                if (TextUtils.isEmpty((CharSequence)groupId)) {
                    ModifyGroupNameActivity.this.showShortToast("groupId is null");
                    return;
                }
                ModifyGroupNameActivity.this.mGroupName = groupName;
                ModifyGroupNameActivity.this.mModifyPresent.modifyGroupNameIcon(groupId, groupName, "");
            }
        });
        if (chatExtraBean != null && !TextUtils.isEmpty((CharSequence)(groupName = chatExtraBean.getName()))) {
            groupNameEdtView.setText((CharSequence)groupName);
        }
    }

    public int getContentLayoutId() {
        return R.layout.byhim_modify_groupname_activity;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.finish();
    }

    @Override
    public void modifyGroupNameOk() {
        EventBus.getDefault().post((Object)new ByhCommEvent.ModifyGroupNameOk(this.mGroupName));
        this.finish();
    }

    public void onError(String msg) {
        this.showShortToast(msg);
    }
}

