/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.FriendsEntity;
import com.kangxin.common.Pretty;
import com.kangxin.common.byh.util.VertifyDataUtil;
import me.yokeyword.indexablerv.IndexableAdapter;

public class FriendsListAdapter
extends IndexableAdapter<FriendsEntity> {
    private Context mContext;
    private OnItemContentLongClickListener listener;
    private long mLocalHospId;

    public void setItemContentLongClickListener(OnItemContentLongClickListener listener) {
        this.listener = listener;
    }

    public FriendsListAdapter(Context mContext) {
        this.mContext = mContext;
        this.mLocalHospId = VertifyDataUtil.getInstance((Context)mContext).getHospitalId();
    }

    public RecyclerView.ViewHolder onCreateTitleViewHolder(ViewGroup parent) {
        View inflate = LayoutInflater.from((Context)this.mContext).inflate(R.layout.contract_index, parent, false);
        return new IndexTitle(inflate);
    }

    public RecyclerView.ViewHolder onCreateContentViewHolder(ViewGroup parent) {
        View inflate = LayoutInflater.from((Context)this.mContext).inflate(R.layout.friends_content_item, parent, false);
        return new FriendsVH(inflate);
    }

    public void onBindTitleViewHolder(RecyclerView.ViewHolder holder, String indexTitle) {
        if (holder instanceof IndexTitle) {
            ((IndexTitle)holder).index.setText((CharSequence)indexTitle);
        }
    }

    @SuppressLint(value={"ResourceType"})
    public void onBindContentViewHolder(RecyclerView.ViewHolder holder, FriendsEntity entity) {
        if (holder instanceof FriendsVH) {
            ((FriendsVH)holder).vContractName.setText((CharSequence)entity.getDisplayName());
            ((FriendsVH)holder).vContractDep.setText((CharSequence)entity.getHosName());
            Pretty.create().loadImage(entity.getHeadImageUrl()).placeholder(R.drawable.ic_byh_comm_header).err(R.drawable.ic_byh_comm_header).into(((FriendsVH)holder).vImageHead);
            if (this.mLocalHospId != (long)entity.getHospitalId()) {
                ((FriendsVH)holder).labelView.setVisibility(8);
            } else {
                ((FriendsVH)holder).labelView.setVisibility(0);
                ((FriendsVH)holder).labelView.setText((CharSequence)"\u540c\u4e8b");
            }
            holder.itemView.setOnLongClickListener(v -> {
                if (this.listener != null) {
                    this.listener.onLongClick(holder.itemView, entity);
                }
                return true;
            });
        }
    }

    public static interface OnItemContentLongClickListener {
        public void onLongClick(View var1, FriendsEntity var2);
    }

    private class FriendsVH
    extends RecyclerView.ViewHolder {
        ImageView vImageHead;
        TextView vContractName;
        TextView vContractDep;
        TextView labelView;

        public FriendsVH(View itemView) {
            super(itemView);
            this.vImageHead = (ImageView)itemView.findViewById(R.id.vImageHead);
            this.vContractName = (TextView)itemView.findViewById(R.id.vContractName);
            this.vContractDep = (TextView)itemView.findViewById(R.id.vContractDep);
            this.labelView = (TextView)itemView.findViewById(R.id.label);
        }
    }

    private class IndexTitle
    extends RecyclerView.ViewHolder {
        TextView index;

        public IndexTitle(View itemView) {
            super(itemView);
            this.index = (TextView)itemView.findViewById(R.id.vContractIndex);
        }
    }
}

