/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.FriendsEntity;
import com.kangxin.common.Pretty;
import me.yokeyword.indexablerv.IndexableAdapter;

public class GroupChatAdapter
extends IndexableAdapter<FriendsEntity> {
    private Context mContext;

    public GroupChatAdapter(Context mContext) {
        this.mContext = mContext;
    }

    public RecyclerView.ViewHolder onCreateTitleViewHolder(ViewGroup parent) {
        View inflate = LayoutInflater.from((Context)this.mContext).inflate(R.layout.contract_index, parent, false);
        return new IndexTitle(inflate);
    }

    public RecyclerView.ViewHolder onCreateContentViewHolder(ViewGroup parent) {
        View inflate = LayoutInflater.from((Context)this.mContext).inflate(R.layout.friends_content_item2, parent, false);
        return new GroupChatVH(inflate);
    }

    public void onBindTitleViewHolder(RecyclerView.ViewHolder holder, String indexTitle) {
        if (holder instanceof IndexTitle) {
            ((IndexTitle)holder).index.setText((CharSequence)indexTitle);
        }
    }

    @SuppressLint(value={"ResourceType"})
    public void onBindContentViewHolder(RecyclerView.ViewHolder holder, FriendsEntity entity) {
        if (holder instanceof GroupChatVH) {
            ((GroupChatVH)holder).vContractName.setText((CharSequence)entity.getDisplayName());
            ((GroupChatVH)holder).vContractDep.setText((CharSequence)entity.getHosName());
            ((GroupChatVH)holder).vCheckBox.setChecked(entity.isSelected());
            Pretty.create().loadImage(entity.getHeadImageUrl()).placeholder(R.drawable.ic_byh_comm_header).err(R.drawable.ic_img_load_err).into(((GroupChatVH)holder).vImageHead);
        }
    }

    private class IndexTitle
    extends RecyclerView.ViewHolder {
        TextView index;

        public IndexTitle(View itemView) {
            super(itemView);
            this.index = (TextView)itemView.findViewById(R.id.vContractIndex);
        }
    }

    private class GroupChatVH
    extends RecyclerView.ViewHolder {
        ImageView vImageHead;
        TextView vContractName;
        TextView vContractDep;
        CheckBox vCheckBox;

        public GroupChatVH(View itemView) {
            super(itemView);
            this.vImageHead = (ImageView)itemView.findViewById(R.id.vImageHead);
            this.vContractName = (TextView)itemView.findViewById(R.id.vContractName);
            this.vContractDep = (TextView)itemView.findViewById(R.id.vContractDep);
            this.vCheckBox = (CheckBox)itemView.findViewById(R.id.checkbox_select);
        }
    }
}

