/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.callback;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import com.byh.lib.byhim.bean.FriendsDetailEntity;
import com.byh.lib.byhim.callback.MyOnReceiveMessageListener;
import com.byh.lib.byhim.callback.MyRongYunSendMessageListener;
import com.byh.lib.byhim.module.impl.ReqIconNickModel;
import com.byh.lib.byhim.utils.RongUtil;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.event.ByhCommEvent;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.rong.imkit.RongIM;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.UserInfo;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class ByImConnectCallback
extends RongIMClient.ConnectCallback {
    private static final String TAG = "ByImConnectCallback";
    private ReqIconNickModel mIconNickModel;
    private Context mContext;

    public ByImConnectCallback(Context mContext) {
        this.mContext = mContext;
        this.mIconNickModel = new ReqIconNickModel();
        EventBus.getDefault().register((Object)this);
    }

    public void unRegister() {
        EventBus.getDefault().unregister((Object)this);
    }

    public void onTokenIncorrect() {
        Log.i((String)TAG, (String)"\u8fde\u63a5\u878d\u4e91\u51fa\u9519onTokenIncorrect");
    }

    public void onSuccess(String s) {
        Log.i((String)TAG, (String)("onSuccess: connect ok:" + s));
        EventBus.getDefault().postSticky((Object)new ByhCommEvent.ImConnectOkEvent());
        RongIM.getInstance().setSendMessageListener((RongIM.OnSendMessageListener)new MyRongYunSendMessageListener());
        RongIM.setOnReceiveMessageListener((RongIMClient.OnReceiveMessageListener)new MyOnReceiveMessageListener());
        RongIM.setUserInfoProvider((RongIM.UserInfoProvider)new RongIM.UserInfoProvider(){

            public UserInfo getUserInfo(String rongId) {
                Log.i((String)ByImConnectCallback.TAG, (String)("getUserInfo==>" + rongId));
                ByImConnectCallback.this.updateFriendIconNick(rongId);
                return null;
            }
        }, (boolean)true);
        RongIM.setGroupInfoProvider((RongIM.GroupInfoProvider)new RongIM.GroupInfoProvider(){

            public Group getGroupInfo(String groupId) {
                Log.i((String)ByImConnectCallback.TAG, (String)("getGroupInfo==>" + groupId));
                RongUtil.getInstance().updateGroupIconNick(groupId);
                return null;
            }
        }, (boolean)true);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveUpdateGrouNameEvent(ByhCommEvent.UpdateGroupName updateGroupName) {
        if (updateGroupName.getType() == ByhCommEvent.UpdateGroupName.IM_EXTRA) {
            RongUtil.getInstance().updateGroupIconNick(updateGroupName.getGroupId());
        }
    }

    private void updateFriendIconNick(final String rongId) {
        this.mIconNickModel.reqFriendIconNickname(rongId).subscribe((Observer)new Observer<ResponseBody<FriendsDetailEntity>>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(ResponseBody<FriendsDetailEntity> expertInfoEntityResponseBody) {
                FriendsDetailEntity friendsDetailEntity = (FriendsDetailEntity)expertInfoEntityResponseBody.getResult();
                if (friendsDetailEntity != null) {
                    String nickName = friendsDetailEntity.getName();
                    String headerUrl = friendsDetailEntity.getHeadPortrait();
                    Log.i((String)ByImConnectCallback.TAG, (String)("nickname:" + nickName + ", headerUrl:" + headerUrl));
                    if (headerUrl != null) {
                        UserInfo userInfo = new UserInfo(rongId, nickName, Uri.parse((String)headerUrl));
                        RongIM.getInstance().refreshUserInfoCache(userInfo);
                    }
                }
            }

            public void onError(Throwable e) {
                Log.i((String)ByImConnectCallback.TAG, (String)("onError: " + e));
            }

            public void onComplete() {
            }
        });
    }

    public void onError(RongIMClient.ErrorCode errorCode) {
        Log.i((String)TAG, (String)("\u8fde\u63a5\u878d\u4e91\u51fa\u9519: " + errorCode.getMessage() + "===" + errorCode.getValue()));
    }
}

