/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.callback;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.lib.byhim.ImChatActivity;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.utils.RongUtil;
import com.google.gson.Gson;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.ForegroundCallbacks;
import com.kangxin.common.byh.service.AuthIsVideoPageService;
import com.kangxin.common.byh.service.ConsVideoService;
import com.kangxin.common.past.AppManager;
import io.rong.imkit.RongIM;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.message.InformationNotificationMessage;
import org.greenrobot.eventbus.EventBus;

public class MyOnReceiveMessageListener
implements RongIMClient.OnReceiveMessageListener {
    private static final String TAG = "MyOnReceiveMessage";
    private String mOrderId;
    private boolean isShowDialog = false;

    @SuppressLint(value={"LongLogTag"})
    public boolean onReceived(final Message message2, int left) {
        Log.i((String)TAG, (String)("message=extra=>" + message2.getExtra()));
        Log.i((String)TAG, (String)("message=objectName=>" + message2.getObjectName()));
        Log.i((String)TAG, (String)"===onReceived===");
        this.dispatchNotificationMsg(message2);
        MessageContent messageContent = message2.getContent();
        Log.i((String)TAG, (String)("messageContent==>>" + messageContent.getClass().getSimpleName()));
        final String name = RongUtil.getRongExtraBean(messageContent).getName();
        final String content = RongUtil.getRongContent(messageContent);
        Log.i((String)TAG, (String)("onReceived: name:" + name + ", content: " + content));
        if (ForegroundCallbacks.get().isBackground()) {
            Log.i((String)TAG, (String)"onReceived: backgroud");
            RongIM.getInstance().getConversationNotificationStatus(message2.getConversationType(), message2.getTargetId(), (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Conversation.ConversationNotificationStatus>(){

                public void onSuccess(Conversation.ConversationNotificationStatus conversationNotificationStatus) {
                    if (conversationNotificationStatus == Conversation.ConversationNotificationStatus.NOTIFY) {
                        MyOnReceiveMessageListener.this.showNotifyNotification(message2.getConversationType(), message2.getTargetId(), message2.getMessageId(), name, content);
                    }
                }

                public void onError(RongIMClient.ErrorCode errorCode) {
                }
            });
        } else {
            Log.i((String)TAG, (String)"===isForeground===");
        }
        return true;
    }

    @SuppressLint(value={"LongLogTag"})
    private void showNotifyNotification(Conversation.ConversationType conversationType, String targetId, int id2, String title, String content) {
        Activity activity = AppManager.getAppManager().currentActivity();
        Context context = activity.getApplicationContext();
        Intent intent = RongUtil.getImIntent(context, conversationType, targetId, title);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        this.notifyLiveStart(activity, pendingIntent, id2, content, content, title);
        Log.i((String)TAG, (String)"showNotifyNotification: ==========");
    }

    private void notifyLiveStart(Activity context, PendingIntent intent, int id2, String contentText, String tickerText, String title) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        NotificationChannel channel = null;
        if (Build.VERSION.SDK_INT >= 26) {
            channel = new NotificationChannel("default", (CharSequence)tickerText, 3);
            channel.enableLights(true);
            channel.setLightColor(-65536);
            channel.setShowBadge(true);
            channel.canShowBadge();
            channel.setBypassDnd(true);
            channel.setDescription("\u4f70\u533b\u6c47\u901a\u77e5");
            channel.enableVibration(true);
            channel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
            notificationManager.createNotificationChannel(channel);
        }
        NotificationCompat.Builder build = new NotificationCompat.Builder((Context)context, "default");
        build.setContentTitle((CharSequence)title);
        build.setContentText((CharSequence)contentText);
        build.setNumber(3);
        build.setTicker((CharSequence)tickerText);
        build.setWhen(System.currentTimeMillis());
        build.setPriority(0);
        build.setAutoCancel(true);
        build.setOngoing(false);
        build.setDefaults(2);
        build.setSmallIcon(R.mipmap.ic_launcher);
        build.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.mipmap.ic_launcher));
        build.setContentIntent(intent);
        Notification mNotification = build.build();
        notificationManager.notify(id2, mNotification);
    }

    @SuppressLint(value={"LongLogTag"})
    private void dispatchNotificationMsg(Message message2) {
        InformationNotificationMessage informationNotificationMessage;
        String infoExtra;
        RongChatExtraBean rongChatExtraBean = null;
        MessageContent messageContent = message2.getContent();
        if (messageContent instanceof InformationNotificationMessage && !TextUtils.isEmpty((CharSequence)(infoExtra = (informationNotificationMessage = (InformationNotificationMessage)messageContent).getExtra()))) {
            Gson notifyGson = new Gson();
            rongChatExtraBean = (RongChatExtraBean)notifyGson.fromJson(infoExtra, RongChatExtraBean.class);
        }
        Log.i((String)TAG, (String)("dispatchNotificationMsg: rongChatExtraBean=" + rongChatExtraBean));
        if (rongChatExtraBean == null) {
            return;
        }
        this.mOrderId = rongChatExtraBean.getOrderUuid();
        String chatType = rongChatExtraBean.getChatType();
        Log.i((String)TAG, (String)("dispatchNotificationMsg: chatType=" + chatType));
        AuthIsVideoPageService authIsVideoPageService = (AuthIsVideoPageService)ARouter.getInstance().build("/videocons/AuthIsVideoPageProvider").navigation();
        if (authIsVideoPageService == null) {
            return;
        }
        Log.i((String)TAG, (String)"dispatchNotificationMsg: ^^^^^^^^^^^^^^^^");
        if (("4".equals(chatType) || "6".equals(chatType)) && !authIsVideoPageService.isConsVideoPage()) {
            this.showVideoInviteDialog();
        } else {
            Activity activity = AppManager.getAppManager().currentActivity();
            if (activity != null) {
                if (activity instanceof ImChatActivity) {
                    EventBus.getDefault().post((Object)new ByhCommEvent.UpdateGroupName(message2.getTargetId(), ByhCommEvent.UpdateGroupName.IM_CHATIN));
                } else {
                    EventBus.getDefault().post((Object)new ByhCommEvent.UpdateGroupName(message2.getTargetId(), ByhCommEvent.UpdateGroupName.IM_EXTRA));
                }
            }
        }
    }

    private void showVideoInviteDialog() {
        final Activity activity = AppManager.getAppManager().currentActivity();
        if (activity == null) {
            return;
        }
        if (this.isShowDialog) {
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog alertDialog = new AlertDialog.Builder((Context)activity).setTitle((CharSequence)"\u63d0\u793a").setMessage((CharSequence)"\u89c6\u9891\u4f1a\u8bae\u5df2\u5f00\u59cb\uff0c\u662f\u5426\u8fdb\u5165\uff1f").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                    @SuppressLint(value={"LongLogTag"})
                    public void onClick(DialogInterface dialog, int which) {
                        Log.i((String)MyOnReceiveMessageListener.TAG, (String)("onClick: mOrderId=" + MyOnReceiveMessageListener.this.mOrderId));
                        if (TextUtils.isEmpty((CharSequence)MyOnReceiveMessageListener.this.mOrderId)) {
                            ToastUtils.showLong((CharSequence)"\u672a\u83b7\u53d6\u5230\u8ba2\u5355id");
                            return;
                        }
                        Object object = ARouter.getInstance().build("/cons/video/ConsVideoProvider").navigation();
                        if (object instanceof ConsVideoService) {
                            ConsVideoService consVideoService = (ConsVideoService)object;
                            consVideoService.initConsuPresent();
                            consVideoService.startConsVideo(MyOnReceiveMessageListener.this.mOrderId);
                        }
                        dialog.dismiss();
                        MyOnReceiveMessageListener.this.isShowDialog = false;
                    }
                }).setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        MyOnReceiveMessageListener.this.isShowDialog = false;
                    }
                }).create();
                alertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        MyOnReceiveMessageListener.this.isShowDialog = false;
                        dialog.dismiss();
                    }
                });
                alertDialog.show();
                MyOnReceiveMessageListener.this.isShowDialog = true;
            }
        });
    }
}

