/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.content.Context;
import android.util.Log;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.FriendsApplyEntity;
import com.byh.lib.byhim.holder.FriendsApplyHolder;
import com.byh.lib.byhim.present.FriendsApplyListPresent;
import com.byh.lib.byhim.view.IShowFriendsApplyListView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.util.VertifyDataUtil;
import java.util.Collections;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

@Route(path="/friendsapply/FriendsApplyFragment")
public class FriendsApplyFragment
extends BaseFragment
implements IShowFriendsApplyListView {
    private FriendsApplyListPresent mFriendsListPresent;
    private RecyclerView mFriendsApplyCycler;
    private String mLoginUserId;

    public static FriendsApplyFragment getInstance() {
        return new FriendsApplyFragment();
    }

    public void init() {
        this.mLoginUserId = VertifyDataUtil.getInstance((Context)this.getContext()).getLoginUserId() + "";
        this.mFriendsListPresent = new FriendsApplyListPresent(this);
        this.mFriendsApplyCycler = (RecyclerView)this.findViewById(this.rootView, R.id.recycler_list);
        this.mFriendsApplyCycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mFriendsListPresent.reqFriendsApplyList(this.mLoginUserId);
    }

    protected int getLayoutId() {
        return R.layout.recycler_view_layout;
    }

    @Override
    public void bindFriendsApplyView(List<FriendsApplyEntity> friendsApplyEntities) {
        Collections.reverse(friendsApplyEntities);
        this.mFriendsApplyCycler.setAdapter((RecyclerView.Adapter)new BaseQuickAdapter<FriendsApplyEntity, FriendsApplyHolder>(R.layout.friends_apply_item, friendsApplyEntities){

            protected void convert(FriendsApplyHolder helper, FriendsApplyEntity item) {
                helper.setImageView(R.id.left_img, item.getHeadImageUrl());
                helper.setText(R.id.name_txt, "\u597d\u53cb\u8bf7\u6c42\uff1a" + item.getDisplayName());
                String yyKehsiName = item.getRegHospitalName() + " " + item.getHospitalDeptName();
                helper.setText(R.id.yykeshi_name, yyKehsiName);
                switch (item.getType()) {
                    case 1: {
                        this.showStatusDescForSelf(helper, item, "\u5df2\u901a\u8fc7");
                        break;
                    }
                    case 2: {
                        this.showStatusDescForOther(helper, item, "\u5df2\u6dfb\u52a0");
                    }
                }
            }

            private void showStatusDescForSelf(FriendsApplyHolder helper, FriendsApplyEntity item, String desc) {
                switch (item.getStatus()) {
                    case 1: {
                        helper.setText(R.id.txt_status, desc);
                        helper.setVisible(R.id.duihao_img, false);
                        helper.setVisible(R.id.delete_img, false);
                        helper.setVisible(R.id.txt_status, true);
                        break;
                    }
                    default: {
                        helper.setText(R.id.txt_status, "\u5f85\u9a8c\u8bc1");
                        helper.setVisible(R.id.duihao_img, false);
                        helper.setVisible(R.id.delete_img, false);
                        helper.setVisible(R.id.txt_status, true);
                    }
                }
            }

            private void showStatusDescForOther(FriendsApplyHolder helper, FriendsApplyEntity item, String desc) {
                switch (item.getStatus()) {
                    case 0: {
                        helper.setVisible(R.id.txt_status, false);
                        helper.setVisible(R.id.duihao_img, true);
                        helper.setVisible(R.id.delete_img, true);
                        this.setOnVariItemListener(helper, item);
                        break;
                    }
                    case 1: {
                        helper.setText(R.id.txt_status, desc);
                        helper.setVisible(R.id.duihao_img, false);
                        helper.setVisible(R.id.delete_img, false);
                        helper.setVisible(R.id.txt_status, true);
                        break;
                    }
                    default: {
                        helper.setText(R.id.txt_status, "\u5df2\u5220\u9664");
                        helper.setVisible(R.id.duihao_img, false);
                        helper.setVisible(R.id.delete_img, false);
                        helper.setVisible(R.id.txt_status, true);
                    }
                }
            }

            private void setOnVariItemListener(FriendsApplyHolder helper, final FriendsApplyEntity item) {
                helper.setOnItemViewClickListener(R.id.duihao_img, new View.OnClickListener(){

                    public void onClick(View view) {
                        Log.i((String)"xiaobaima", (String)("uuid==>" + item.getUuid()));
                        FriendsApplyFragment.this.mFriendsListPresent.reqAgreeApply(item.getUuid());
                    }
                });
                helper.setOnItemViewClickListener(R.id.delete_img, new View.OnClickListener(){

                    public void onClick(View view) {
                        FriendsApplyFragment.this.mFriendsListPresent.refuseApply(item.getUuid());
                    }
                });
            }
        });
    }

    @Override
    public void showAgreenResult(ResponseBody responseBody) {
        this.showShortToast("\u6210\u529f");
        this.mFriendsListPresent.reqFriendsApplyList(this.mLoginUserId);
        EventBus.getDefault().post((Object)new ByhCommEvent.AgreeOkEvent());
    }

    @Override
    public void showRefuseResult(ResponseBody responseBody) {
        this.showShortToast("\u6210\u529f");
        this.mFriendsListPresent.reqFriendsApplyList(this.mLoginUserId);
    }

    public void onError(String msg) {
        this.showShortToast(msg);
    }
}

