/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.byh.lib.byhim.adapter.ImChatListAdapter;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.utils.RongUtil;
import com.kangxin.doctor.libdata.http.utils.DeviceUtil;
import io.rong.imkit.fragment.ConversationListFragment;
import io.rong.imkit.fragment.IHistoryDataResultCallback;
import io.rong.imkit.model.Event;
import io.rong.imkit.widget.adapter.ConversationListAdapter;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import java.util.List;

public class ImChatListFragment
extends ConversationListFragment {
    private static final String TAG = "ImChatListFragment";
    public static String CHATLISTTYPE = "chatlisttype";
    String chatListType = "";
    private ImChatListAdapter mChatListAdapter;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Uri uri = Uri.parse((String)("rong://" + DeviceUtil.getPackageName())).buildUpon().appendPath("conversationlist").appendQueryParameter(Conversation.ConversationType.PRIVATE.getName(), "false").appendQueryParameter(Conversation.ConversationType.GROUP.getName(), "false").appendQueryParameter(Conversation.ConversationType.DISCUSSION.getName(), "false").appendQueryParameter(Conversation.ConversationType.PUBLIC_SERVICE.getName(), "false").appendQueryParameter(Conversation.ConversationType.SYSTEM.getName(), "false").build();
        this.mChatListAdapter = new ImChatListAdapter(this.getContext());
        this.setAdapter(this.mChatListAdapter);
        this.setUri(uri);
        this.initData();
    }

    public ConversationListAdapter onResolveAdapter(Context context) {
        return this.mChatListAdapter;
    }

    private void initData() {
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.chatListType = bundle.getString(CHATLISTTYPE);
        }
    }

    public void getConversationList(Conversation.ConversationType[] conversationTypes, final IHistoryDataResultCallback<List<Conversation>> callback) {
        RongIMClient.getInstance().getConversationList((RongIMClient.ResultCallback)new RongIMClient.ResultCallback<List<Conversation>>(){

            public void onSuccess(List<Conversation> conversations) {
                if (callback != null) {
                    if (conversations == null) {
                        return;
                    }
                    conversations = RongUtil.filterConsMsg(conversations, false);
                    callback.onResult(conversations);
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError();
                }
            }
        }, conversationTypes);
    }

    public void onEventMainThread(Event.OnReceiveMessageEvent event) {
        RongChatExtraBean rongChatExtraBean = RongUtil.getRongExtraBean(event.getMessage().getContent());
        int chatType = Integer.parseInt(rongChatExtraBean.getChatType());
        if (!RongUtil.isContypeMsgByChatType(chatType)) {
            super.onEventMainThread(event);
            Log.i((String)TAG, (String)("ImChatListFragment==" + this.mChatListAdapter.getCount()));
        }
    }

    public void onEventMainThread(Message message2) {
        RongChatExtraBean rongChatExtraBean = RongUtil.getRongExtraBean(message2.getContent());
        int chatType = Integer.parseInt(rongChatExtraBean.getChatType());
        if (!RongUtil.isContypeMsgByChatType(chatType)) {
            super.onEventMainThread(message2);
            Log.i((String)TAG, (String)("ImChatListFragment=*******=" + this.mChatListAdapter.getCount()));
        }
    }

    public boolean shouldUpdateConversation(Message message2, int left) {
        Log.i((String)TAG, (String)"==shouldUpdateConversation=2222==");
        return super.shouldUpdateConversation(message2, left);
    }

    public void onEventMainThread(Event.ConversationNotificationEvent notificationEvent) {
        Log.i((String)TAG, (String)"==ConversationNotificationEvent===");
        super.onEventMainThread(notificationEvent);
    }

    public void onEventMainThread(Event.ConversationTopEvent setTopEvent) {
        super.onEventMainThread(setTopEvent);
        Log.i((String)TAG, (String)"==ConversationTopEvent===");
    }
}

