/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.adapter.ImJobChatListAdapter;
import com.byh.lib.byhim.utils.RongUtil;
import com.kangxin.common.util.ListViewUtil;
import com.kangxin.common.util.ReflectionUtil;
import com.kangxin.doctor.libdata.http.utils.DeviceUtil;
import io.rong.imkit.RongIM;
import io.rong.imkit.fragment.ConversationListFragment;
import io.rong.imkit.fragment.IHistoryDataResultCallback;
import io.rong.imkit.model.Event;
import io.rong.imkit.widget.adapter.ConversationListAdapter;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import java.util.List;

public class ImConverListFragment
extends ConversationListFragment {
    private static final String TAG = "ImConverListFragment";
    String chatListType = "";
    public static String CHATLISTTYPE = "chatlisttype";
    private ImJobChatListAdapter mJobChatListAdapter;
    private ListView mListView;

    public static ImConverListFragment getInstance() {
        return new ImConverListFragment();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i((String)TAG, (String)"onCreate: &&&&&&&&&&&&&&");
        Uri uri = Uri.parse((String)("rong://" + DeviceUtil.getPackageName())).buildUpon().appendPath("conversationlist").appendQueryParameter(Conversation.ConversationType.PRIVATE.getName(), "false").appendQueryParameter(Conversation.ConversationType.GROUP.getName(), "false").appendQueryParameter(Conversation.ConversationType.DISCUSSION.getName(), "false").appendQueryParameter(Conversation.ConversationType.PUBLIC_SERVICE.getName(), "false").appendQueryParameter(Conversation.ConversationType.SYSTEM.getName(), "false").build();
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.chatListType = bundle.getString(CHATLISTTYPE);
        }
        this.mJobChatListAdapter = new ImJobChatListAdapter((Activity)this.getActivity());
        this.setAdapter(this.mJobChatListAdapter);
        this.setUri(uri);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rooView = super.onCreateView(inflater, container, savedInstanceState);
        LinearLayout convEmptyLayout = (LinearLayout)this.findViewById(rooView, R.id.rc_conversation_list_empty_layout);
        View msgNoticeView = this.findViewById(rooView, R.id.immsg_notice_rela);
        msgNoticeView.setVisibility(8);
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)convEmptyLayout.getLayoutParams();
        marginLayoutParams.topMargin = this.getResources().getDimensionPixelOffset(R.dimen.y50);
        convEmptyLayout.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
        this.mListView = this.getSuperListView();
        this.mListView.setDividerHeight(0);
        this.mListView.setScrollbarFadingEnabled(false);
        ImageView notifyImageView = (ImageView)this.findViewById(rooView, R.id.rc_empty_img);
        this.findViewById(rooView, R.id.rc_empty_img1).setVisibility(8);
        notifyImageView.setVisibility(0);
        notifyImageView.setImageResource(R.mipmap.commby_blank_page_icon);
        TextView notifyTextView = (TextView)this.findViewById(rooView, R.id.rc_empty_tv);
        notifyTextView.setVisibility(8);
        return rooView;
    }

    private ListView getSuperListView() {
        Object object = ReflectionUtil.getSuperFieldValue((Object)((Object)this), (String)"mList");
        if (object != null && object instanceof ListView) {
            return (ListView)object;
        }
        return null;
    }

    public ConversationListAdapter onResolveAdapter(Context context) {
        return this.mJobChatListAdapter;
    }

    public void getConversationList(Conversation.ConversationType[] conversationTypes, final IHistoryDataResultCallback<List<Conversation>> callback) {
        RongIMClient.getInstance().getConversationList((RongIMClient.ResultCallback)new RongIMClient.ResultCallback<List<Conversation>>(){

            public void onSuccess(List<Conversation> conversations) {
                if (callback != null) {
                    if (conversations == null) {
                        return;
                    }
                    Log.i((String)ImConverListFragment.TAG, (String)("tempList===>>>" + conversations.size()));
                    callback.onResult(conversations);
                    ListViewUtil.setListViewHeightBasedOnChildren((ListView)ImConverListFragment.this.mListView, (int)(conversations.size() + 4));
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError();
                }
            }
        }, conversationTypes);
    }

    public void onEventMainThread(Event.OnReceiveMessageEvent event) {
        super.onEventMainThread(event);
        Log.i((String)TAG, (String)("ImConverListFragment=setListViewHeightBasedOnChildren=" + this.mListView.getCount()));
        RongUtil.getRongExtraBean(event.getMessage().getContent());
        ListViewUtil.setListViewHeightBasedOnChildren((ListView)this.mListView, (int)(this.mListView.getCount() + 4));
    }

    public void onEventMainThread(Message message2) {
        super.onEventMainThread(message2);
        Log.i((String)TAG, (String)("ImConverListFragment==%%%%%=setListViewHeightBasedOnChildren=" + this.mListView.getCount()));
        RongUtil.getRongExtraBean(message2.getContent());
        ListViewUtil.setListViewHeightBasedOnChildren((ListView)this.mListView, (int)(this.mListView.getCount() + 4));
    }

    public boolean shouldUpdateConversation(Message message2, int left) {
        Log.i((String)TAG, (String)"==shouldUpdateConversation=111111==");
        return super.shouldUpdateConversation(message2, left);
    }

    public void onEventMainThread(Event.ConversationRemoveEvent event) {
        super.onEventMainThread(event);
        RongIM.getInstance().clearMessages(event.getType(), event.getTargetId());
    }
}

