/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.byh.lib.byhim.FrameContrActivity;
import com.byh.lib.byhim.FrameContractsActivity;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.adapter.RecommendListAdapter;
import com.byh.lib.byhim.bean.FriendsEntity;
import com.byh.lib.byhim.event.ImEvent;
import com.byh.lib.byhim.fragment.BaseIndexFriendsFragment;
import com.byh.lib.byhim.provider.ImStatusDispatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.yokeyword.indexablerv.IndexableAdapter;
import me.yokeyword.indexablerv.IndexableFooterAdapter;
import me.yokeyword.indexablerv.IndexableHeaderAdapter;
import org.greenrobot.eventbus.EventBus;

public class IndexBarRecomFragment
extends BaseIndexFriendsFragment {
    private RecommendListAdapter mRecommendListAdapter;
    private IndexableFooterAdapter mMoreFootAdapter;
    private List<FriendsEntity> mFriendsList = new ArrayList<FriendsEntity>();
    private IndexableHeaderAdapter mNoticeHeaderAdapter;
    private IndexableFooterAdapter mErrNetAdapter;

    public static IndexBarRecomFragment getInstance() {
        return new IndexBarRecomFragment();
    }

    @Override
    public void init() {
        super.init();
        this.initAdapter();
        this.mFriendsCycleView.setStickyEnable(false);
        this.loadNofriendsNoticeView();
    }

    private void loadNofriendsNoticeView() {
        this.mFriendsCycleView.removeHeaderAdapter((IndexableHeaderAdapter)this.mFriendsHeaderAdapter);
        if (this.mNoticeHeaderAdapter != null) {
            this.mFriendsCycleView.removeHeaderAdapter(this.mNoticeHeaderAdapter);
        }
        this.mNoticeHeaderAdapter = new IndexableHeaderAdapter<String>("H", null, Arrays.asList("\u8fd8\u6ca1\u6709\u8054\u7cfb\u4eba\u5462\uff0c\u8bd5\u8bd5\u6dfb\u52a0\u51e0\u4e2a\u5427")){

            public int getItemViewType() {
                return 1;
            }

            public RecyclerView.ViewHolder onCreateContentViewHolder(ViewGroup parent) {
                View view = LayoutInflater.from((Context)IndexBarRecomFragment.this.getContext()).inflate(R.layout.byhim_nofriend_notice_layout, parent, false);
                return new NoticeHolder(view);
            }

            public void onBindContentViewHolder(RecyclerView.ViewHolder holder, String entity) {
                if (holder instanceof NoticeHolder) {
                    ((NoticeHolder)holder).noticeView.setText((CharSequence)entity);
                }
            }

            class NoticeHolder
            extends RecyclerView.ViewHolder {
                public TextView noticeView;

                public NoticeHolder(View itemView) {
                    super(itemView);
                    this.noticeView = (TextView)itemView.findViewById(R.id.notice_msg);
                }
            }
        };
        this.mFriendsCycleView.addHeaderAdapter(this.mNoticeHeaderAdapter);
        this.addHeaderView();
    }

    private void initAdapter() {
        if (this.mRecommendListAdapter == null) {
            this.mRecommendListAdapter = new RecommendListAdapter(this.getContext());
            this.mFriendsCycleView.setAdapter((IndexableAdapter)this.mRecommendListAdapter);
            this.mRecommendListAdapter.setOnItemContentClickListener((v, originalPosition, currentPosition, entity) -> ImStatusDispatch.getInstance(this.getContext()).dispatchStatus(true, () -> this.startActivity(new Intent(this.getContext(), FrameContractsActivity.class).putExtra("MSG_JUMP_TYPE", 5394).putExtra("IM_DOCTOR_ID", entity.getDoctorId()))));
            this.mFriendsCycleView.setAdapter((IndexableAdapter)this.mRecommendListAdapter);
        }
    }

    @Override
    public void refreshRecoViews() {
        super.refreshRecoViews();
        this.refreshAdapter();
    }

    private void refreshAdapter() {
        if (this.mErrNetAdapter != null) {
            this.mFriendsCycleView.removeFooterAdapter(this.mErrNetAdapter);
        }
        this.mFriendsList.addAll(this.mMorePersonList);
        if (this.mFriendsList != null && this.mFriendsList.size() > 3) {
            this.mFriendsList = this.mFriendsList.subList(0, 3);
            this.mRecommendListAdapter.setDatas(this.mFriendsList);
            this.mRecommendListAdapter.notifyDataSetChanged();
            this.loadCheckMoreFriends();
        }
    }

    @Override
    public void onError(String msg) {
        super.onError(msg);
        this.loadErrNetView();
    }

    private void loadErrNetView() {
        if (this.mMoreFootAdapter != null) {
            this.mFriendsCycleView.removeFooterAdapter(this.mMoreFootAdapter);
        }
        if (this.mErrNetAdapter != null) {
            this.mFriendsCycleView.removeFooterAdapter(this.mErrNetAdapter);
        }
        this.mErrNetAdapter = new IndexableFooterAdapter<String>(null, null, Arrays.asList("\u70b9\u51fb\u91cd\u8bd5")){

            public int getItemViewType() {
                return 257;
            }

            public RecyclerView.ViewHolder onCreateContentViewHolder(ViewGroup parent) {
                View netErrView = LayoutInflater.from((Context)IndexBarRecomFragment.this.getContext()).inflate(R.layout.im_net_err_include, parent, false);
                netErrView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        IndexBarRecomFragment.this.reqRecommendList();
                    }
                });
                return new ErrNetHolder(netErrView);
            }

            public void onBindContentViewHolder(RecyclerView.ViewHolder holder, String entity) {
                if (holder instanceof ErrNetHolder) {
                    ((ErrNetHolder)holder).netDesc.setText((CharSequence)entity);
                }
            }

            class ErrNetHolder
            extends RecyclerView.ViewHolder {
                private TextView netDesc;

                public ErrNetHolder(View itemView) {
                    super(itemView);
                    this.netDesc = (TextView)itemView.findViewById(R.id.net_desc);
                }
            }
        };
        this.mFriendsCycleView.addFooterAdapter(this.mErrNetAdapter);
    }

    private void loadCheckMoreFriends() {
        if (this.mMoreFootAdapter != null) {
            this.mFriendsCycleView.removeFooterAdapter(this.mMoreFootAdapter);
        }
        this.mMoreFootAdapter = new IndexableFooterAdapter<String>(null, null, Arrays.asList("\u67e5\u770b\u66f4\u591a\u63a8\u8350\u597d\u53cb")){

            public int getItemViewType() {
                return 256;
            }

            public RecyclerView.ViewHolder onCreateContentViewHolder(ViewGroup parent) {
                View moreView = LayoutInflater.from((Context)IndexBarRecomFragment.this.getContext()).inflate(R.layout.byhim_check_more_friends, parent, false);
                return new MoreHolder(moreView);
            }

            public void onBindContentViewHolder(RecyclerView.ViewHolder holder, String entity) {
                if (holder instanceof MoreHolder) {
                    ((MoreHolder)holder).checkMoreView.setText((CharSequence)entity);
                    ((MoreHolder)holder).checkMoreView.setOnClickListener(v -> {
                        IndexBarRecomFragment.this.startActivity(new Intent(IndexBarRecomFragment.this.getContext(), FrameContrActivity.class).putExtra("MSG_JUMP_TYPE", 86401));
                        EventBus.getDefault().postSticky((Object)new ImEvent.RecommendInfoEvent(IndexBarRecomFragment.this.mMorePersonList));
                    });
                }
            }

            class MoreHolder
            extends RecyclerView.ViewHolder {
                public TextView checkMoreView;

                public MoreHolder(View itemView) {
                    super(itemView);
                    this.checkMoreView = (TextView)itemView.findViewById(R.id.check_more_members);
                }
            }
        };
        this.mFriendsCycleView.addFooterAdapter(this.mMoreFootAdapter);
    }
}

