/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.util.LogUtils;
import com.byh.lib.byhim.HuanZheDetailsActivity;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.holder.MsgNoticeHolder;
import com.byh.lib.byhim.present.impl.ImApplyListPresent;
import com.byh.lib.byhim.view.ImApplyListView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.db.IPushPresenter;
import com.kangxin.common.byh.db.impl.PushPresenter;
import com.kangxin.common.byh.entity.OrderItemEntity;
import com.kangxin.common.byh.entity.response.PatientDetailEntity;
import com.kangxin.common.byh.inter.CloseNewApplyMsgEvent;
import com.kangxin.common.byh.util.ActivityUtils;
import com.kangxin.common.byh.util.TimeUtil;
import com.kangxin.common.byh.util.VertifyDataUtil;
import java.io.Serializable;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;

@Route(path="/notify/apply_list")
public class ShenqMsgListFragment
extends BaseFragment
implements ImApplyListView {
    private static final String TAG = "ShenqMsgListFragment";
    private RecyclerView mRecyclerView;
    private ImApplyListPresent mImApplyListPresent;
    private IPushPresenter pushPresenter = new PushPresenter();

    public void init() {
        ActivityUtils.addActivity((Activity)this.getActivity());
        this.mRecyclerView = (RecyclerView)this.findViewById(this.rootView, R.id.recycler_list);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mImApplyListPresent = new ImApplyListPresent(this);
        String loginUId = VertifyDataUtil.getInstance((Context)this.getContext()).getLoginUserId() + "";
        Log.i((String)TAG, (String)("loginUId===>" + loginUId));
        this.mImApplyListPresent.reqApplyList(loginUId, 1, 10);
        this.pushPresenter.readPushByBusType(new String[]{"300"});
        this.pushPresenter.readPushEntitiesByTypeOnline(this.mContext, "300");
    }

    protected int getLayoutId() {
        return R.layout.im_list_fragment;
    }

    @Override
    public void binApplyList(List<OrderItemEntity> patientDetailEntityList) {
        BaseQuickAdapter<OrderItemEntity, MsgNoticeHolder> baseQuickAdapter2 = new BaseQuickAdapter<OrderItemEntity, MsgNoticeHolder>(R.layout.im_sqlist_item, patientDetailEntityList){

            protected void convert(MsgNoticeHolder helper, OrderItemEntity item) {
                helper.setText(R.id.sq_name, "\u65b0\u7533\u8bf7\u6d88\u606f");
                int sex = item.getPatientSex();
                String strSex = 1 == sex ? "\u7537" : "\u5973";
                String xinDesc = "\u60a3\u8005@" + item.getPatientName() + ", " + strSex + ", " + item.getPatientAge() + "\u5c81, \u5411\u60a8\u53d1\u6765\u4e86\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\uff0c\u9080\u8bf7\u60a8\u5e2e\u5fd9\u7533\u8bf7\u5e76\u4e00\u540c\u53c2\u52a0\u4e13\u5bb6\u4f1a\u8bca\uff0c\u7acb\u5373\u5904\u7406";
                long date = Long.valueOf(TimeUtil.date2Timestamp((String)item.getOrderCreateTimeStr(), (String)"yyyy-MM-dd HH:mm"));
                String time = TimeUtil.getChatTime((boolean)false, (long)date);
                helper.setText(R.id.sq_time, time);
                SpannableString sp = new SpannableString((CharSequence)xinDesc);
                TextView descText = (TextView)helper.itemView.findViewById(R.id.xinsq_desc);
                descText.setText((CharSequence)sp);
                descText.setMovementMethod(LinkMovementMethod.getInstance());
            }
        };
        baseQuickAdapter2.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener(){

            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                OrderItemEntity patientDetailEntity = (OrderItemEntity)adapter.getItem(position);
                ShenqMsgListFragment.this.mImApplyListPresent.getNewApplyDetail(patientDetailEntity.getOrderViewId());
            }
        });
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)baseQuickAdapter2);
    }

    @Override
    public void fullOrderDetail(PatientDetailEntity responseBody) {
        this.startActivity(new Intent(this.getContext(), HuanZheDetailsActivity.class).putExtra("MSG_JUMP_TYPE", 5381).putExtra("MSG_APPLY_DETAIL", (Serializable)responseBody));
    }

    @Subscribe(sticky=true)
    public void popCurrentFragment(CloseNewApplyMsgEvent event) {
        LogUtils.i((Object[])new Object[]{"\u8fd4\u56de3"});
        this._mActivity.finish();
    }
}

