/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.fragment;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.lib.byhim.FrameNotitleActivity;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.help.ChangeEntityHelper;
import com.byh.lib.byhim.help.ConsPresBtnHelper;
import com.byh.lib.byhim.holder.FriendsApplyHolder;
import com.byh.lib.byhim.present.IFinishConsuPresent;
import com.byh.lib.byhim.present.IiConsuLationPresent;
import com.byh.lib.byhim.present.clc.ClcConsuLationPresent;
import com.byh.lib.byhim.present.clc.ClcFinishConsuPresent;
import com.byh.lib.byhim.present.impl.FinishConsuPresent;
import com.byh.lib.byhim.present.impl.ImConsuLationPresent;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.FinishConsuView;
import com.byh.lib.byhim.view.ImConsulationView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.entity.ConsulationReportItemEntity;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.response.ImConsulationEntity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.inter.IConverExFragment;
import com.kangxin.common.byh.inter.ILive;
import com.kangxin.common.byh.present.ILivePresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.doctor.libdata.http.callback.DownloadCallback;
import com.tbruyelle.rxpermissions.RxPermissions;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class VideoConsFragment
extends BaseFragment
implements FinishConsuView,
ImConsulationView {
    private static final String TAG = "VideoConsFragment";
    private RecyclerView mDocHeadersCyclerView;
    private TextView mConsTimeDesc;
    private IFinishConsuPresent mFinishConsuPresent;
    private ImConsulationEntity mConsulationInfoEntity;
    private long mOrderId;
    private ImConsulationEntity.PatientCaseInfoDTOBean patientCaseInfoDTOBean;
    private IiConsuLationPresent mConsulationPresent;
    private String mDiaName = "";
    private IConverExFragment mConversationExFragment;
    private View mPrediaNoticeLabelView;
    private TextView mPrediaNoticeNameView;
    private ImageView mPrediaNoticeCloseView;
    private ConsPresBtnHelper mConsPresBtnHelper;

    public static VideoConsFragment getInstance() {
        return new VideoConsFragment();
    }

    private void initConsuPresent() {
        RongChatExtraBean rongChatExtraBean = RongUtil.getInstance().getChatExtraBean();
        if (rongChatExtraBean != null) {
            int orderType = rongChatExtraBean.getOrderType();
            Log.i((String)TAG, (String)("initConsuPresent: chatType:" + orderType));
            switch (orderType) {
                case 4: {
                    this.mDiaName = "\u95e8\u8bca";
                    this.mConsulationPresent = new ClcConsuLationPresent(this);
                    this.mFinishConsuPresent = new ClcFinishConsuPresent(this);
                    break;
                }
                case 3: {
                    this.mDiaName = "\u4f1a\u8bca";
                    this.mFinishConsuPresent = new FinishConsuPresent(this);
                    this.mConsulationPresent = new ImConsuLationPresent(this);
                    break;
                }
                default: {
                    Log.i((String)TAG, (String)("initConsuPresent: no match ordertype:" + orderType));
                }
            }
        }
    }

    private void updateGroupChatDatas(ImConsulationEntity consulationEntity) {
        this.showChatMainBar(consulationEntity);
        this.initPresentation(consulationEntity);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void updateConsuStatusEvent(ByhCommEvent.ShowMainBarEvent showMainBarEvent) {
        this.reqUpdateStatus();
    }

    public void reqUpdateStatus() {
        if (this.mConsulationInfoEntity == null) {
            return;
        }
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = this.mConsulationInfoEntity.getConsultationEntity();
        if (this.mConsulationPresent != null) {
            this.mConsulationPresent.reqConsulationInfoByOrderId(consultationEntityBean.getViewId());
        }
    }

    private void startLivePage() {
        if (this.mConsulationInfoEntity == null) {
            return;
        }
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = this.mConsulationInfoEntity.getConsultationEntity();
        if (consultationEntityBean == null) {
            return;
        }
        if (this.mFinishConsuPresent == null) {
            return;
        }
        this.mFinishConsuPresent.getOrderDetail(consultationEntityBean.getViewId());
        this.mFinishConsuPresent.startConsulation(consultationEntityBean.getId());
    }

    public void init() {
        this.initConsuPresent();
        this.mPrediaNoticeLabelView = this.findViewById(this.rootView, R.id.predia_notice_label);
        this.mPrediaNoticeNameView = (TextView)this.findViewById(this.rootView, R.id.predia_notice_name);
        this.mPrediaNoticeCloseView = (ImageView)this.findViewById(this.rootView, R.id.close_predianotice_label);
        this.mConversationExFragment = (IConverExFragment)this.getChildFragmentManager().findFragmentById(R.id.conversation);
        this.mConsulationInfoEntity = (ImConsulationEntity)this.getArguments().getSerializable("CONSUINFO_KEY");
        this.updateGroupChatDatas(this.mConsulationInfoEntity);
        this.findViewById(this.rootView, R.id.rela_video).setOnClickListener(v -> RxPermissions.getInstance((Context)this.getContext()).request(new String[]{"android.permission.CAMERA"}).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                ILive live = (ILive)ARouter.getInstance().build("/liveservice/lib_init").navigation();
                live.downloadSos(this.mContext, new DownloadCallback(){

                    public void onSucc(String destFileDir) {
                        VideoConsFragment.this.startLivePage();
                    }

                    public void onFail(IOException e, String destFileDir) {
                    }
                });
            }
        }));
        this.mConsTimeDesc = (TextView)this.findViewById(this.rootView, R.id.cons_time_desc);
        this.mDocHeadersCyclerView = (RecyclerView)this.findViewById(this.rootView, R.id.doc_headers);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext());
        linearLayoutManager.setOrientation(0);
        this.mDocHeadersCyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        List<String> headerUrls = this.getDocHeaders(this.mConsulationInfoEntity);
        if (headerUrls != null) {
            this.mDocHeadersCyclerView.setAdapter((RecyclerView.Adapter)new BaseQuickAdapter<String, FriendsApplyHolder>(R.layout.byhim_im_consheaders_top_item, headerUrls){

                protected void convert(FriendsApplyHolder helper, String item) {
                    helper.setImageView(R.id.doc_header, item);
                }
            });
        }
        this.findViewById(this.rootView, R.id.check_casebook).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoConsFragment.this.checkCaseBook(new ByhCommEvent.PatientDetailEvent());
            }
        });
        this.findViewById(this.rootView, R.id.vLookOrderDetail).setOnClickListener(v -> {
            OrderDetailEntity orderDetailEntity = this.getOrderDetailEntity();
            if (orderDetailEntity != null) {
                String orderViewId = orderDetailEntity.getOrderViewId();
                ARouter.getInstance().build("/activity_empty/parent_empty").withString("orderViewId", orderViewId).withString("routerPath", "/orders/detail/OrderDetailFragmentV2").navigation();
            }
        });
        this.updateGroupChatDatas(this.mConsulationInfoEntity);
        this.initConsuTime();
    }

    private String getBeginTime(ImConsulationEntity.ConsultationEntityBean consultationEntityBean) {
        if (consultationEntityBean == null) {
            return "";
        }
        String beginTime = consultationEntityBean.getBeginTime();
        String consuDate = consultationEntityBean.getConsultationDate();
        String consuTime = consultationEntityBean.getConsultationTime();
        if (!TextUtils.isEmpty((CharSequence)beginTime)) {
            return beginTime;
        }
        if (TextUtils.isEmpty((CharSequence)consuDate) && TextUtils.isEmpty((CharSequence)consuTime)) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)consuDate) && !TextUtils.isEmpty((CharSequence)consuTime)) {
            return consuTime;
        }
        if (!TextUtils.isEmpty((CharSequence)consuDate) && TextUtils.isEmpty((CharSequence)consuTime)) {
            return consuDate;
        }
        return consuDate + " " + consuTime;
    }

    private void initConsuTime() {
        if (this.mConsulationInfoEntity == null) {
            return;
        }
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = this.mConsulationInfoEntity.getConsultationEntity();
        if (consultationEntityBean == null) {
            return;
        }
        switch (consultationEntityBean.getStatus()) {
            case 40: {
                String endDesc = this.mDiaName + "\u5df2\u7ed3\u675f";
                this.showShortToast(endDesc);
                this.findViewById(this.rootView, R.id.rela_video).setVisibility(8);
                this.mConsTimeDesc.setText((CharSequence)"\u5df2\u5b8c\u6210");
                return;
            }
            case 30: {
                this.findViewById(this.rootView, R.id.rela_video).setVisibility(0);
                String beginTime = this.getBeginTime(consultationEntityBean);
                if (TextUtils.isEmpty((CharSequence)beginTime)) {
                    return;
                }
                this.mConsTimeDesc.setVisibility(0);
                if (this.isHasConsuTiming(beginTime)) {
                    String consuRuning = this.mDiaName + "\u8fdb\u884c\u4e2d";
                    this.mConsTimeDesc.setText((CharSequence)consuRuning);
                    this.mPrediaNoticeLabelView.setVisibility(8);
                } else {
                    this.mConsTimeDesc.setText((CharSequence)("\u9884\u8ba1" + beginTime + "\u5f00\u59cb"));
                    if (this.mConsPresBtnHelper.isInitiator()) {
                        this.mPrediaNoticeLabelView.setVisibility(8);
                    } else {
                        this.mPrediaNoticeLabelView.setVisibility(0);
                        this.mPrediaNoticeCloseView.setVisibility(8);
                        String modifyDesc = "\u4fee\u6539" + this.mDiaName + "\u65f6\u95f4";
                        this.mPrediaNoticeNameView.setText((CharSequence)modifyDesc);
                        this.mPrediaNoticeLabelView.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                VideoConsFragment.this.modifyConsuTime(new ByhCommEvent.InviteExpOkEvent());
                            }
                        });
                    }
                }
                return;
            }
            case 20: {
                this.mConsTimeDesc.setVisibility(0);
                this.mConsTimeDesc.setText((CharSequence)"\u5f85\u4e13\u5bb6\u63a5\u8bca");
                return;
            }
        }
        this.mConsTimeDesc.setVisibility(8);
        this.findViewById(this.rootView, R.id.rela_video).setVisibility(8);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveNoDealWithTempEvent(ByhCommEvent.NoDealWithTempEvent noDealWithTempEvent) {
        this.getActivity().finish();
    }

    private boolean isHasConsuTiming(String beginTime) {
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).parse(beginTime);
            long startConsuTime = date.getTime();
            long currTime = System.currentTimeMillis();
            return startConsuTime - currTime <= 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void modifyConsuTime(ByhCommEvent.InviteExpOkEvent inviteExpOkEvent) {
        if (this.mConsulationInfoEntity == null) {
            return;
        }
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = this.mConsulationInfoEntity.getConsultationEntity();
        if (consultationEntityBean == null) {
            return;
        }
        ImConsulationEntity.PatientCaseInfoDTOBean patientCaseInfoDTOBean = this.mConsulationInfoEntity.getPatientCaseInfoDTO();
        if (patientCaseInfoDTOBean == null) {
            return;
        }
        ImConsulationEntity.PatientInfoDTOBean patientInfoDTOBean = this.mConsulationInfoEntity.getPatientInfoDTO();
        if (patientInfoDTOBean == null) {
            return;
        }
        ImConsulationEntity.DoctorDetailInfoEntityBean doctorDetailInfoEntityBean = this.mConsulationInfoEntity.getDoctorDetailInfoEntity();
        if (doctorDetailInfoEntityBean == null) {
            return;
        }
        ImConsulationEntity.ExpertDetailInfoEntityBean expertDetailInfoEntityBean = this.mConsulationInfoEntity.getExpertDetailInfoEntity();
        if (expertDetailInfoEntityBean == null) {
            return;
        }
        inviteExpOkEvent.setExpertId(consultationEntityBean.getExpertId() + "");
        inviteExpOkEvent.setOrderId(consultationEntityBean.getId() + "");
        inviteExpOkEvent.setSuit(patientCaseInfoDTOBean.getPrimaryDiagno());
        inviteExpOkEvent.setPatientName(patientInfoDTOBean.getDisplayName());
        inviteExpOkEvent.setPatientAge(patientInfoDTOBean.getAge() + "");
        inviteExpOkEvent.setPatientSex(patientInfoDTOBean.getGender() + "");
        inviteExpOkEvent.setDoctorName(doctorDetailInfoEntityBean.getName());
        inviteExpOkEvent.setDoctorHosName(doctorDetailInfoEntityBean.getHospitalDeptName());
        Intent intent = new Intent(this.mContext, FrameNotitleActivity.class);
        intent.putExtra("MSG_JUMP_TYPE", 5398);
        intent.putExtra("CONS_TIME_INVITE", (Serializable)inviteExpOkEvent);
        intent.setFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void agreeInviteExpEvent(ByhCommEvent.InviteExpOkEvent inviteExpOkEvent) {
        if (this.mConsulationInfoEntity == null) {
            return;
        }
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = this.mConsulationInfoEntity.getConsultationEntity();
        if (consultationEntityBean == null) {
            return;
        }
        if (consultationEntityBean.getStatus() == 30) {
            this.showShortToast(this.getString(R.string.byhim_ready_ordered_time));
            return;
        }
        if (consultationEntityBean.getStatus() == 40) {
            String finishDesc = this.mDiaName + "\u5df2\u5b8c\u6210";
            this.showShortToast(finishDesc);
            return;
        }
        if (consultationEntityBean.getStatus() == 50) {
            String cancelDesc = this.mDiaName + "\u5df2\u53d6\u6d88";
            this.showShortToast(cancelDesc);
            return;
        }
        ImConsulationEntity.PatientCaseInfoDTOBean patientCaseInfoDTOBean = this.mConsulationInfoEntity.getPatientCaseInfoDTO();
        if (patientCaseInfoDTOBean == null) {
            return;
        }
        ImConsulationEntity.PatientInfoDTOBean patientInfoDTOBean = this.mConsulationInfoEntity.getPatientInfoDTO();
        if (patientInfoDTOBean == null) {
            return;
        }
        ImConsulationEntity.DoctorDetailInfoEntityBean doctorDetailInfoEntityBean = this.mConsulationInfoEntity.getDoctorDetailInfoEntity();
        if (doctorDetailInfoEntityBean == null) {
            return;
        }
        inviteExpOkEvent.setExpertId(consultationEntityBean.getExpertId() + "");
        inviteExpOkEvent.setOrderId(consultationEntityBean.getId() + "");
        inviteExpOkEvent.setSuit(patientCaseInfoDTOBean.getPrimaryDiagno());
        inviteExpOkEvent.setPatientName(patientInfoDTOBean.getName());
        inviteExpOkEvent.setPatientAge(patientInfoDTOBean.getAge() + "");
        inviteExpOkEvent.setPatientSex(patientInfoDTOBean.getGender() + "");
        inviteExpOkEvent.setDoctorName(doctorDetailInfoEntityBean.getName());
        inviteExpOkEvent.setDoctorHosName(doctorDetailInfoEntityBean.getHospitalDeptName());
        Intent intent = new Intent(this.mContext, FrameNotitleActivity.class);
        intent.putExtra("MSG_JUMP_TYPE", 5398);
        intent.putExtra("CONS_TIME_INVITE", (Serializable)inviteExpOkEvent);
        intent.setFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    private void initPresentation(ImConsulationEntity consulationEntity) {
        ImageView presentImgView = (ImageView)this.findViewById(this.rootView, R.id.check_presentasion);
        TextView presentTxtView = (TextView)this.findViewById(this.rootView, R.id.txt_check_presentasion);
        this.mConsPresBtnHelper = new ConsPresBtnHelper(this.getContext(), presentImgView, presentTxtView);
        this.mConsPresBtnHelper.showPresenTationBtn(consulationEntity);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void finishConsuEvent(ByhCommEvent.FinishConsuEvent finishConsuEvent) {
        String endTile = "\u7ed3\u675f" + this.mDiaName;
        String endMessage = endTile + "\u4e4b\u540e\u5c06\u4e0d\u80fd\u804a\u5929\uff0c \u662f\u5426\u7ed3\u675f";
        new AlertDialog.Builder((Context)this.getActivity()).setTitle((CharSequence)endTile).setMessage((CharSequence)endMessage).setNegativeButton(R.string.byhim_dialog_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setPositiveButton((CharSequence)"\u7ed3\u675f", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ImConsulationEntity.ConsultationEntityBean consultationEntityBean;
                if (VideoConsFragment.this.mConsulationInfoEntity != null && (consultationEntityBean = VideoConsFragment.this.mConsulationInfoEntity.getConsultationEntity()) != null) {
                    String userId = VertifyDataUtil.getInstance((Context)VideoConsFragment.this.getContext()).getLoginUserId() + "";
                    VideoConsFragment.this.mFinishConsuPresent.finishConsulation(consultationEntityBean.getId() + "", userId);
                }
            }
        }).show();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receivePresentationEvent(ByhCommEvent.ClickPreEvent clickPreEvent) {
        ChangeEntityHelper changeEntityHelper = new ChangeEntityHelper();
        ConsulationReportItemEntity consulationReportItemEntity = null;
        boolean isPross = clickPreEvent.hasPresentation();
        consulationReportItemEntity = isPross ? changeEntityHelper.changeToReportItemEntity(this.mConsulationInfoEntity, isPross) : changeEntityHelper.changeToReportItemEntity(this.mConsulationInfoEntity, isPross);
        if (consulationReportItemEntity == null) {
            return;
        }
        ARouter.getInstance().build("/consulation/reportactivity").withSerializable("orderViewId", (Serializable)((Object)consulationReportItemEntity.getOrderViewId())).navigation();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void finishConsReport(ByhCommEvent.FinishPageEvent finishPageEvent) {
        this.reqUpdateStatus();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void checkCaseBook(ByhCommEvent.PatientDetailEvent patientDetailEvent) {
        Intent intent = new Intent(this.getContext(), FrameNotitleActivity.class);
        intent.putExtra("MSG_JUMP_TYPE", 5399);
        intent.putExtra("IM_CHECK_CASE_KEY", "\u67e5\u770b\u75c5\u5386");
        OrderDetailEntity orderDetailEntity = this.getOrderDetailEntity();
        if (orderDetailEntity == null) {
            return;
        }
        intent.putExtra("orderDetailEntity", (Serializable)orderDetailEntity);
        this.startActivity(intent);
    }

    @Nullable
    private OrderDetailEntity getOrderDetailEntity() {
        int orderType;
        if (this.mConsulationInfoEntity == null) {
            return null;
        }
        ImConsulationEntity.PatientInfoDTOBean patientInfoDTOBean = this.mConsulationInfoEntity.getPatientInfoDTO();
        ImConsulationEntity.PatientCaseInfoDTOBean patientCaseInfoDTOBean = this.mConsulationInfoEntity.getPatientCaseInfoDTO();
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = this.mConsulationInfoEntity.getConsultationEntity();
        if (patientCaseInfoDTOBean == null) {
            return null;
        }
        if (patientInfoDTOBean == null) {
            return null;
        }
        OrderDetailEntity orderDetailEntity = new OrderDetailEntity();
        orderDetailEntity.setPatientName(patientInfoDTOBean.getName());
        orderDetailEntity.setPatientAge(patientInfoDTOBean.getAge());
        orderDetailEntity.setPatIdCard(patientInfoDTOBean.getIdCard());
        orderDetailEntity.setPatientSex(patientInfoDTOBean.getGender());
        orderDetailEntity.setPatientTel(patientInfoDTOBean.getMobileNumber());
        orderDetailEntity.setPastHistory(patientCaseInfoDTOBean.getPastHistory());
        orderDetailEntity.setPresentHistory(patientCaseInfoDTOBean.getPresentHistory());
        orderDetailEntity.setPatCaseConsultAim(patientCaseInfoDTOBean.getConsultAim());
        orderDetailEntity.setPatPrimaryDiagno(patientCaseInfoDTOBean.getPrimaryDiagno());
        orderDetailEntity.setPatCaseFamilyHistory(patientCaseInfoDTOBean.getFamilyHistory());
        orderDetailEntity.setPatCaseMedicationHistory(patientCaseInfoDTOBean.getMedicationHistory());
        orderDetailEntity.setCaseAttachmentList(this.mConsulationInfoEntity.getCaseAttachmentList());
        orderDetailEntity.setConsulation(true);
        ImConsulationEntity.ExpertDetailInfoEntityBean expert = this.mConsulationInfoEntity.getExpertDetailInfoEntity();
        orderDetailEntity.setExpertHosName(this.mConsulationInfoEntity.getExpertHosName());
        if (expert != null) {
            orderDetailEntity.setExpertId(expert.getId());
            orderDetailEntity.setExpertDepId(expert.getHospitalDeptId());
            orderDetailEntity.setExpertDepName(expert.getHospitalDeptName());
            orderDetailEntity.setExpertHospId(expert.getHospitalId());
            orderDetailEntity.setExpertProfession(expert.getProfession());
            orderDetailEntity.setExpertProfessionCode(expert.getProfessionCode());
            orderDetailEntity.setExpertName(expert.getName());
            orderDetailEntity.setExpertTel(expert.getContactMobile());
        }
        if ((orderType = RongUtil.getInstance().getChatExtraBean().getOrderType()) == 4) {
            orderDetailEntity.setOrderApplicationChannels(50);
        }
        orderDetailEntity.setOrderId((long)consultationEntityBean.getId());
        orderDetailEntity.setOrderViewId(consultationEntityBean.getViewId());
        ImConsulationEntity.PatientCaseInfoDTOBean patientCaseInfo = this.mConsulationInfoEntity.getPatientCaseInfoDTO();
        if (patientCaseInfo != null) {
            orderDetailEntity.setPatCaseMainSuit(patientCaseInfo.getMainSuit());
        }
        return orderDetailEntity;
    }

    private void showChatMainBar(ImConsulationEntity consulationEntity) {
        if (consulationEntity == null) {
            return;
        }
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = consulationEntity.getConsultationEntity();
        if (consultationEntityBean == null) {
            return;
        }
        if (this.mConversationExFragment == null) {
            return;
        }
        if (consultationEntityBean.getStatus() == 30) {
            this.mConversationExFragment.showChatMainBar();
        } else {
            this.mConversationExFragment.hideChatMainBar();
        }
    }

    private List<String> getDocHeaders(ImConsulationEntity consulationEntity) {
        if (consulationEntity == null) {
            return null;
        }
        ImConsulationEntity.ExpertDetailInfoEntityBean expertDetailInfoEntityBean = consulationEntity.getExpertDetailInfoEntity();
        if (expertDetailInfoEntityBean == null) {
            return null;
        }
        ImConsulationEntity.DoctorDetailInfoEntityBean doctorDetailInfoEntityBean = consulationEntity.getDoctorDetailInfoEntity();
        if (doctorDetailInfoEntityBean == null) {
            return null;
        }
        String headerUrl1 = expertDetailInfoEntityBean.getHeadPortrait();
        String headerUrl2 = doctorDetailInfoEntityBean.getHeadPortrait();
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(headerUrl1);
        headerList.add(headerUrl2);
        return headerList;
    }

    protected int getLayoutId() {
        return R.layout.im_teleconsult_fragment;
    }

    @Override
    public void bindFinishConsuView(ResponseBody responseBody) {
        this.showIsFillinPreseDialog();
    }

    @Override
    public void bindOrderDetail(OrderDetailEntity orderDetailEntity) {
        LoginSuccess loginSuccess = VertifyDataUtil.getInstance((Context)this.getContext()).getLoginData();
        if (loginSuccess == null) {
            return;
        }
        ILivePresenter livePresenter = (ILivePresenter)ARouter.getInstance().build("/live/liveservice").navigation();
        livePresenter.init((Context)this._mActivity);
        if (this.mConsPresBtnHelper != null) {
            if (this.mConsPresBtnHelper.isInitiator()) {
                livePresenter.loginLiveAndEnterRoom(orderDetailEntity, 3);
            } else {
                livePresenter.loginLiveAndEnterRoom(orderDetailEntity, 2);
            }
        }
    }

    private void showIsFillinPreseDialog() {
        new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.byhim_consend).setMessage(R.string.byhim_fillin_pres).setNegativeButton(R.string.byhim_dialog_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setPositiveButton(R.string.byhim_fillin_press, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (VideoConsFragment.this.mConsPresBtnHelper != null) {
                    if (VideoConsFragment.this.mConsulationInfoEntity == null) {
                        return;
                    }
                    ImConsulationEntity.ConsultationReportEntityBean consultationReportEntityBean = VideoConsFragment.this.mConsulationInfoEntity.getConsultationReportEntity();
                    if (consultationReportEntityBean == null) {
                        VideoConsFragment.this.receivePresentationEvent(new ByhCommEvent.ClickPreEvent(false));
                    } else if (!TextUtils.isEmpty((CharSequence)consultationReportEntityBean.getSignature()) || !TextUtils.isEmpty((CharSequence)consultationReportEntityBean.getPhotoReport())) {
                        VideoConsFragment.this.receivePresentationEvent(new ByhCommEvent.ClickPreEvent(true));
                    } else {
                        VideoConsFragment.this.receivePresentationEvent(new ByhCommEvent.ClickPreEvent(false));
                    }
                    dialog.dismiss();
                    VideoConsFragment.this.getActivity().finish();
                }
            }
        }).show();
    }

    public void onError(String msg) {
        this.showShortToast(msg);
    }

    @Override
    public void bindConsulationInfo(ImConsulationEntity consulationEntity, long orderId) {
        if (consulationEntity != null) {
            this.mConsulationInfoEntity = consulationEntity;
            this.mOrderId = orderId;
            this.updateGroupChatDatas(this.mConsulationInfoEntity);
            this.initConsuTime();
        }
    }
}

