/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.help;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.lib.byhim.R;
import com.kangxin.common.byh.entity.response.ImConsulationEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import org.greenrobot.eventbus.EventBus;

public class ConsPresBtnHelper {
    private Context mContext;
    private boolean isInitiator;
    private ImageView mPreImgView;
    private TextView mPreTextView;
    private ImConsulationEntity mConsulationEntity;

    public ConsPresBtnHelper(Context mContext, ImageView preImg, TextView preTxt) {
        this.mContext = mContext;
        this.mPreImgView = preImg;
        this.mPreTextView = preTxt;
    }

    public void showPresenTationBtn(ImConsulationEntity consulationEntity) {
        int localUid;
        ImConsulationEntity.DoctorDetailInfoEntityBean doctorDetailInfoEntityBean = consulationEntity.getDoctorDetailInfoEntity();
        if (doctorDetailInfoEntityBean == null) {
            return;
        }
        this.mConsulationEntity = consulationEntity;
        int docId = doctorDetailInfoEntityBean.getId();
        this.isInitiator = docId == (localUid = VertifyDataUtil.getInstance((Context)this.mContext).getLoginUserId());
        ImConsulationEntity.ConsultationEntityBean consultationEntityBean = this.mConsulationEntity.getConsultationEntity();
        if (consultationEntityBean != null) {
            this.dispatchPreBtnByStatus(consultationEntityBean.getStatus());
        }
    }

    private void dispatchPreBtnByStatus(int status) {
        switch (status) {
            case 20: {
                if (this.isInitiator) {
                    this.mPreImgView.setImageResource(R.drawable.ic_im_ckbg_no);
                    this.mPreTextView.setText(R.string.byhim_check_press);
                    this.mPreImgView.setClickable(false);
                    break;
                }
                this.mPreImgView.setClickable(true);
                this.mPreImgView.setImageResource(R.drawable.ic_message_acceptconsu);
                this.mPreTextView.setText(R.string.byhim_accept_consu);
                this.mPreImgView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        EventBus.getDefault().post((Object)new ByhCommEvent.InviteExpOkEvent());
                    }
                });
                break;
            }
            case 30: {
                if (this.isInitiator) {
                    this.mPreImgView.setImageResource(R.drawable.ic_im_ckbg_no);
                    this.mPreTextView.setText(R.string.byhim_check_press);
                    this.mPreImgView.setClickable(false);
                    break;
                }
                this.mPreImgView.setImageResource(R.drawable.byhim_ic_jshz);
                IUpdateVerStatus updateVerStatus = (IUpdateVerStatus)ARouter.getInstance().build("/service_update/SERVICE_UPDATE_VER_STATUS").navigation();
                int consuStatus = updateVerStatus.getConsuStatus(this.mContext);
                if (consuStatus == 4626) {
                    this.mPreTextView.setText(R.string.byhim_end_cons);
                } else if (consuStatus == 4627) {
                    this.mPreTextView.setText(R.string.byhim_end_cons_remote);
                }
                this.mPreImgView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        EventBus.getDefault().post((Object)new ByhCommEvent.FinishConsuEvent());
                    }
                });
                break;
            }
            case 40: {
                ImConsulationEntity.ConsultationReportEntityBean consultationReportEntityBean = this.mConsulationEntity.getConsultationReportEntity();
                if (this.isInitiator) {
                    this.mPreTextView.setText(R.string.byhim_check_press);
                    if (this.isWritePresentation(consultationReportEntityBean)) {
                        this.mPreImgView.setImageResource(R.drawable.byhim_ic_ckbg);
                        this.mPreImgView.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                EventBus.getDefault().post((Object)new ByhCommEvent.ClickPreEvent(true));
                            }
                        });
                    } else {
                        this.mPreImgView.setImageResource(R.drawable.ic_im_ckbg_no);
                        this.mPreImgView.setClickable(false);
                    }
                    return;
                }
                this.mPreImgView.setImageResource(R.drawable.byhim_ic_ckbg);
                if (this.isWritePresentation(consultationReportEntityBean)) {
                    this.mPreTextView.setText(R.string.byhim_check_press);
                    this.mPreImgView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            EventBus.getDefault().post((Object)new ByhCommEvent.ClickPreEvent(true));
                        }
                    });
                    break;
                }
                this.mPreTextView.setText(R.string.byhim_fillin_press);
                this.mPreImgView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        EventBus.getDefault().post((Object)new ByhCommEvent.ClickPreEvent(false));
                    }
                });
            }
        }
    }

    private boolean isWritePresentation(ImConsulationEntity.ConsultationReportEntityBean consultationReportEntityBean) {
        if (consultationReportEntityBean == null) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)consultationReportEntityBean.getSignature()) || !TextUtils.isEmpty((CharSequence)consultationReportEntityBean.getPhotoReport());
    }

    public boolean isInitiator() {
        return this.isInitiator;
    }
}

