/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.module;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.utils.RongUtil;
import com.kangxin.common.byh.service.IMeetingService;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.doctor.libdata.BuildConfig;
import io.reactivex.Observer;
import io.rong.imkit.RongExtension;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imlib.model.Conversation;

public class CasePlugin
implements IPluginModule {
    Conversation.ConversationType conversationType;
    String targetId;

    public Drawable obtainDrawable(Context context) {
        return ContextCompat.getDrawable((Context)context, (int)R.drawable.rc_ext_plugin_image_selector);
    }

    public String obtainTitle(Context context) {
        return "\u4f1a\u8bae";
    }

    public void onClick(Fragment fragment, RongExtension rongExtension) {
        this.conversationType = rongExtension.getConversationType();
        this.targetId = rongExtension.getTargetId();
        RongChatExtraBean extraBean = RongUtil.getInstance().getChatExtraBean();
        if (rongExtension.getConversationType() == Conversation.ConversationType.GROUP) {
            ARouter.getInstance().build("/mobile/video/meeting/MeetingMembersProvider").withString("GROUP_ID_KEY", extraBean.getTargetId()).navigation();
        } else if (rongExtension.getConversationType() == Conversation.ConversationType.PRIVATE) {
            this.inviteMember(fragment, extraBean);
        }
    }

    private void inviteMember(final Fragment fragment, RongChatExtraBean extraBean) {
        if (BuildConfig.isMeeting.booleanValue()) {
            return;
        }
        String phone = VertifyDataUtil.getInstance((Context)fragment.getContext()).getLoginData().getMobileNumber();
        IMeetingService service = (IMeetingService)ARouter.getInstance().build("/meeting_service/meeting_service").navigation();
        service.invitationJoinMeeting(phone, extraBean.getPhoneNum()).subscribe((Observer)new ProgressDialogObserver<IMeetingService.State>(){

            public void onNext(IMeetingService.State state) {
                if (state == IMeetingService.State.Success) {
                    this.onComplete();
                }
            }

            protected Context attachContext() {
                return fragment.getContext();
            }
        });
    }

    public void onActivityResult(int i, int i1, Intent intent) {
    }
}

