/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.present;

import android.util.Log;
import com.byh.lib.byhim.bean.CreateChatGroupEntity;
import com.byh.lib.byhim.bean.FriendsEntity;
import com.byh.lib.byhim.bean.UnGroupBody;
import com.byh.lib.byhim.module.IContractsModel;
import com.byh.lib.byhim.module.ImMsgModule;
import com.byh.lib.byhim.module.impl.ContractsModel;
import com.byh.lib.byhim.module.impl.ImMsgImplModule;
import com.byh.lib.byhim.view.IShowFriendsView;
import com.byh.lib.byhim.view.ReCommendView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxBaseObserver;
import com.kangxin.common.widget.RxProgressObserver;
import io.reactivex.Observer;
import java.util.List;

public class FriendsListPresent {
    private static final String TAG = "FriendsListPresent";
    private IContractsModel mContractsModel;
    private IShowFriendsView mFriendsView;
    private ImMsgModule mMsgModel;
    private ReCommendView mReCommendView;

    public FriendsListPresent(IShowFriendsView mFriendsView) {
        this.mFriendsView = mFriendsView;
        this.mContractsModel = new ContractsModel();
        this.mMsgModel = new ImMsgImplModule();
    }

    public FriendsListPresent(ReCommendView mReCommendView) {
        this.mContractsModel = new ContractsModel();
        this.mReCommendView = mReCommendView;
    }

    public void reqReCommend(String loginUserId, List<String> phones) {
        this.mContractsModel.reqReCommend(loginUserId, phones).subscribe((Observer)new RxBaseObserver<ResponseBody<List<FriendsEntity>>>(){

            public void onReqNext(ResponseBody<List<FriendsEntity>> listResponseBody) {
                if (200 == listResponseBody.getCode()) {
                    if (FriendsListPresent.this.mReCommendView == null) {
                        return;
                    }
                    FriendsListPresent.this.mReCommendView.showReCommendList((List)listResponseBody.getResult());
                } else {
                    if (FriendsListPresent.this.mFriendsView == null) {
                        return;
                    }
                    FriendsListPresent.this.mFriendsView.onError(listResponseBody.getMsg());
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }

            public void onReqErr(int code, String msg, String errCode) {
                super.onReqErr(code, msg, errCode);
                if (FriendsListPresent.this.mFriendsView == null) {
                    return;
                }
                FriendsListPresent.this.mFriendsView.onError(msg);
            }
        });
    }

    public void createChatGroup(CreateChatGroupEntity createChatGroupEntity) {
        this.mMsgModel.createChatGroup(createChatGroupEntity).subscribe((Observer)new RxProgressObserver<ResponseBody>(){

            public void onReqNext(ResponseBody responseBody) {
                FriendsListPresent.this.mFriendsView.startGroupChatPage(responseBody.getResult() + "");
            }

            public void onReqErr(Throwable e) {
                super.onReqErr(e);
                FriendsListPresent.this.mFriendsView.onError(e.toString());
            }
        });
    }

    public void showFriendsList(String loginUserId, String friendName, boolean isShowProgress) {
        Log.i((String)TAG, (String)("loginUserId==>" + loginUserId));
        if ("-1".equals(loginUserId)) {
            return;
        }
        if (isShowProgress) {
            this.mContractsModel.reqFriendsList(loginUserId, friendName).subscribe((Observer)new SampleObserver<ResponseBody<List<FriendsEntity>>>(){

                public void onNext(ResponseBody<List<FriendsEntity>> listResponseBody) {
                    if (FriendsListPresent.this.mFriendsView == null) {
                        return;
                    }
                    if (200 == listResponseBody.getCode()) {
                        FriendsListPresent.this.mFriendsView.showFriendsList((List)listResponseBody.getResult());
                    } else {
                        FriendsListPresent.this.mFriendsView.onError(listResponseBody.getMsg());
                    }
                }

                public void onError(Throwable e) {
                    super.onError(e);
                    if (FriendsListPresent.this.mFriendsView == null) {
                        return;
                    }
                    FriendsListPresent.this.mFriendsView.onError(e.toString());
                }
            });
        } else {
            this.mContractsModel.reqFriendsList(loginUserId, friendName).subscribe((Observer)new SampleObserver<ResponseBody<List<FriendsEntity>>>(){

                public void onNext(ResponseBody<List<FriendsEntity>> listResponseBody) {
                    if (200 == listResponseBody.getCode()) {
                        FriendsListPresent.this.mFriendsView.showFriendsList((List)listResponseBody.getResult());
                    } else {
                        FriendsListPresent.this.mFriendsView.onError(listResponseBody.getMsg());
                    }
                }

                public void onError(Throwable e) {
                    super.onError(e);
                    FriendsListPresent.this.mFriendsView.onError(e.toString());
                }
            });
        }
    }

    public void reqJointGroup(UnGroupBody unGroupBody) {
        this.mMsgModel.reqJointGroup(unGroupBody).subscribe((Observer)new RxProgressObserver<ResponseBody>(){

            public void onReqNext(ResponseBody responseBody) {
                FriendsListPresent.this.mFriendsView.jointGroupMembersOk();
            }

            public void onError(Throwable e) {
                super.onError(e);
                FriendsListPresent.this.mFriendsView.equals(e.toString());
            }
        });
    }
}

