/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.present.impl;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.module.ImMsgModule;
import com.byh.lib.byhim.module.impl.ImMsgImplModule;
import com.byh.lib.byhim.present.IMsgNoticeListPresenter;
import com.byh.lib.byhim.utils.RongUtil;
import com.byh.lib.byhim.view.IMsgNoticeView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.base.ByBasePresenter;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.v2.PushNoticeEntity;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.service.OrderOpralProvider;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.past.AppManager;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.rong.imlib.model.Conversation;
import java.util.List;

public class MsgNoticepresenter
extends ByBasePresenter
implements IMsgNoticeListPresenter {
    private static final String TAG = "MsgNoticepresenter";
    private IMsgNoticeView mMsgNoticeView;
    private IUserModule mUserModule;
    private ImMsgModule mImMsgModule;
    private boolean isRemoteClc = false;

    public MsgNoticepresenter(IMsgNoticeView msgNoticeView) {
        this.mMsgNoticeView = msgNoticeView;
        this.mUserModule = new UserModule();
        this.mImMsgModule = new ImMsgImplModule();
    }

    @Override
    public void getMsgNoticeList(final boolean isGetMore, boolean isShowLoading, String serviceType) {
        Context context = this.mMsgNoticeView.injectContext();
        String userId = VertifyDataUtil.getInstance((Context)context).getUserId();
        Log.i((String)TAG, (String)("getMsgNoticeList: userId:" + userId));
        if (StringUtils.isEmpty((CharSequence)userId)) {
            return;
        }
        String accountId = VertifyDataUtil.getInstance((Context)this.mContext).getAccountId();
        Observable observable = this.mUserModule.getNativeUserInfo(context).flatMap(loginSuccess -> this.mImMsgModule.getMsgNoticeList(userId, serviceType, accountId, this.getPageIndex(isGetMore), this.getPageSize()));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<List<PushNoticeEntity>>>(){

                public void onReqNext(ResponseBody<List<PushNoticeEntity>> listResponseBody) {
                    MsgNoticepresenter.this.fullData(MsgNoticepresenter.this.mMsgNoticeView, (List)listResponseBody.getResult(), isGetMore);
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    e.printStackTrace();
                    MsgNoticepresenter.this.mMsgNoticeView.error(e.toString());
                    this.onComplete();
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<List<PushNoticeEntity>>>(){

                public void onNext(ResponseBody<List<PushNoticeEntity>> t) {
                    MsgNoticepresenter.this.fullData(MsgNoticepresenter.this.mMsgNoticeView, (List)t.getResult(), isGetMore);
                }

                public void onError(Throwable e) {
                    e.printStackTrace();
                    MsgNoticepresenter.this.mMsgNoticeView.error(e.toString());
                }
            });
        }
    }

    @Override
    public void reqConsuInfo(final int consuType, final String orderId) {
        this.mImMsgModule.getOrderDetail(orderId).subscribe((Observer)new RxProgressObserver<ResponseBody<OrderDetailEntity>>(){

            public void onReqNext(ResponseBody<OrderDetailEntity> orderDetailEntityResponseBody) {
                OrderDetailEntity orderDetailEntity = (OrderDetailEntity)orderDetailEntityResponseBody.getResult();
                if (orderDetailEntity == null) {
                    return;
                }
                MsgNoticepresenter.this.isRemoteClc = false;
                IUpdateVerStatus updateVerStatus = (IUpdateVerStatus)ARouter.getInstance().build("/service_update/SERVICE_UPDATE_VER_STATUS").navigation();
                updateVerStatus.changeConsuStatus(MsgNoticepresenter.this.mContext, 4626);
                MsgNoticepresenter.this.startConsuChatPage(consuType, orderId, orderDetailEntity);
            }

            public void onError(Throwable e) {
                super.onError(e);
                MsgNoticepresenter.this.mMsgNoticeView.error(e.toString());
            }
        });
    }

    @Override
    public void reqClcConsuInfo(final int consuType, final String orderId) {
        OrderOpralProvider orderOpralProvider = (OrderOpralProvider)ARouter.getInstance().build("/clc/orderdetail/OrderImplProvider").navigation();
        orderOpralProvider.getClcOrderDetail(orderId, new OrderOpralProvider.OnOrderDetailResCallBack(){

            public void onOrderDetail(OrderDetailEntity orderDetailEntity) {
                if (orderDetailEntity == null) {
                    return;
                }
                MsgNoticepresenter.this.isRemoteClc = true;
                IUpdateVerStatus updateVerStatus = (IUpdateVerStatus)ARouter.getInstance().build("/service_update/SERVICE_UPDATE_VER_STATUS").navigation();
                updateVerStatus.changeConsuStatus(MsgNoticepresenter.this.mContext, 4627);
                MsgNoticepresenter.this.startConsuChatPage(consuType, orderId, orderDetailEntity);
            }
        });
    }

    @Override
    public void reqOrderDetail(String orderViewId) {
    }

    private void startConsuChatPage(int consuType, String orderId, OrderDetailEntity consulationEntity) {
        String groupName;
        String groupId = consulationEntity.getGroupId();
        if (TextUtils.isEmpty((CharSequence)groupId)) {
            ToastUtils.showShort((CharSequence)"groupid is null");
            return;
        }
        RongChatExtraBean rongChatExtraBean = new RongChatExtraBean();
        rongChatExtraBean.setTargetId(groupId);
        rongChatExtraBean.setOrderUuid(orderId);
        if (this.isRemoteClc) {
            rongChatExtraBean.setOrderType(consulationEntity.getOrderType());
            groupName = consulationEntity.getDocName() + "\u548c" + consulationEntity.getExpertName() + "\u7684\u8fdc\u7a0b\u95e8\u8bca\u5ba4";
        } else {
            rongChatExtraBean.setOrderType(3);
            groupName = consulationEntity.getDocName() + "\u548c" + consulationEntity.getExpertName() + "\u7684\u8fdc\u7a0b\u4f1a\u8bca\u5ba4";
        }
        rongChatExtraBean.setChatType(consuType + "");
        rongChatExtraBean.setName(groupName);
        Context context = AppManager.getAppManager().currentActivity().getApplicationContext();
        RongUtil.startConversation(context, Conversation.ConversationType.GROUP, rongChatExtraBean);
    }
}

