/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.provider;

import android.app.ProgressDialog;
import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.lib.byhim.R;
import com.byh.lib.byhim.bean.JoinMettingMessage;
import com.kangxin.common.byh.service.IMeetingService;
import com.kangxin.doctor.libdata.BuildConfig;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import org.json.JSONException;
import org.json.JSONObject;

@ProviderTag(messageContent=JoinMettingMessage.class)
public class JoinMettingProvider
extends IContainerItemProvider.MessageProvider<JoinMettingMessage> {
    private String mMeetingNum;
    private String mPhone;
    private static final String TAG = "JoinMettingProvider";
    private ProgressDialog progressDialog;
    private Context mContext;

    public void bindView(View view, int i, JoinMettingMessage joinMettingMessage, UIMessage uiMessage) {
        String content = joinMettingMessage.getContent();
        String mettingDesc = null;
        Log.i((String)TAG, (String)("bindView: mettingContent:" + content));
        try {
            JSONObject jsonObject = new JSONObject(content);
            mettingDesc = jsonObject.optString("MeetingInvitation");
            this.mMeetingNum = jsonObject.optString("MeetNum");
            this.mPhone = jsonObject.optString("phone");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ViewHolder holder = (ViewHolder)view.getTag();
        holder.message.setText((CharSequence)mettingDesc);
        holder.messageNum.setText((CharSequence)this.mMeetingNum);
    }

    public Spannable getContentSummary(JoinMettingMessage joinMettingMessage) {
        return new SpannableString((CharSequence)"\u8fdc\u7a0b\u4f1a\u8bae\u9080\u8bf7");
    }

    public void onItemClick(View view, int i, JoinMettingMessage joinMettingMessage, UIMessage uiMessage) {
        if (TextUtils.isEmpty((CharSequence)this.mMeetingNum)) {
            ToastUtils.showLong((CharSequence)"\u4f1a\u8bae\u53f7\u4e3a\u7a7a");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mPhone)) {
            ToastUtils.showLong((CharSequence)"\u624b\u673a\u53f7\u4e3a\u7a7a");
            return;
        }
        Log.i((String)TAG, (String)("onItemClick: mMeetingNum:" + this.mMeetingNum));
        Log.i((String)TAG, (String)("onItemClick: mPhone:" + this.mPhone));
        this.progressDialog = new ProgressDialog(this.mContext);
        this.jointMeeting();
    }

    private void jointMeeting() {
        if (BuildConfig.isMeeting.booleanValue()) {
            return;
        }
        IMeetingService meetingService = (IMeetingService)ARouter.getInstance().build("/meeting_service/meeting_service").navigation();
        meetingService.joinMeeting(this.mPhone, this.mMeetingNum).subscribe((Observer)new Observer<IMeetingService.State>(){

            public void onSubscribe(Disposable d) {
                JoinMettingProvider.this.progressDialog.setMessage((CharSequence)"\u52a0\u8f7d\u4e2d...");
                JoinMettingProvider.this.progressDialog.show();
            }

            public void onNext(IMeetingService.State state) {
                if (state == IMeetingService.State.Success) {
                    JoinMettingProvider.this.progressDialog.dismiss();
                }
            }

            public void onError(Throwable e) {
                Log.i((String)JoinMettingProvider.TAG, (String)"onError: ============");
                JoinMettingProvider.this.progressDialog.dismiss();
            }

            public void onComplete() {
                Log.i((String)JoinMettingProvider.TAG, (String)"onComplete: ============");
                JoinMettingProvider.this.progressDialog.dismiss();
            }
        });
    }

    public View newView(Context context, ViewGroup viewGroup) {
        this.mContext = context;
        View itemView = LayoutInflater.from((Context)context).inflate(R.layout.joinmetting_msg_item, viewGroup, false);
        ViewHolder viewHolder = new ViewHolder();
        viewHolder.message = (TextView)itemView.findViewById(R.id.invite_msg);
        viewHolder.messageNum = (TextView)itemView.findViewById(R.id.meeting_num);
        itemView.setTag((Object)viewHolder);
        return itemView;
    }

    class ViewHolder {
        TextView message;
        TextView messageNum;

        ViewHolder() {
        }
    }
}

