/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.utils.RongUtil;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.OrderItemEntity;
import io.rong.imlib.model.Conversation;

public class ConsuChatReceiver
extends BroadcastReceiver {
    private static final String TAG = "ConsuChatReceiver";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        Log.d((String)TAG, (String)("onReceive: " + action));
        if ("com.kangxin.doctor.worktable.orderlist.consulation.chat".equals(action)) {
            OrderItemEntity orderItemEntity = (OrderItemEntity)intent.getSerializableExtra("ORDER_ITEM_ENTITY");
            OrderDetailEntity orderDetailEntity = (OrderDetailEntity)intent.getSerializableExtra("ORDER_DETAIL_ENTITY");
            if (orderDetailEntity != null) {
                if (orderItemEntity == null) {
                    orderItemEntity = new OrderItemEntity();
                }
                orderItemEntity.setOrderType(orderDetailEntity.getOrderType());
                orderItemEntity.setGroupId(orderDetailEntity.getGroupId());
                orderItemEntity.setOrderViewId(orderDetailEntity.getOrderViewId());
                orderItemEntity.setDocName(orderDetailEntity.getDocName());
                orderItemEntity.setExpertName(orderDetailEntity.getExpertName());
                orderItemEntity.setApplicationChannal(orderDetailEntity.getOrderApplicationChannels());
            }
            int orderType = orderItemEntity.getOrderType();
            RongChatExtraBean rongChatExtraBean = new RongChatExtraBean();
            String groupId = orderItemEntity.getGroupId();
            if (TextUtils.isEmpty((CharSequence)groupId)) {
                ToastUtils.showShort((CharSequence)"groupid is null");
                return;
            }
            Log.i((String)TAG, (String)("orderType:" + orderType + ", groupId:" + groupId));
            String orderId = orderItemEntity.getOrderViewId() + "";
            Log.i((String)TAG, (String)("orderId===>" + orderId));
            rongChatExtraBean.setTargetId(groupId);
            rongChatExtraBean.setOrderUuid(orderId);
            int orderChannel = orderItemEntity.getApplicationChannal();
            Log.i((String)TAG, (String)("onReceive: orderChannel:" + orderChannel));
            if (orderChannel == 40 || orderChannel == 50) {
                rongChatExtraBean.setOrderType(4);
            } else {
                rongChatExtraBean.setOrderType(3);
            }
            Log.i((String)TAG, (String)("onReceive: ordertype===>>" + rongChatExtraBean.getOrderType()));
            rongChatExtraBean.setChatType(orderType + "");
            String groupName = orderItemEntity.getDocName() + "\u548c" + orderItemEntity.getExpertName();
            switch (rongChatExtraBean.getChatType()) {
                case "4": {
                    rongChatExtraBean.setName(groupName + "\u89c6\u9891\u4f1a\u8bca");
                    RongUtil.startConversation(context, Conversation.ConversationType.GROUP, rongChatExtraBean);
                    break;
                }
                case "5": {
                    Log.i((String)TAG, (String)"onReceive: TXT_IMGCONSU_TYPE");
                    rongChatExtraBean.setName(groupName + "\u56fe\u6587\u4f1a\u8bca");
                    RongUtil.startConversation(context, Conversation.ConversationType.GROUP, rongChatExtraBean);
                    break;
                }
                case "6": {
                    Log.i((String)TAG, (String)"onReceive: REMOTE_CLC_CHAT_TYPE");
                    rongChatExtraBean.setName(groupName + "\u7684\u8fdc\u7a0b\u95e8\u8bca\u5ba4");
                    RongUtil.startConversation(context, Conversation.ConversationType.GROUP, rongChatExtraBean);
                }
            }
        }
    }
}

