/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.blankj.utilcode.util.SPUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.lib.byhim.bean.CaseCommenListBean;
import com.byh.lib.byhim.bean.CaseMessage;
import com.byh.lib.byhim.bean.FriendsEntity;
import com.byh.lib.byhim.bean.GroupMemberItemBean;
import com.byh.lib.byhim.bean.ImGroupInfoEntity;
import com.byh.lib.byhim.bean.InviteInvaMessage;
import com.byh.lib.byhim.bean.JoinMettingMessage;
import com.byh.lib.byhim.bean.PreDiaDescMessage;
import com.byh.lib.byhim.bean.RequestIdBodyBeanV2;
import com.byh.lib.byhim.bean.RongChatExtraBean;
import com.byh.lib.byhim.callback.ByImConnectCallback;
import com.byh.lib.byhim.module.CaseExtensionModule;
import com.byh.lib.byhim.module.impl.ReqIconNickModel;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.http.entity.NetResponseMessage;
import com.kangxin.common.util.LogUtils;
import com.kangxin.doctor.libdata.http.bean.ConversationBean;
import com.kangxin.doctor.libdata.http.callback.RequestNetCallBack;
import com.kangxin.doctor.libdata.http.db.ConversationDao;
import com.kangxin.doctor.libdata.http.utils.JSONUtils;
import com.kangxin.doctor.libdata.http.utils.OkHttpUtils;
import com.kangxin.doctor.libdata.http.utils.SpUtils;
import com.kangxin.doctor.libdata.http.utils.UserInfoUtils;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.rong.imkit.DefaultExtensionModule;
import io.rong.imkit.IExtensionModule;
import io.rong.imkit.RongExtensionManager;
import io.rong.imkit.RongIM;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.message.ContactNotificationMessage;
import io.rong.message.FileMessage;
import io.rong.message.ImageMessage;
import io.rong.message.InformationNotificationMessage;
import io.rong.message.LocationMessage;
import io.rong.message.RichContentMessage;
import io.rong.message.TextMessage;
import io.rong.message.VoiceMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class RongUtil {
    private static final String TAG = "RongUtil";
    public static final String PRIVATE = Conversation.ConversationType.PRIVATE.getName();
    public static final String GROUP = Conversation.ConversationType.GROUP.getName();
    public static final String CHATROOM = Conversation.ConversationType.CHATROOM.getName();
    public static final Conversation.ConversationType GROUPTYPE = Conversation.ConversationType.GROUP;
    public static final Conversation.ConversationType PRIVATETYPE = Conversation.ConversationType.PRIVATE;
    public static final Conversation.ConversationType CHATROOMTYPE = Conversation.ConversationType.CHATROOM;
    public static final int TYPE_FRIEND_IN_GROUP = 1;
    public static HashMap<Integer, ArrayList<GroupMemberItemBean>> mFriendMap = new HashMap();
    private RongChatExtraBean chatExtraBean = new RongChatExtraBean();
    public static final String RONG_CHAT_TYPE_PATIENT_MANAGER = "1";
    public static final String RONG_CHAT_TYPE_DOCTOR_CIRCLE = "2";
    public static final String RONG_CHAT_TYPE_ORDER = "3";
    public static final int INDEX_RONG_CLOUD_UUID = 0;
    public static final int INDEX_RONG_CLOUD_TYPE = 1;
    public static final int INDEX_RONG_CLOUD_NAME = 2;
    public static final int INDEX_RONG_CLOUD_CONVERSATION_TYPE = 3;
    private static final RongUtil mRongUtil = new RongUtil();
    private List<String> friendIds;

    private RongUtil() {
    }

    public static RongUtil getInstance() {
        if (mRongUtil == null) {
            return new RongUtil();
        }
        return mRongUtil;
    }

    public void connectIm(Context context) {
        String rongToken;
        LoginSuccess loginData = VertifyDataUtil.getInstance((Context)context).getLoginData();
        if (loginData != null && !TextUtils.isEmpty((CharSequence)(rongToken = loginData.getRongCloudToken()))) {
            Log.i((String)TAG, (String)("token===>>" + rongToken));
            RongIM.connect((String)rongToken, (RongIMClient.ConnectCallback)new ByImConnectCallback(context));
        }
    }

    public static void getConversationList(RongIMClient.ResultCallback<List<Conversation>> callback, Conversation.ConversationType ... types) {
        RongIMClient.getInstance().getConversationList(callback, types);
    }

    public static void getLatestMessages(Conversation.ConversationType conversationType, String targetId, int count, RongIMClient.ResultCallback<List<Message>> callback) {
        RongIMClient.getInstance().getLatestMessages(conversationType, targetId, count, callback);
    }

    public static boolean messageHasExtra(Message message2) {
        String extraByIndex = RongUtil.getExtraByIndex(message2.getContent(), 3);
        return !TextUtils.isEmpty((CharSequence)extraByIndex);
    }

    public static void getUnreadMessageTotalCount(Conversation.ConversationType conversationType, String targetId, RongIMClient.ResultCallback<Integer> callback) {
        RongIM.getInstance().getUnreadCount(conversationType, targetId, callback);
    }

    public static void removeConversation(Conversation.ConversationType type, String targetId) {
        RongIMClient.getInstance().removeConversation(type, targetId, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

            public void onSuccess(Boolean aBoolean) {
                LogUtils.d((Object)"\u79fb\u9664\u4f1a\u8bdd\u6210\u529f");
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                LogUtils.d((Object)("\u79fb\u9664\u4f1a\u8bdd\u5931\u8d25\uff1a" + errorCode));
            }
        });
    }

    public static void setConversationToTop(Conversation.ConversationType type, String targetId, boolean isTop) {
        RongIM.getInstance().setConversationToTop(type, targetId, isTop, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

            public void onSuccess(Boolean aBoolean) {
                LogUtils.d((Object)("\u8bbe\u7f6e\u4f1a\u8bdd\u7f6e\u9876\u6210\u529f\uff1a" + aBoolean));
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                LogUtils.d((Object)("\u8bbe\u7f6e\u4f1a\u8bdd\u7f6e\u9876\u5931\u8d25\uff1a" + errorCode));
            }
        });
    }

    public static void setConversationNotificationStatus(Conversation.ConversationType type, String targetId, Conversation.ConversationNotificationStatus notificationStatus) {
        RongIM.getInstance().setConversationNotificationStatus(type, targetId, notificationStatus, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Conversation.ConversationNotificationStatus>(){

            public void onSuccess(Conversation.ConversationNotificationStatus conversationNotificationStatus) {
                LogUtils.d((Object)("\u8bbe\u7f6e\u6d88\u606f\u514d\u6253\u6270\u6210\u529f\uff1a" + conversationNotificationStatus));
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                LogUtils.d((Object)("\u8bbe\u7f6e\u6d88\u606f\u514d\u6253\u6270\u5931\u8d25\uff1a" + errorCode));
            }
        });
    }

    public static void getConversationNotificationStatus(Conversation.ConversationType type, String targetId, RongIMClient.ResultCallback callback) {
        RongIM.getInstance().getConversationNotificationStatus(type, targetId, callback);
    }

    public static void getConversationIsTop(Conversation.ConversationType type, String targetId, RongIMClient.ResultCallback callback) {
        RongIM.getInstance().getConversation(type, targetId, callback);
    }

    public static void printLog(Message message2, String type) {
        String log = "";
        switch (type) {
            case "0": {
                log = "\u53d1\u9001\u6d88\u606f\uff1a";
                break;
            }
            case "1": {
                log = "\u5bf9\u65b9\u63a5\u6536\u6d88\u606f\uff1a";
            }
        }
        MessageContent msgContent = message2.getContent();
        if (msgContent instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)msgContent;
            LogUtils.d((Object)(log + textMsg.getContent()));
        } else if (msgContent instanceof VoiceMessage) {
            VoiceMessage voiceMsg = (VoiceMessage)msgContent;
            LogUtils.d((Object)(log + voiceMsg.getUri()));
        } else if (msgContent instanceof ImageMessage) {
            ImageMessage imageMsg = (ImageMessage)msgContent;
            LogUtils.d((Object)("image remote uri: " + imageMsg.getRemoteUri().toString()));
            LogUtils.d((Object)("thum uri: " + imageMsg.getThumUri().toString()));
        } else if (msgContent instanceof RichContentMessage) {
            RichContentMessage richContentMsg = (RichContentMessage)msgContent;
            LogUtils.d((Object)(log + richContentMsg.getImgUrl() + ", title: " + richContentMsg.getTitle() + ", content: " + richContentMsg.getContent()));
        } else if (msgContent instanceof FileMessage) {
            FileMessage fileMsg = (FileMessage)msgContent;
            LogUtils.d((Object)(log + fileMsg.getFileUrl()));
        } else if (msgContent instanceof CaseMessage) {
            CaseMessage customMsg = (CaseMessage)msgContent;
            LogUtils.d((Object)(log + customMsg.toString()));
        }
    }

    public static String getExtraByIndex(MessageContent messageContent, int index) {
        CaseMessage customMsg;
        String[] tempStr = new String[]{""};
        if (messageContent instanceof InformationNotificationMessage) {
            InformationNotificationMessage textMsg = (InformationNotificationMessage)messageContent;
            if (textMsg.getExtra() != null) {
                String[] splits = textMsg.getExtra().split(",");
                tempStr[0] = splits[index];
            }
        } else if (messageContent instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)messageContent;
            if (textMsg.getExtra() != null && textMsg.getExtra() != null) {
                String[] splits = textMsg.getExtra().split(",");
                tempStr[0] = splits[index];
            }
        } else if (messageContent instanceof ImageMessage) {
            ImageMessage imageMsg = (ImageMessage)messageContent;
            if (imageMsg.getExtra() != null) {
                String[] splits = imageMsg.getExtra().split(",");
                tempStr[0] = splits[index];
            }
        } else if (messageContent instanceof VoiceMessage) {
            VoiceMessage voiceMsg = (VoiceMessage)messageContent;
            if (voiceMsg.getExtra() != null) {
                String[] splits = voiceMsg.getExtra().split(",");
                tempStr[0] = splits[index];
            }
        } else if (messageContent instanceof FileMessage) {
            FileMessage fileMsg = (FileMessage)messageContent;
            if (fileMsg != null) {
                String[] splits = fileMsg.getExtra().split(",");
                tempStr[0] = splits[index];
            }
        } else if (messageContent instanceof RichContentMessage) {
            RichContentMessage richContentMsg = (RichContentMessage)messageContent;
            if (richContentMsg.getExtra() != null) {
                String[] splits = richContentMsg.getExtra().split(",");
                tempStr[0] = splits[index];
            }
        } else if (messageContent instanceof CaseMessage && (customMsg = (CaseMessage)messageContent).getExtra() != null) {
            String[] splits = customMsg.getExtra().split(",");
            tempStr[0] = splits[index];
        }
        return tempStr[0];
    }

    public void updateGroupIconNick(final String groupId, final UpdateGroupInfoCallback updateGroupInfoCallback) {
        ReqIconNickModel iconNickModel = new ReqIconNickModel();
        iconNickModel.reqGroupIconNickname(groupId).subscribe((Observer)new Observer<ResponseBody<ImGroupInfoEntity>>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(ResponseBody<ImGroupInfoEntity> imGroupInfoEntityResponseBody) {
                ImGroupInfoEntity imGroupInfoEntity = (ImGroupInfoEntity)imGroupInfoEntityResponseBody.getResult();
                if (imGroupInfoEntity != null) {
                    if (updateGroupInfoCallback != null) {
                        updateGroupInfoCallback.onGroupInfo(imGroupInfoEntity);
                    }
                    String iconUrl = imGroupInfoEntity.getLogoUrl();
                    String groupName = imGroupInfoEntity.getGroupName();
                    if (TextUtils.isEmpty((CharSequence)iconUrl)) {
                        return;
                    }
                    if (iconUrl != null) {
                        Group group2 = new Group(groupId, groupName, Uri.parse((String)iconUrl));
                        RongIM.getInstance().refreshGroupInfoCache(group2);
                    } else {
                        ToastUtils.showShort((CharSequence)"url is null");
                    }
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
    }

    public void updateGroupIconNick(final String groupId) {
        ReqIconNickModel iconNickModel = new ReqIconNickModel();
        iconNickModel.reqGroupIconNickname(groupId).subscribe((Observer)new Observer<ResponseBody<ImGroupInfoEntity>>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(ResponseBody<ImGroupInfoEntity> imGroupInfoEntityResponseBody) {
                ImGroupInfoEntity imGroupInfoEntity = (ImGroupInfoEntity)imGroupInfoEntityResponseBody.getResult();
                if (imGroupInfoEntity != null) {
                    String iconUrl = imGroupInfoEntity.getLogoUrl();
                    String groupName = imGroupInfoEntity.getGroupName();
                    if (TextUtils.isEmpty((CharSequence)iconUrl)) {
                        return;
                    }
                    if (iconUrl != null) {
                        Group group2 = new Group(groupId, groupName, Uri.parse((String)iconUrl));
                        RongIM.getInstance().refreshGroupInfoCache(group2);
                    } else {
                        ToastUtils.showShort((CharSequence)"url is null");
                    }
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
    }

    public static String getRongName(MessageContent messageContent) {
        String name = "";
        String extral = "";
        if (messageContent instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)messageContent;
            extral = textMsg.getExtra();
        } else if (messageContent instanceof VoiceMessage) {
            extral = ((VoiceMessage)messageContent).getExtra();
        } else if (messageContent instanceof ImageMessage) {
            extral = ((ImageMessage)messageContent).getExtra();
        } else if (messageContent instanceof RichContentMessage) {
            extral = ((RichContentMessage)messageContent).getExtra();
        } else if (messageContent instanceof LocationMessage) {
            extral = ((LocationMessage)messageContent).getExtra();
        } else if (messageContent instanceof FileMessage) {
            extral = ((FileMessage)messageContent).getExtra();
        } else if (messageContent instanceof CaseMessage) {
            extral = ((CaseMessage)messageContent).getExtra();
        } else if (messageContent instanceof InformationNotificationMessage) {
            extral = ((InformationNotificationMessage)messageContent).getExtra();
        } else if (messageContent instanceof ContactNotificationMessage) {
            extral = ((ContactNotificationMessage)messageContent).getExtra();
        }
        String[] exts = extral.split(",");
        if (exts.length > 3) {
            name = exts[2];
        }
        return name;
    }

    public static String getRongContent(MessageContent messageContent) {
        String result = "";
        if (messageContent instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)messageContent;
            result = textMsg.getContent();
        } else if (messageContent instanceof VoiceMessage) {
            result = "[\u8bed\u97f3]";
        } else if (messageContent instanceof ImageMessage) {
            result = "[\u56fe\u7247]";
        } else if (messageContent instanceof RichContentMessage) {
            result = ((RichContentMessage)messageContent).getContent();
        } else if (messageContent instanceof LocationMessage) {
            result = ((LocationMessage)messageContent).getPoi();
        } else if (messageContent instanceof FileMessage) {
            result = "[\u6587\u4ef6]";
        } else if (messageContent instanceof CaseMessage) {
            result = "\u60a8\u6536\u5230\u4e00\u6761\u75c5\u5386\u6d88\u606f";
        } else if (messageContent instanceof InformationNotificationMessage) {
            result = ((InformationNotificationMessage)messageContent).getMessage();
        } else if (messageContent instanceof ContactNotificationMessage) {
            result = ((ContactNotificationMessage)messageContent).getMessage();
        }
        return result;
    }

    public static Conversation.ConversationType getConversationTypeByName(String conversationTypeName) {
        Conversation.ConversationType conversationType = Conversation.ConversationType.NONE;
        switch (conversationTypeName) {
            case "none": {
                conversationType = Conversation.ConversationType.NONE;
                break;
            }
            case "private": {
                conversationType = Conversation.ConversationType.PRIVATE;
                break;
            }
            case "discussion": {
                conversationType = Conversation.ConversationType.DISCUSSION;
                break;
            }
            case "group": {
                conversationType = Conversation.ConversationType.GROUP;
                break;
            }
            case "chatroom": {
                conversationType = Conversation.ConversationType.CHATROOM;
                break;
            }
            case "customer_service": {
                conversationType = Conversation.ConversationType.CUSTOMER_SERVICE;
                break;
            }
            case "system": {
                conversationType = Conversation.ConversationType.SYSTEM;
                break;
            }
            case "app_public_service": {
                conversationType = Conversation.ConversationType.APP_PUBLIC_SERVICE;
                break;
            }
            case "public_service": {
                conversationType = Conversation.ConversationType.PUBLIC_SERVICE;
                break;
            }
            case "push_service": {
                conversationType = Conversation.ConversationType.PUSH_SERVICE;
            }
        }
        return conversationType;
    }

    public static void getConversationList() {
        RequestIdBodyBeanV2 rBody = new RequestIdBodyBeanV2(1, 1, 90000);
        OkHttpUtils.getInstance().netRequestNoDialog("https://ihos.ebaiyihui.com//doctor/relation/group/list", (Object)rBody, new RequestNetCallBack(){

            public void onSucc(NetResponseMessage responseMessage) {
                if (responseMessage.getData() == null) {
                    LogUtils.d((Object)"\u62c9\u53d6\u5230\u7684\u7fa4\u804a\u5217\u8868\u4e3a\u7a7a");
                } else {
                    ArrayList list = JSONUtils.object2List((Object)responseMessage.getData(), ConversationBean.class);
                    ConversationDao.getInstance().insertMultiConversationInfo((List)list);
                }
            }

            public void onFail(NetResponseMessage responseMessage) {
            }
        });
    }

    public static void saveRongToken(String rongCloudToken) {
        SpUtils.CACHE.putString("rongcloudtoken", rongCloudToken);
    }

    public static void startConversation(Activity activity, RongChatExtraBean bean, String chatType, Conversation.ConversationType conversationType, String targetId, String title) {
        RongUtil.getInstance().setChatExtraBean(bean, chatType, conversationType.getName(), targetId);
        RongIM.getInstance().startConversation((Context)activity, conversationType, targetId, title);
    }

    public static void startConversation(Context context, Conversation.ConversationType conversationType, RongChatExtraBean chatExtraBean) {
        RongUtil.getInstance().setChatExtraBean(chatExtraBean);
        String targetId = chatExtraBean.getTargetId();
        if (context == null || TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            throw new IllegalArgumentException();
        }
        context.startActivity(RongUtil.getImIntent(context, conversationType, targetId, chatExtraBean.getName()));
    }

    public static Intent getImIntent(Context context, Conversation.ConversationType conversationType, String targetId, String title) {
        Uri uri = Uri.parse((String)("rong://" + context.getApplicationInfo().processName)).buildUpon().appendPath("conversation").appendPath(conversationType.getName().toLowerCase()).appendQueryParameter("targetId", targetId).appendQueryParameter("title", title).build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.setFlags(0x10000000);
        return intent;
    }

    public void setChatExtraBean(RongChatExtraBean chatExtraBean) {
        this.chatExtraBean = chatExtraBean;
    }

    public RongChatExtraBean getChatExtraBean() {
        if (this.chatExtraBean == null) {
            return new RongChatExtraBean();
        }
        return this.chatExtraBean;
    }

    public void setChatExtraBean(RongChatExtraBean bean, String chatType, String conversationType, String targetId) {
        this.chatExtraBean = bean != null ? bean : new RongChatExtraBean();
        this.chatExtraBean.setTargetId(targetId);
        this.chatExtraBean.setName(UserInfoUtils.getUserName());
        this.chatExtraBean.setChatType(chatType);
        this.chatExtraBean.setOrderType(null != bean ? bean.getOrderType() : 0);
    }

    public static void setInputProvider() {
        List moduleList = RongExtensionManager.getInstance().getExtensionModules();
        IExtensionModule defaultModule = null;
        if (moduleList != null) {
            for (IExtensionModule module : moduleList) {
                if (!(module instanceof DefaultExtensionModule)) continue;
                defaultModule = module;
                break;
            }
            if (defaultModule != null) {
                RongExtensionManager.getInstance().unregisterExtensionModule(defaultModule);
                RongExtensionManager.getInstance().registerExtensionModule((IExtensionModule)new CaseExtensionModule());
            }
        }
    }

    public static void sendCustomMessage(String targetId, CaseCommenListBean bean) {
        CaseMessage c = new CaseMessage();
        c.setCaseTitle(bean.getTitle());
        c.setCaseContent(bean.getContent());
        c.setCaseId(bean.getUuid());
        c.setCaseTip(bean.getTags());
        Message message2 = Message.obtain((String)targetId, (Conversation.ConversationType)GROUPTYPE, (MessageContent)c);
        RongIM.getInstance().sendMessage(message2, "\u75c5\u5386\u6d88\u606f", "", new IRongCallback.ISendMessageCallback(){

            public void onAttached(Message message2) {
            }

            public void onSuccess(Message message2) {
                LogUtils.d((Object)("\u53d1\u9001\u75c5\u5386\u6d88\u606f" + ((CaseMessage)message2.getContent()).getExtra()));
            }

            public void onError(Message message2, RongIMClient.ErrorCode errorCode) {
            }
        });
    }

    public static void deleteMessages(Conversation.ConversationType conversationType, String targetId, RongIMClient.ResultCallback<Boolean> callback) {
        RongIM.getInstance().clearMessages(conversationType, targetId, callback);
        RongIM.getInstance().removeConversation(conversationType, targetId, null);
    }

    public static void insertLocalMessageList(List<Message> messages) {
        for (Message message2 : messages) {
            RongIM.getInstance().insertMessage(Conversation.ConversationType.GROUP, message2.getTargetId(), message2.getSenderUserId(), message2.getContent(), message2.getSentTime(), (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Message>(){

                public void onSuccess(Message message2) {
                }

                public void onError(RongIMClient.ErrorCode errorCode) {
                }
            });
        }
    }

    public static RongChatExtraBean getChatExtraBean(MessageContent messageContent, String conversationType) {
        String orderUuid = RongUtil.getExtraByIndex(messageContent, 0);
        String orderType = RongUtil.getExtraByIndex(messageContent, 1);
        String chatName = RongUtil.getExtraByIndex(messageContent, 2);
        String chatType = RongUtil.getExtraByIndex(messageContent, 3);
        RongChatExtraBean extraBean = new RongChatExtraBean();
        extraBean.setOrderUuid(orderUuid);
        if (!TextUtils.isEmpty((CharSequence)orderType)) {
            extraBean.setOrderType(Integer.parseInt(orderType));
        }
        extraBean.setName(chatName);
        extraBean.setChatType(chatType);
        return extraBean;
    }

    public static RongChatExtraBean getRongExtraBean(MessageContent messageContent) {
        RongChatExtraBean rongChatExtraBean = null;
        if (messageContent instanceof TextMessage) {
            String txtExtra = ((TextMessage)messageContent).getExtra();
            rongChatExtraBean = RongUtil.changeToExtraBean(txtExtra);
        } else if (messageContent instanceof ImageMessage) {
            String imgExtra = ((ImageMessage)messageContent).getExtra();
            rongChatExtraBean = RongUtil.changeToExtraBean(imgExtra);
        } else if (messageContent instanceof VoiceMessage) {
            String voiceExtra = ((VoiceMessage)messageContent).getExtra();
            rongChatExtraBean = RongUtil.changeToExtraBean(voiceExtra);
        } else if (messageContent instanceof FileMessage) {
            String fileExtra = ((FileMessage)messageContent).getExtra();
            rongChatExtraBean = RongUtil.changeToExtraBean(fileExtra);
        } else if (messageContent instanceof InviteInvaMessage) {
            String inviteExtra = ((InviteInvaMessage)messageContent).getExtra();
            rongChatExtraBean = RongUtil.changeToExtraBean(inviteExtra);
        } else if (messageContent instanceof PreDiaDescMessage) {
            String prediaExtra = ((PreDiaDescMessage)messageContent).getExtra();
            rongChatExtraBean = RongUtil.changeToExtraBean(prediaExtra);
        } else if (messageContent instanceof InformationNotificationMessage) {
            String notifyExtra = ((InformationNotificationMessage)messageContent).getExtra();
            rongChatExtraBean = RongUtil.changeToExtraBean(notifyExtra);
        } else if (messageContent instanceof JoinMettingMessage) {
            String notifyExtra = ((JoinMettingMessage)messageContent).getExtra();
            rongChatExtraBean = RongUtil.changeToExtraBean(notifyExtra);
        } else {
            return RongUtil.getInstance().getChatExtraBean();
        }
        Log.i((String)TAG, (String)("rongChatExtraBean===>" + rongChatExtraBean));
        RongUtil.getInstance().setChatExtraBean(rongChatExtraBean);
        return rongChatExtraBean;
    }

    public static RongChatExtraBean changeToExtraBean(String extra) {
        RongChatExtraBean rongChatExtraBean = null;
        if (TextUtils.isEmpty((CharSequence)extra)) {
            return RongUtil.getInstance().getChatExtraBean();
        }
        if (RongUtil.isJSONValid(extra)) {
            Gson gson = new Gson();
            rongChatExtraBean = (RongChatExtraBean)gson.fromJson(extra, RongChatExtraBean.class);
        } else {
            rongChatExtraBean = new RongChatExtraBean();
            String[] rongBeans = extra.split(",");
            Log.i((String)TAG, (String)("rongBeans==>" + rongBeans));
            if (rongBeans.length > 0) {
                rongChatExtraBean.setOrderUuid(rongBeans[0]);
            }
            if (rongBeans.length > 1 && !TextUtils.isEmpty((CharSequence)rongBeans[1])) {
                rongChatExtraBean.setChatType(rongBeans[1]);
            }
            if (rongBeans.length > 2) {
                rongChatExtraBean.setName(rongBeans[2]);
            }
            if (rongBeans.length > 3) {
                rongChatExtraBean.setOrderType(Integer.parseInt(rongBeans[3]));
            }
        }
        return rongChatExtraBean;
    }

    public static boolean isContypeMsgByChatType(int orderType) {
        return 4 == orderType || 5 == orderType || 6 == orderType;
    }

    public static List<Conversation> filterConsMsg(List<Conversation> conversations, boolean isConsMsg) {
        ArrayList<Conversation> conversationList = new ArrayList<Conversation>();
        if (isConsMsg) {
            for (Conversation conversation : conversations) {
                RongChatExtraBean rongChatExtraBean = RongUtil.getRongExtraBean(conversation.getLatestMessage());
                if (rongChatExtraBean == null) {
                    return null;
                }
                String chatTypeStr = rongChatExtraBean.getChatType();
                int chatType = TextUtils.isEmpty((CharSequence)chatTypeStr) ? -1 : Integer.parseInt(chatTypeStr);
                if (!RongUtil.isContypeMsgByChatType(chatType)) continue;
                conversationList.add(conversation);
            }
        } else {
            for (Conversation conversation : conversations) {
                RongChatExtraBean rongChatExtraBean = RongUtil.getRongExtraBean(conversation.getLatestMessage());
                if (rongChatExtraBean == null) {
                    return null;
                }
                String chatTypeStr = rongChatExtraBean.getChatType();
                int chatType = TextUtils.isEmpty((CharSequence)chatTypeStr) ? -1 : Integer.parseInt(chatTypeStr);
                if (RongUtil.isContypeMsgByChatType(chatType)) continue;
                conversationList.add(conversation);
            }
        }
        return conversationList;
    }

    public static final boolean isJSONValid(String jsonInString) {
        try {
            Gson gson = new Gson();
            gson.fromJson(jsonInString, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }

    public void sendJoinMettingMsg(String groupId, String desc, String meetNum, String phone, final OnJoinMettingCallBack joinMettingCallBack) {
        JSONObject jsonObject = new JSONObject();
        Log.i((String)TAG, (String)("sendJoinMettingMsg: desc:" + desc));
        Log.i((String)TAG, (String)("sendJoinMettingMsg: meetNum:" + meetNum));
        Log.i((String)TAG, (String)("sendJoinMettingMsg: phone:" + phone));
        try {
            jsonObject.put("MeetingInvitation", (Object)desc);
            jsonObject.put("MeetNum", (Object)meetNum);
            jsonObject.put("phone", (Object)phone);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String meetContent = jsonObject.toString();
        Log.i((String)TAG, (String)("sendJoinMettingMsg: meeContent:" + meetContent));
        JoinMettingMessage joinMettingMessage = JoinMettingMessage.obtain(meetContent);
        Message msg = Message.obtain((String)groupId, (Conversation.ConversationType)Conversation.ConversationType.PRIVATE, (MessageContent)joinMettingMessage);
        RongIM.getInstance().sendMessage(msg, null, null, (IRongCallback.ISendMessageCallback)new IRongCallback.ISendMediaMessageCallback(){

            public void onProgress(Message message2, int i) {
            }

            public void onCanceled(Message message2) {
            }

            public void onAttached(Message message2) {
            }

            public void onSuccess(Message message2) {
                if (joinMettingCallBack != null) {
                    joinMettingCallBack.onInviteOk();
                }
            }

            public void onError(Message message2, RongIMClient.ErrorCode errorCode) {
            }
        });
    }

    public void sendGroupNotifyMsg(String mGroupId, String desc) {
        InformationNotificationMessage informationNotificationMessage = InformationNotificationMessage.obtain((String)desc);
        Message msg = Message.obtain((String)mGroupId, (Conversation.ConversationType)Conversation.ConversationType.GROUP, (MessageContent)informationNotificationMessage);
        RongIM.getInstance().sendMessage(msg, null, null, (IRongCallback.ISendMessageCallback)new IRongCallback.ISendMediaMessageCallback(){

            public void onProgress(Message message2, int i) {
                Log.i((String)RongUtil.TAG, (String)("onProgress: " + i));
            }

            public void onCanceled(Message message2) {
                Log.i((String)RongUtil.TAG, (String)"onCanceled: ");
            }

            public void onAttached(Message message2) {
                Log.i((String)RongUtil.TAG, (String)"onAttached: ");
            }

            public void onSuccess(Message message2) {
                Log.i((String)RongUtil.TAG, (String)("onSuccess: message=" + message2.getObjectName()));
            }

            public void onError(Message message2, RongIMClient.ErrorCode errorCode) {
                Log.i((String)RongUtil.TAG, (String)("onError: message:" + errorCode));
            }
        });
    }

    public void saveRongIdToLocal(List<FriendsEntity> friendsEntities) {
        ArrayList<String> rongIdArraysList = new ArrayList<String>();
        for (FriendsEntity friendsEntity : friendsEntities) {
            rongIdArraysList.add(friendsEntity.getRongCloudId());
        }
        this.saveRongIdStringList(rongIdArraysList);
    }

    public void saveRongIdStringList(List<String> rongIdArraysList) {
        Gson gson = new Gson();
        String friendJson = gson.toJson(rongIdArraysList);
        SPUtils.getInstance().put("FRIENDSID_KEY", friendJson);
    }

    public boolean isFriend(String targetId) {
        return this.friendIds != null && this.friendIds.size() > 0 && this.friendIds.contains(targetId);
    }

    public void setFriendIds(List<String> friendIds) {
        this.friendIds = friendIds;
    }

    public static interface OnJoinMettingCallBack {
        public void onInviteOk();
    }

    public static interface UpdateGroupInfoCallback {
        public void onGroupInfo(ImGroupInfoEntity var1);
    }
}

