/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.module.getui;

import android.content.Context;
import com.igexin.sdk.PushManager;
import com.igexin.sdk.message.GTCmdMessage;
import com.igexin.sdk.message.GTNotificationMessage;
import com.igexin.sdk.message.GTTransmitMessage;
import com.kangxin.module.getui.ByGeTuiIntentService;
import com.kangxin.module.getui.ByGeTuiService;
import com.kangxin.module.getui.ByPushCallBack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ByPushManager {
    private static final String TAG = "ByPushManager";
    private Context mContext;
    private static ByPushManager instance;
    private Map<Class, ByPushCallBack> pushCallBacks = new HashMap<Class, ByPushCallBack>();

    private ByPushManager() {
    }

    public static ByPushManager getInstance() {
        if (instance == null) {
            instance = new ByPushManager();
        }
        return instance;
    }

    public void destory() {
        PushManager.getInstance().turnOffPush(this.mContext);
        PushManager.getInstance().stopService(this.mContext);
    }

    public static PushManager getPushInstance() {
        return PushManager.getInstance();
    }

    public void initGeTui(Context context) {
        this.mContext = context;
        PushManager.getInstance().initialize(this.mContext.getApplicationContext(), ByGeTuiService.class);
        PushManager.getInstance().turnOnPush(context);
        PushManager.getInstance().registerPushIntentService(this.mContext.getApplicationContext(), ByGeTuiIntentService.class);
    }

    public void registerPushCallBack(Class clazz, ByPushCallBack byPushCallBack) {
        if (!this.pushCallBacks.containsKey(clazz)) {
            this.pushCallBacks.put(clazz, byPushCallBack);
        }
    }

    public void unregisterPushCallBack(Class clazz) {
        if (this.pushCallBacks.containsKey(clazz)) {
            this.pushCallBacks.remove(clazz);
        }
    }

    public Map<Class, ByPushCallBack> getPushCallBacks() {
        return this.pushCallBacks;
    }

    public void onReceiveServicePid(Context context, int pid) {
        Map.Entry<Class, ByPushCallBack> next;
        boolean flag;
        Iterator<Map.Entry<Class, ByPushCallBack>> iterator = this.pushCallBacks.entrySet().iterator();
        while (iterator.hasNext() && !(flag = (next = iterator.next()).getValue().onReceiveServicePid(context, pid))) {
        }
    }

    public void onReceiveClientId(Context context, String cliendId) {
        Map.Entry<Class, ByPushCallBack> next;
        boolean flag;
        Iterator<Map.Entry<Class, ByPushCallBack>> iterator = this.pushCallBacks.entrySet().iterator();
        while (iterator.hasNext() && !(flag = (next = iterator.next()).getValue().onReceiveClientId(context, cliendId))) {
        }
    }

    public void onReceiveMessageData(Context context, GTTransmitMessage msg) {
        Map.Entry<Class, ByPushCallBack> next;
        boolean flag;
        Iterator<Map.Entry<Class, ByPushCallBack>> iterator = this.pushCallBacks.entrySet().iterator();
        while (iterator.hasNext() && !(flag = (next = iterator.next()).getValue().onReceiveMessageData(context, msg))) {
        }
    }

    public void onReceiveOnlineState(Context context, boolean state) {
        Map.Entry<Class, ByPushCallBack> next;
        boolean flag;
        Iterator<Map.Entry<Class, ByPushCallBack>> iterator = this.pushCallBacks.entrySet().iterator();
        while (iterator.hasNext() && !(flag = (next = iterator.next()).getValue().onReceiveOnlineState(context, state))) {
        }
    }

    public void onReceiveCommandResult(Context context, GTCmdMessage commandResult) {
        Map.Entry<Class, ByPushCallBack> next;
        boolean flag;
        Iterator<Map.Entry<Class, ByPushCallBack>> iterator = this.pushCallBacks.entrySet().iterator();
        while (iterator.hasNext() && !(flag = (next = iterator.next()).getValue().onReceiveCommandResult(context, commandResult))) {
        }
    }

    public void onNotificationMessageArrived(Context context, GTNotificationMessage arrivedMsg) {
        Map.Entry<Class, ByPushCallBack> next;
        boolean flag;
        Iterator<Map.Entry<Class, ByPushCallBack>> iterator = this.pushCallBacks.entrySet().iterator();
        while (iterator.hasNext() && !(flag = (next = iterator.next()).getValue().onNotificationMessageArrived(context, arrivedMsg))) {
        }
    }

    public void onNotificationMessageClicked(Context context, GTNotificationMessage clicked) {
        Map.Entry<Class, ByPushCallBack> next;
        boolean flag;
        Iterator<Map.Entry<Class, ByPushCallBack>> iterator = this.pushCallBacks.entrySet().iterator();
        while (iterator.hasNext() && !(flag = (next = iterator.next()).getValue().onNotificationMessageClicked(context, clicked))) {
        }
    }
}

