/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.mobile_video.service;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.chinamobile.ysx.YSXSdk;
import com.google.gson.Gson;
import com.kangxin.common.byh.entity.MeetingRoomEntity;
import com.kangxin.common.byh.service.IMeetingService;
import com.kangxin.common.util.SchedulesSwitch;
import com.kangxin.doctor.mobile_video.db.VideoDB;
import com.kangxin.doctor.mobile_video.db.VideoDataBase;
import com.kangxin.doctor.mobile_video.entity.TokenEntity;
import com.kangxin.doctor.mobile_video.extend.ObservableExtensionKt;
import com.kangxin.doctor.mobile_video.model.IMeetingModel;
import com.kangxin.doctor.mobile_video.model.impl.MeetingModelImpl;
import com.kangxin.doctor.mobile_video.service.MeetingService;
import com.kangxin.doctor.mobile_video.ui.joinmeeting.JoinMeetingViewModel;
import com.kangxin.doctor.mobile_video.ui.meetinghost.MeetingHostViewModel;
import com.kangxin.doctor.mobile_video.ui.meetingmembers.MeetingMemberViewModel;
import com.kangxin.doctor.mobile_video.utils.SP;
import com.kangxin.doctor.mobile_video.utils.YSX;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0017J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0013H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/kangxin/doctor/mobile_video/service/MeetingService;", "Lcom/kangxin/common/byh/service/IMeetingService;", "()V", "meetingModelImpl", "Lcom/kangxin/doctor/mobile_video/model/IMeetingModel;", "getMeetingModelImpl", "()Lcom/kangxin/doctor/mobile_video/model/IMeetingModel;", "setMeetingModelImpl", "(Lcom/kangxin/doctor/mobile_video/model/IMeetingModel;)V", "init", "", "context", "Landroid/content/Context;", "entity", "Lcom/kangxin/common/byh/entity/MeetingRoomEntity;", "invitationJoinMeeting", "Lio/reactivex/Observable;", "Lcom/kangxin/common/byh/service/IMeetingService$State;", "phone", "", "invitePhone", "joinMeeting", "meetingNumber", "meetingIsInit", "", "startMeeting", "presenterAvatar", "presenterName", "module_mobile_video_release"})
@Route(path="/meeting_service/meeting_service")
public final class MeetingService
implements IMeetingService {
    @NotNull
    private IMeetingModel meetingModelImpl = new MeetingModelImpl();

    @NotNull
    public final IMeetingModel getMeetingModelImpl() {
        return this.meetingModelImpl;
    }

    public final void setMeetingModelImpl(@NotNull IMeetingModel iMeetingModel) {
        Intrinsics.checkParameterIsNotNull((Object)iMeetingModel, (String)"<set-?>");
        this.meetingModelImpl = iMeetingModel;
    }

    public void init(@NotNull Context context, @NotNull MeetingRoomEntity entity) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        SP.INSTANCE.init(context);
        String string = new Gson().toJson((Object)entity);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Gson().toJson(entity)");
        SP.INSTANCE.saveRoomInfo(string);
        RoomDatabase roomDatabase = Room.databaseBuilder((Context)context, VideoDataBase.class, (String)"by_doctor").fallbackToDestructiveMigration().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)roomDatabase, (String)"Room.databaseBuilder(con\u2026uctiveMigration().build()");
        VideoDB.Companion.init((VideoDataBase)roomDatabase);
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        YSX.Companion.init(context2, new YSX.YSXListener(this){
            final /* synthetic */ MeetingService this$0;

            public void initSuccess() {
                ObservableExtensionKt.parse(this.this$0.getMeetingModelImpl().getToken(SP.INSTANCE.getRoomEntity().getPhone())).flatMap((Function)new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ init.1 this$0;

                    @NotNull
                    public final Observable<Integer> apply(@NotNull TokenEntity it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        IMeetingModel iMeetingModel = this.this$0.this$0.getMeetingModelImpl();
                        String string = it.getUcToken();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        return iMeetingModel.tokenLogin(string, SP.INSTANCE.getRoomEntity().getPhone());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).compose(SchedulesSwitch.applySchedulers()).subscribe((Consumer)init.initSuccess.2.INSTANCE, (Consumer)init.initSuccess.3.INSTANCE);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @NotNull
    public Observable<IMeetingService.State> startMeeting(@NotNull String phone, @NotNull String presenterAvatar, @NotNull String presenterName) {
        Intrinsics.checkParameterIsNotNull((Object)phone, (String)"phone");
        Intrinsics.checkParameterIsNotNull((Object)presenterAvatar, (String)"presenterAvatar");
        Intrinsics.checkParameterIsNotNull((Object)presenterName, (String)"presenterName");
        MeetingHostViewModel viewModel = new MeetingHostViewModel();
        viewModel.launch(phone, presenterAvatar, presenterName);
        Observable observable = viewModel.startMeetingService().flatMap((Function)startMeeting.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"viewModel.startMeetingSe\u2026)\n            }\n        }");
        return observable;
    }

    @NotNull
    public Observable<IMeetingService.State> joinMeeting(@NotNull String phone, @NotNull String meetingNumber) {
        Intrinsics.checkParameterIsNotNull((Object)phone, (String)"phone");
        Intrinsics.checkParameterIsNotNull((Object)meetingNumber, (String)"meetingNumber");
        JoinMeetingViewModel viewModel = new JoinMeetingViewModel();
        viewModel.launch(phone).getMeetingNumber().postValue((Object)meetingNumber);
        Observable observable = viewModel.joinMeeting().flatMap((Function)joinMeeting.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"viewModel.joinMeeting().\u2026)\n            }\n        }");
        return observable;
    }

    @SuppressLint(value={"CheckResult"})
    @NotNull
    public Observable<IMeetingService.State> invitationJoinMeeting(@NotNull String phone, @NotNull String invitePhone) {
        Intrinsics.checkParameterIsNotNull((Object)phone, (String)"phone");
        Intrinsics.checkParameterIsNotNull((Object)invitePhone, (String)"invitePhone");
        MeetingMemberViewModel viewModel = new MeetingMemberViewModel();
        Observable observable = viewModel.inviteMember(phone, invitePhone).flatMap((Function)invitationJoinMeeting.1.INSTANCE).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"viewModel.inviteMember(p\u2026dSchedulers.mainThread())");
        return observable;
    }

    public boolean meetingIsInit() {
        YSXSdk ySXSdk = YSXSdk.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)ySXSdk, (String)"YSXSdk.getInstance()");
        ySXSdk.isInitialized();
        YSXSdk ySXSdk2 = YSXSdk.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)ySXSdk2, (String)"YSXSdk.getInstance()");
        return ySXSdk2.isInitialized();
    }

    public void init(@Nullable Context context) {
    }
}

