/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.live;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.provider.Settings;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.constraintlayout.widget.ConstraintLayout;
import butterknife.BindView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.LiveInfoEntity;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.service.SendNotifyService;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.ILiveView;
import com.kangxin.doctor.live.R;
import com.kangxin.doctor.live.entity.RoomUserEntity;
import com.kangxin.doctor.live.globa.Global;
import com.kangxin.doctor.live.presenter.impl.LivePresenter;
import com.kangxin.doctor.live.view.IRoomView;
import com.kangxin.doctor.live2.TRTCCloudListenerImpl;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.trtc.TRTCCloud;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCCloudListener;
import com.yhao.floatwindow.FloatWindow;
import com.yhao.floatwindow.PermissionListener;
import com.yhao.floatwindow.ViewStateListener;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation.SupportFragment;
import org.greenrobot.eventbus.Subscribe;

@Route(path="/live/ByLiveActivity")
public class ByLiveActivity
extends BaseActivity
implements IRoomView,
ILiveView {
    private static final String TAG = "ByLiveActivity";
    private final int REQUEST_OVERYAL = 1;
    @BindView(value=2131427741)
    ImageView valume;
    @BindView(value=2131427628)
    ImageView switchValume;
    @BindView(value=2131427670)
    TextView type;
    @BindView(value=2131427391)
    ImageView close;
    @BindView(value=2131427627)
    ImageView switchSam;
    @BindView(value=2131427519)
    ImageView look;
    @BindView(value=2131427717)
    TextView vPatientName;
    @BindView(value=2131427688)
    TextView vDoctorName2;
    @BindView(value=2131427700)
    TextView vExpertName;
    @BindView(value=2131427687)
    TextView vDoctorName;
    @BindView(value=2131427701)
    TextView vExpertName2;
    @BindView(value=2131427734)
    TextView vTime;
    @BindView(value=2131427697)
    ConstraintLayout vExpertInvitation;
    @BindView(value=2131427715)
    ConstraintLayout vPatientInvitation;
    @BindView(value=2131427685)
    ConstraintLayout vDoctorInvitation;
    @BindView(value=2131427698)
    ConstraintLayout vExpertInvitationLayout;
    @BindView(value=2131427716)
    ConstraintLayout vPatientInvitationLayout;
    @BindView(value=2131427686)
    ConstraintLayout vDoctorInvitationLayout;
    @BindView(value=2131427740)
    ConstraintLayout vWaitLayout;
    @BindView(value=2131427714)
    TXCloudVideoView vMainView;
    @BindView(value=2131427732)
    TXCloudVideoView vSubView;
    TXCloudVideoView vFloatView;
    @BindView(value=2131427739)
    TextView vWaitEnter;
    @BindView(value=2131427729)
    ConstraintLayout vRootView;
    private ArrayList<RoomUserEntity> mMemberInfos = new ArrayList();
    @Autowired
    LiveInfoEntity patientDoctorExpertEntity;
    @Autowired
    OrderDetailEntity orderDetailEntity;
    private long mTime = 0L;
    private boolean isHavePatientMode = false;
    private boolean isValumeMode = false;
    private int manNumber = 0;
    private ArrayList<RoomUserEntity> roomUserEntities = new ArrayList();
    private boolean isComplexStream = false;
    private LivePresenter presenter = new LivePresenter(this);
    private TRTCCloudListener mTRTCCloudListener;
    private TRTCCloud mTRTCCloud;
    TRTCCloudDef.TRTCParams mTRTCParams;
    String userId;
    private boolean isSwitchViewPosition = false;
    private Disposable timer;
    private boolean isGetinRoomOk = false;

    public void start() {
        LogUtils.e((Object[])new Object[]{"ByliveActivity start()"});
        this.mTRTCCloudListener = new TRTCCloudListenerImpl(this);
        this.mTRTCCloud = TRTCCloud.sharedInstance((Context)this.mContext);
        this.mTRTCCloud.setListener(this.mTRTCCloudListener);
        ARouter.getInstance().inject((Object)this);
        this.mTRTCParams = new TRTCCloudDef.TRTCParams();
        this.mTRTCParams.roomId = Integer.parseInt(this.patientDoctorExpertEntity.getRoomId());
        this.mTRTCParams.sdkAppId = Global.SDKAPPID;
        this.mTRTCParams.userId = this.patientDoctorExpertEntity.getLoginUser();
        this.mTRTCParams.userSig = this.patientDoctorExpertEntity.getUserSign();
        Log.i((String)TAG, (String)("roomId: " + this.mTRTCParams.roomId + ", sdkAppId: " + this.mTRTCParams.sdkAppId + ", userId:" + this.mTRTCParams.userId + ", userSig: " + this.mTRTCParams.userSig));
        if (this.patientDoctorExpertEntity == null || this.mTRTCParams == null) {
            return;
        }
        if (!this.isHavePatientMode) {
            this.vDoctorInvitationLayout.setVisibility(8);
            this.vExpertInvitationLayout.setVisibility(8);
            this.vPatientInvitationLayout.setVisibility(8);
        }
        this.mTRTCCloud.enterRoom(this.mTRTCParams, 0);
        this.dispatchEvent();
        Observable interval = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS);
        interval.map(aLong -> this.mTime++).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Long>(){

            public void onSubscribe(Disposable d) {
                ByLiveActivity.this.timer = d;
            }

            public void onNext(Long aLong) {
                String s = ByLiveActivity.this.formatTimeS(aLong);
                LogUtils.e((Object[])new Object[]{"\u540e\u53f0\u8fd0\u884c" + s});
                ByLiveActivity.this.vTime.setText((CharSequence)("\u65f6\u957f\uff1a" + s));
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
        this.vMainView.setTag((Object)true);
        this.vMainView.setClickable(false);
        this.vSubView.setClickable(false);
        this.vMainView.setRenderMode(0);
        this.vSubView.setRenderMode(0);
        this.initFloat();
    }

    private void dispatchEvent() {
        this.valume.setTag((Object)true);
        this.switchSam.setTag((Object)true);
        this.switchValume.setTag((Object)true);
        this.valume.setOnClickListener(v -> {
            Boolean valumeTag = (Boolean)this.valume.getTag() == false;
            if (valumeTag.booleanValue()) {
                this.valume.setImageResource(R.mipmap.live_big_colume);
                this.mTRTCCloud.setAudioRoute(1);
            } else {
                this.valume.setImageResource(R.mipmap.ic_video_ysq_no);
                this.mTRTCCloud.setAudioRoute(0);
            }
            this.valume.setTag((Object)valumeTag);
        });
        this.switchValume.setOnClickListener(v -> {
            Boolean valumeTag = (Boolean)this.switchValume.getTag() == false;
            if (valumeTag.booleanValue()) {
                this.switchValume.setImageResource(R.mipmap.ic_video_mode_yuyin);
                this.isValumeMode = false;
                this.type.setText((CharSequence)"\u8bed\u97f3\u6a21\u5f0f");
                this.mTRTCCloud.startLocalPreview(true, this.vMainView);
            } else {
                this.switchValume.setImageResource(R.mipmap.ic_video_mode_video);
                this.isValumeMode = true;
                this.type.setText((CharSequence)"\u89c6\u9891\u6a21\u5f0f");
                this.mTRTCCloud.stopLocalPreview();
            }
            this.switchValume.setTag((Object)valumeTag);
        });
        this.close.setOnClickListener(v -> this.mTRTCCloud.exitRoom());
        this.switchSam.setOnClickListener(v -> {
            if (this.isValumeMode) {
                ToastUtils.showShort((CharSequence)"\u8bed\u97f3\u6a21\u5f0f\u4e0b\u4e0d\u80fd\u5207\u6362\u6444\u50cf\u5934");
                return;
            }
            Boolean valumeTag = (Boolean)this.switchSam.getTag() == false;
            if (valumeTag.booleanValue()) {
                this.switchSam.setImageResource(R.mipmap.live_switch_camera);
            } else {
                this.switchSam.setImageResource(R.mipmap.live_switch_camera);
            }
            this.mTRTCCloud.switchCamera();
            this.switchSam.setTag((Object)valumeTag);
        });
        this.look.setOnClickListener(v -> {
            OrderDetailEntity orderDetailEntity = this.orderDetailEntity;
            if (orderDetailEntity == null) {
                ToastUtils.showShort((CharSequence)"\u75c5\u4f8b\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u6682\u4e0d\u652f\u6301\u67e5\u770b");
                return;
            }
            SupportFragment navigation = (SupportFragment)ARouter.getInstance().build("/patient/patient_case").withString("IM_CHECK_CASE_KEY", "\u67e5\u770b\u75c5\u5386").withSerializable("orderDetailEntity", (Serializable)this.orderDetailEntity).navigation();
            this.loadRootFragment(R.id.vRootFragment, (ISupportFragment)navigation);
        });
        this.vMainView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ByLiveActivity.this.vMainView.isClickable()) {
                    ByLiveActivity.this.swapVideoView();
                }
            }
        });
        this.vSubView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ByLiveActivity.this.vSubView.isClickable()) {
                    ByLiveActivity.this.swapVideoView();
                }
            }
        });
        this.vWaitLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
    }

    private void swapVideoView() {
        this.isSwitchViewPosition = !this.isSwitchViewPosition;
        ViewGroup.LayoutParams temp = this.vMainView.getLayoutParams();
        this.vMainView.setLayoutParams(this.vSubView.getLayoutParams());
        this.vSubView.setLayoutParams(temp);
        if (((Boolean)this.vMainView.getTag()).booleanValue()) {
            this.vMainView.setTag((Object)false);
            this.vRootView.bringChildToFront((View)this.vMainView);
        } else {
            this.vMainView.setTag((Object)true);
            this.vRootView.bringChildToFront((View)this.vSubView);
        }
        CharSequence text = this.vDoctorName2.getText();
        this.vDoctorName2.setText(this.vExpertName2.getText());
        this.vExpertName2.setText(text);
    }

    public int getContentLayoutId() {
        return R.layout.by_activity_live;
    }

    @Override
    public void onEnterRoom() {
        ToastUtils.showShort((CharSequence)"\u8fdb\u5165\u623f\u95f4\u6210\u529f");
        this.mTRTCCloud.startLocalPreview(true, this.vMainView);
        this.mTRTCCloud.startLocalAudio();
        if (this.patientDoctorExpertEntity.getExpertId().equals(VertifyDataUtil.getInstance((Context)this.mContext).getDoctorId())) {
            this.vExpertName2.setText((CharSequence)this.patientDoctorExpertEntity.getExpertName());
            this.vExpertName2.setVisibility(0);
        } else {
            this.vExpertName2.setText((CharSequence)this.patientDoctorExpertEntity.getDoctorName());
            this.vExpertName2.setVisibility(0);
        }
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getUserInfo();
        Log.i((String)TAG, (String)("onEnterRoom: isGetinRoomOk:" + this.isGetinRoomOk));
        if (!this.isGetinRoomOk) {
            if (userInfoVOBean != null) {
                SendNotifyService sendNotifyService = (SendNotifyService)ARouter.getInstance().build("/video/notify/room/SendVideoRoomNotifyProvider").navigation();
                if (sendNotifyService != null) {
                    sendNotifyService.sendNotifyMsg(userInfoVOBean.getName());
                }
                Log.i((String)TAG, (String)"onEnterRoom: send video invite event");
            } else {
                ToastUtils.showLong((CharSequence)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
            }
        }
        this.isGetinRoomOk = true;
    }

    @Override
    public void onEnterRoomFailed(String module, int errCode, String errMsg) {
        ToastUtils.showShort((CharSequence)"\u8fdb\u5165\u623f\u95f4\u5931\u8d25");
        LogUtils.e((Object[])new Object[]{module + errCode + errMsg});
    }

    @Override
    public void onQuitRoomSuccess() {
        ToastUtils.showShort((CharSequence)"\u9000\u51fa\u623f\u95f4\u6210\u529f");
        this.finish();
    }

    @Override
    public void onQuitRoomFailed(String module, int errCode, String errMsg) {
        ToastUtils.showShort((CharSequence)"\u9000\u51fa\u623f\u95f4\u5931\u8d25");
    }

    @Override
    public void onRoomDisconnect(String module, int errCode, String errMsg) {
        ToastUtils.showShort((CharSequence)"\u623f\u95f4\u65ad\u5f00\u8fde\u63a5");
    }

    @Override
    public void onMemberStatusUpdate(ArrayList<RoomUserEntity> tmpList) {
        this.mMemberInfos = tmpList;
        this.roomUserEntities = tmpList;
    }

    @Override
    public void renderVideoView(boolean b, String s, int videoSrcType, boolean b1) {
        if (this.isHavePatientMode) {
            if (s.equals(this.patientDoctorExpertEntity.getPatientId())) {
                this.vPatientInvitation.setVisibility(4);
                this.vPatientName.setText((CharSequence)this.patientDoctorExpertEntity.getPatientName());
                this.vPatientName.setVisibility(0);
            } else if (s.equals(this.patientDoctorExpertEntity.getDoctorId())) {
                this.vDoctorInvitation.setVisibility(4);
                this.vDoctorName.setText((CharSequence)this.patientDoctorExpertEntity.getDoctorName());
                this.vDoctorName.setVisibility(0);
            } else if (s.equals(this.patientDoctorExpertEntity.getExpertId())) {
                this.vExpertInvitation.setVisibility(4);
                this.vExpertName.setText((CharSequence)this.patientDoctorExpertEntity.getExpertName());
                this.vExpertName.setVisibility(0);
            }
        } else {
            this.vExpertName2.setText((CharSequence)this.patientDoctorExpertEntity.getExpertName());
            this.vDoctorName2.setText((CharSequence)this.patientDoctorExpertEntity.getDoctorName());
            if (s.equals(this.patientDoctorExpertEntity.getDoctorId())) {
                this.vDoctorInvitation.setVisibility(4);
                this.vDoctorName2.setText((CharSequence)this.patientDoctorExpertEntity.getDoctorName());
                this.vDoctorName2.setVisibility(0);
            } else if (s.equals(this.patientDoctorExpertEntity.getExpertId())) {
                this.vExpertInvitation.setVisibility(4);
                this.vExpertName2.setText((CharSequence)this.patientDoctorExpertEntity.getExpertName());
                this.vExpertName2.setVisibility(0);
                this.vWaitLayout.setVisibility(8);
            }
        }
    }

    public void onBackPressedSupport() {
        if (!this.toSmallWindow()) {
            super.onBackPressedSupport();
        }
    }

    private void initFloat() {
        final ArrayList times = new ArrayList();
        this.vFloatView = new TXCloudVideoView(this.mContext);
        TextView textView = new TextView(this.mContext);
        FloatWindow.with((Context)this.mContext.getApplicationContext()).setView((View)this.vFloatView).setWidth(200).setHeight(400).setX(100).setY(1, 0.3f).setDesktopShow(true).setFilter(false, new Class[]{ByLiveActivity.class}).setViewStateListener(new ViewStateListener(){

            public void onPositionUpdate(int i, int i1) {
                LogUtils.e((Object[])new Object[]{"float live onPositionUpdate"});
                times.add(System.currentTimeMillis() / 1000L);
            }

            public void onShow() {
                LogUtils.e((Object[])new Object[]{"float live onShow"});
            }

            public void onHide() {
                LogUtils.e((Object[])new Object[]{"float live onHide"});
            }

            public void onDismiss() {
                LogUtils.e((Object[])new Object[]{"float live onDismiss"});
            }

            public void onMoveAnimStart() {
                LogUtils.e((Object[])new Object[]{"float live onMoveAnimStart"});
            }

            public void onMoveAnimEnd() {
                LogUtils.e((Object[])new Object[]{"float live onMoveAnimEnd"});
                if (times != null && times.size() != 0) {
                    long temp = (Long)times.get(times.size() - 1) - (Long)times.get(0);
                    LogUtils.e((Object[])new Object[]{"float live onTap time : " + temp});
                    if ((double)temp < 1.5) {
                        Intent intent = new Intent(ByLiveActivity.this.mContext, ByLiveActivity.class);
                        intent.putExtra("patientDoctorExpertEntity", (Serializable)ByLiveActivity.this.patientDoctorExpertEntity);
                        intent.putExtra("orderDetailEntity", (Serializable)ByLiveActivity.this.orderDetailEntity);
                        intent.addFlags(0x10020000);
                        ByLiveActivity.this.getApplication().startActivity(intent);
                        LogUtils.e((Object[])new Object[]{"float live onTap"});
                    }
                }
                times.clear();
            }

            public void onBackToDesktop() {
                LogUtils.e((Object[])new Object[]{"float live onBackToDesktop"});
            }
        }).setPermissionListener(new PermissionListener(){

            public void onSuccess() {
                LogUtils.i((Object[])new Object[]{"float live \u6743\u9650\u83b7\u53d6\u6210\u529f"});
            }

            public void onFail() {
                ToastUtils.showShort((CharSequence)"float live \u5f00\u542f\u60ac\u6d6e\u7a97\u6743\u9650\u5931\u8d25");
            }
        }).build();
    }

    private boolean toSmallWindow() {
        if (this.userId == null || this.userId.equals("")) {
            this.finish();
            return false;
        }
        this.checkPermission();
        return true;
    }

    @TargetApi(value=23)
    void checkPermission() {
        if (!Settings.canDrawOverlays((Context)this)) {
            new AlertDialog.Builder(this.mContext).setMessage((CharSequence)"\u5c0f\u7a97\u53e3\u529f\u80fd\u9700\u8981\u6253\u5f00\u60ac\u6d6e\u7a97\u6743\u9650").setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).setPositiveButton((CharSequence)"\u73b0\u5728\u5f00\u542f", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    ByLiveActivity.this.startActivityForResult(new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + ByLiveActivity.this.getPackageName()))), 1);
                }
            }).show();
        } else {
            this.moveTaskToBack(true);
            this.mTRTCCloud.stopRemoteView(this.userId);
            this.mTRTCCloud.startRemoteView(this.userId, this.vFloatView);
            FloatWindow.get().show();
        }
    }

    void openSmallWindow() {
        this.moveTaskToBack(true);
        this.mTRTCCloud.stopRemoteView(this.userId);
        this.mTRTCCloud.startRemoteView(this.userId, this.vFloatView);
        FloatWindow.get().show();
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 1) {
            this.openSmallWindow();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.userId == null || this.userId.equals("")) {
            return;
        }
        this.mTRTCCloud.stopRemoteView(this.userId);
        this.mTRTCCloud.startRemoteView(this.userId, this.vSubView);
    }

    private String formatTimeS(long seconds) {
        int temp = 0;
        StringBuffer sb = new StringBuffer();
        if (seconds > 3600L) {
            temp = (int)(seconds / 3600L);
            sb.append(seconds / 3600L < 10L ? "0" + temp + ":" : temp + ":");
            temp = (int)(seconds % 3600L / 60L);
            this.changeSeconds(seconds, temp, sb);
        } else {
            temp = (int)(seconds % 3600L / 60L);
            this.changeSeconds(seconds, temp, sb);
        }
        return sb.toString();
    }

    protected void onDestroy() {
        super.onDestroy();
        LogUtils.e((Object[])new Object[]{"ByliveActivity onDestroy()"});
        FloatWindow.destroyAll();
        this.presenter.freeTimerThread();
        if (this.timer != null) {
            this.timer.dispose();
        }
        if (this.mTRTCCloud != null) {
            this.mTRTCCloud.setListener(null);
        }
        this.mTRTCCloud = null;
        TRTCCloud.destroySharedInstance();
    }

    private void changeSeconds(long seconds, int temp, StringBuffer sb) {
        sb.append(temp < 10 ? "0" + temp + ":" : "" + temp + ":");
        temp = (int)(seconds % 3600L % 60L);
        sb.append(temp < 10 ? "0" + temp : "" + temp);
    }

    public void onUserEnter(String userId) {
        this.userId = userId;
        this.mTRTCCloud.startRemoteView(userId, this.vSubView);
        this.mTRTCCloud.stopRemoteView(userId);
        this.mTRTCCloud.startRemoteView(userId, this.vSubView);
        this.vWaitLayout.setVisibility(8);
        this.vSubView.setVisibility(0);
        this.vMainView.setClickable(true);
        this.vSubView.setClickable(true);
        String docId = VertifyDataUtil.getInstance((Context)this.mContext).getDoctorId();
        if (this.patientDoctorExpertEntity.getExpertId().equals(docId)) {
            this.vDoctorName2.setText((CharSequence)this.patientDoctorExpertEntity.getDoctorName());
            this.vDoctorName2.setVisibility(0);
        } else {
            this.vDoctorName2.setText((CharSequence)this.patientDoctorExpertEntity.getExpertName());
            this.vDoctorName2.setVisibility(0);
        }
        TRTCCloudDef.TRTCTranscodingConfig trtcTranscodingConfig = new TRTCCloudDef.TRTCTranscodingConfig();
        trtcTranscodingConfig.appId = Global.APPID;
        trtcTranscodingConfig.bizId = Global.BIZID;
        this.mTRTCCloud.setRemoteViewFillMode(userId, 1);
        this.mTRTCCloud.setMixTranscodingConfig(trtcTranscodingConfig);
        if (this.patientDoctorExpertEntity.getLoginUser().equals(this.patientDoctorExpertEntity.getExpertId())) {
            this.presenter.complexStream(this.orderDetailEntity.getOrderId(), this.orderDetailEntity.getOrderViewId());
        }
        this.presenter.complexStream(this.orderDetailEntity.getOrderId(), this.orderDetailEntity.getOrderViewId());
    }

    public void onUserExit(String userId, int reason) {
        this.userId = null;
        this.mTRTCCloud.stopRemoteView(userId);
        this.vWaitLayout.setVisibility(0);
        this.vSubView.setVisibility(8);
        this.vDoctorName2.setVisibility(8);
        this.vMainView.setClickable(false);
        this.vSubView.setClickable(false);
        this.vWaitEnter.setText((CharSequence)"\u7b49\u5f85\u5bf9\u65b9\u63a5\u53d7\u9080\u8bf7...");
        if (FloatWindow.get().isShowing()) {
            this.mTRTCCloud.exitRoom();
            ToastUtils.showShort((CharSequence)"\u5bf9\u65b9\u5df2\u6302\u65ad");
        }
    }

    public void onExitRoom() {
        this.finish();
    }

    public void onUserVideoAvailable(String userId, boolean available) {
        if (this.isSwitchViewPosition) {
            this.swapVideoView();
        }
        if (available) {
            this.mTRTCCloud.startRemoteView(userId, this.vSubView);
            this.vWaitLayout.setVisibility(8);
        } else {
            this.vSubView.clearLastFrame(!available);
            this.vWaitEnter.setText((CharSequence)"\u7528\u6237\u5173\u95ed\u6444\u50cf\u5934");
            this.vWaitLayout.setVisibility(0);
        }
    }

    @Subscribe
    public void subscribeOutLogin(ByhCommEvent.ExitAppOk exitAppOk) {
        this.mTRTCCloud.exitRoom();
    }
}

