/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.live.presenter.impl;

import android.app.Activity;
import android.content.Context;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.LiveInfoEntity;
import com.kangxin.common.byh.entity.LiveResponseEntity;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.module.ILiveModule;
import com.kangxin.common.byh.present.ILivePresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.ILiveView;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.doctor.live.module.impl.LiveModule;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

@Route(path="/live/liveservice")
public class LivePresenter
implements ILivePresenter {
    ILiveModule mLiveModule;
    private ILiveView mLiveView;
    private OrderDetailEntity orderDetailEntity;
    Disposable mDisposable;
    private boolean isDebug = false;

    public LivePresenter() {
    }

    public LivePresenter(ILiveView mLiveView) {
        this.mLiveView = mLiveView;
        this.mLiveModule = new LiveModule();
    }

    public void loginLiveAndEnterRoom(OrderDetailEntity orderDetailEntity, int userType) {
        this.orderDetailEntity = orderDetailEntity;
        this.loginLiveAndEnterRoom(orderDetailEntity.getPatientId(), orderDetailEntity.getPatientTel(), orderDetailEntity.getDocId(), orderDetailEntity.getDocTel(), orderDetailEntity.getExpertId(), orderDetailEntity.getExpertTel(), orderDetailEntity.getPatientName(), orderDetailEntity.getDocName(), orderDetailEntity.getExpertName(), orderDetailEntity.getOrderId(), userType);
    }

    public void loginLiveAndEnterRoom(long patientId, String patientPhone, int doctorId, String doctorPhone, long expertId, String expertPhone, String patientName, String doctorName, String expertName, long orderId, int userType) {
        LiveInfoEntity patientDoctorExpertEntity = new LiveInfoEntity();
        patientDoctorExpertEntity.setDoctorId(doctorId + "");
        patientDoctorExpertEntity.setExpertId(expertId + "");
        patientDoctorExpertEntity.setPatientId(patientId + "");
        patientDoctorExpertEntity.setPatientName(patientName + "");
        patientDoctorExpertEntity.setExpertName(expertName + "");
        patientDoctorExpertEntity.setDoctorName(doctorName + "");
        if (userType == 1) {
            patientDoctorExpertEntity.setLoginUser(patientId + "");
        } else if (userType == 3) {
            patientDoctorExpertEntity.setLoginUser(doctorId + "");
        } else if (userType == 2) {
            patientDoctorExpertEntity.setLoginUser(expertId + "");
        }
        String thirdSdkAccount = VertifyDataUtil.getInstance((Context)this.mLiveView.injectContext()).getLoginData().getSdkLogin().getThirdSdkAccount();
        patientDoctorExpertEntity.setLoginUser(thirdSdkAccount);
        this.loginLiveAndEnterRoom(patientDoctorExpertEntity, orderId);
    }

    public void loginLiveAndEnterRoom(final LiveInfoEntity patientDoctorExpertEntity, long orderId) {
        if (this.isDebug) {
            String sign = "";
            if (orderId == 1L) {
                sign = "eJxlj11PgzAYhe-5FaS3M9oW6oiJFwviUieLZDi5a6Ats5l8WN4RNuN-V1Ejief2eXJOzpvjui5K7zfnuZTNoQYBx1Yj98pFGJ39wbY1SuQgPKv*QT20xmqRl6DtCAljjGI8dYzSNZjS-BhPuhBgQQpMJlKn9mJc*m7xPyuCYO4FU8XsRhhHjyFPwqDEzwZgWD9Ux-60eY2rl2W24NlW8YgumpWle1IXM7btE77jt*v0RFp1N1w0YVRhr1te5laXN9JP5IrCLJMkSgt9sPH1ZBJMpX9vETz3KWUT2mvbmaYeBYoJI9TDX0HOu-MB22hfXw__";
            }
            if (orderId == 2L) {
                sign = "eJxlj0FLwzAAhe-9FSFnsUma0CJ4qNqxlQ6ZnVO8hCxN11DMsjTGDfG-q1Wx4Lt*H*-x3iIAAFxX9bmQcv9iPPcnqyC4ABDBsz9orW648DxxzT*ojlY7xUXrlRshZowRhKaObpTxutU-xoPacu*85IhMpKHp*bj03UI-K7IsTbKponcjXBb314sr4kshRYdu44Nq54cbs1PzokTVqqR2O*tr0i8EDfkQD7kuchxL2YdTuKOrTXia5d0j2VRLMaSdTHElU2dqdHxdU9bIy8mk18-q9xZGKSWETWhQbtB7MwoEYYZJgr4Co-foA3qiXr8_";
            }
            if (orderId == 3L) {
                sign = "eJxlj0FPg0AYRO-8CrJXjS4sC9TEA0WMxEIVbU162VD4wA0Ky7KYQuN-V1EjiXN9LzOZo6brOnpcPZylWdb0tWJqEID0Cx1hdPoHheA5SxUjMv8H4SC4BJYWCuQEDUqpifHc4TnUihf8x3iCPVNSZQyTmdTlFZuWvluszwrXdYg7V3g5wSjY*KEX3g6j7A-RSE-cHAhd30V2*3y1hG5pl5jcq5shqCxBrMTjgdf0Vbj1250ndtbL6rpspe9sF4W9dxZREp*LmI9QxX6WrDeXs0nFX*H3loEdyzTpjL6B7HhTT4KJDWqYBH8Fae-aB3IlXqI_";
            }
            patientDoctorExpertEntity.setRoomId(patientDoctorExpertEntity.getRoomId());
            patientDoctorExpertEntity.setUserSign(sign);
            ARouter.getInstance().build("/live/ByLiveActivity").withFlags(0x20000000).withSerializable("patientDoctorExpertEntity", (Serializable)patientDoctorExpertEntity).withSerializable("orderDetailEntity", (Serializable)this.orderDetailEntity).navigation(this.mLiveView.injectContext());
            return;
        }
        this.mLiveModule.getNativeUserSign(this.mLiveView.injectContext(), patientDoctorExpertEntity.getRoomId(), patientDoctorExpertEntity.getLoginUser()).filter(responseBody -> {
            if (responseBody.getCode() == 200) {
                return true;
            }
            this.mLiveView.error(responseBody.getMsg());
            return false;
        }).map(responseBody -> (LiveResponseEntity)responseBody.getResult()).map(liveResponseEntity -> {
            patientDoctorExpertEntity.setRoomId(this.orderDetailEntity.getRoomId());
            patientDoctorExpertEntity.setUserSign(liveResponseEntity.getUserSig());
            return patientDoctorExpertEntity;
        }).subscribe((Observer)new ProgressDialogObserver<LiveInfoEntity>(){

            public void onNext(LiveInfoEntity liveInfoEntity) {
                this.onComplete();
                ToastUtils.showShort((CharSequence)"\u4fe1\u606f\u6210\u529f===");
                Context context = LivePresenter.this.mLiveView.injectContext();
                boolean b = context instanceof Activity;
                ARouter.getInstance().build("/live/ByLiveActivity").withFlags(0x20000000).withSerializable("patientDoctorExpertEntity", (Serializable)patientDoctorExpertEntity).withSerializable("orderDetailEntity", (Serializable)LivePresenter.this.orderDetailEntity).navigation(LivePresenter.this.mLiveView.injectContext());
            }

            protected Context attachContext() {
                return LivePresenter.this.mLiveView.injectContext();
            }
        });
    }

    public void complexStream(long orderId, String orderViewId) {
        this.mLiveModule.complexStream(orderId, orderViewId).doOnSubscribe((Consumer)new Consumer<Disposable>(){

            public void accept(Disposable disposable) throws Exception {
                LogUtils.i((Object[])new Object[]{"\u8ba2\u9605"});
            }
        }).doOnNext((Consumer)new Consumer<ResponseBody>(){

            public void accept(ResponseBody responseBody) throws Exception {
                LogUtils.i((Object[])new Object[]{"\u54cd\u5e94\u4f53" + responseBody.toString()});
            }
        }).doOnError((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                LogUtils.i((Object[])new Object[]{"\u5f02\u5e38"});
            }
        }).delay(5L, TimeUnit.SECONDS, true).repeat(5L).retry().subscribe((Observer)new SampleObserver<ResponseBody>(){

            public void onSubscribe(Disposable d) {
                super.onSubscribe(d);
                LivePresenter.this.mDisposable = d;
            }

            public void onNext(ResponseBody t) {
                Integer code = t.getCode();
                if (code != 200) {
                    this.onError(new RuntimeException("\u9519\u8bef"));
                } else {
                    LogUtils.i((Object[])new Object[]{"\u6df7\u6d41\u6210\u529f-\u5173\u95ed\u4efb\u52a1"});
                    LivePresenter.this.mDisposable.dispose();
                }
            }

            public void onError(Throwable e) {
                super.onError(e);
                e.printStackTrace();
                LogUtils.i((Object[])new Object[]{"\u7f51\u7edc\u5f02\u5e38"});
            }
        });
    }

    public void freeTimerThread() {
        if (this.mDisposable != null) {
            this.mDisposable.dispose();
        }
    }

    public void init(final Context context) {
        this.mLiveView = new ILiveView(){

            public void error(String s) {
            }

            public Context injectContext() {
                return context;
            }

            public void error() {
            }
        };
        this.mLiveModule = new LiveModule();
    }
}

