/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.live2;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kangxin.doctor.live.R;
import com.tencent.rtmp.TXLog;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.util.ArrayList;

public class TRTCVideoViewLayout
extends RelativeLayout {
    private static final String TAG = TRTCVideoViewLayout.class.getSimpleName();
    public static final int MODE_FLOAT = 1;
    public static final int MODE_GRID = 2;
    public static final int MAX_USER = 7;
    private Context mContext;
    private ArrayList<TXCloudVideoView> mVideoViewList;
    private ArrayList<RelativeLayout.LayoutParams> mFloatParamList;
    private ArrayList<RelativeLayout.LayoutParams> mGrid4ParamList;
    private ArrayList<RelativeLayout.LayoutParams> mGrid9ParamList;
    private RelativeLayout mLayout;
    private int mCount = 0;
    private int mMode = 1;
    private String mSelfUserId;

    public TRTCVideoViewLayout(Context context) {
        super(context);
        this.initView(context);
    }

    public TRTCVideoViewLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public TRTCVideoViewLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    public void setUserId(String userId) {
        this.mSelfUserId = userId;
    }

    private void initView(Context context) {
        this.mContext = context;
        LayoutInflater.from((Context)context).inflate(R.layout.by_room_show_view, (ViewGroup)this);
        this.mLayout = (RelativeLayout)this.findViewById(R.id.ll_mainview);
        this.initFloatLayoutParams();
        this.initTXCloudVideoView();
        this.initGridLayoutParams();
        this.showView();
        this.mMode = 1;
    }

    private void showView() {
        this.mLayout.removeAllViews();
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            TXCloudVideoView cloudVideoView = this.mVideoViewList.get(i);
            RelativeLayout.LayoutParams layoutParams = this.mFloatParamList.get(i);
            cloudVideoView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mLayout.addView((View)cloudVideoView);
        }
    }

    public void initGridLayoutParams() {
        this.mGrid4ParamList = new ArrayList();
        this.mGrid9ParamList = new ArrayList();
        int statusH = this.getStatusBarHeight(this.mContext);
        TXLog.i((String)TAG, (String)("statusH:" + statusH));
        int screenW = this.getScreenWidth(this.mContext);
        int screenH = this.getScreenHeight(this.mContext);
        int bottomMargin = this.dip2px(50.0f);
        int margin = this.dip2px(10.0f);
        this.initGrid4Param(statusH, screenW, screenH, bottomMargin, margin);
        this.initGrid9Param(statusH, screenW, screenH, bottomMargin, margin);
    }

    private void initGrid4Param(int statusH, int screenW, int screenH, int bottomMargin, int margin) {
        int grid4W = (screenW - margin * 2) / 2;
        int grid4H = (screenH - statusH - margin * 2 - bottomMargin) / 2;
        RelativeLayout.LayoutParams layoutParams0 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams0.addRule(9);
        layoutParams0.addRule(10);
        layoutParams0.topMargin = margin;
        layoutParams0.leftMargin = margin;
        RelativeLayout.LayoutParams layoutParams1 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams1.addRule(11);
        layoutParams1.addRule(10);
        layoutParams1.topMargin = margin;
        layoutParams1.rightMargin = margin;
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams2.addRule(9);
        layoutParams2.addRule(12);
        layoutParams2.bottomMargin = margin + bottomMargin;
        layoutParams2.leftMargin = margin;
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams3.addRule(11);
        layoutParams3.addRule(12);
        layoutParams3.bottomMargin = margin + bottomMargin;
        layoutParams3.rightMargin = margin;
        this.mGrid4ParamList.add(layoutParams0);
        this.mGrid4ParamList.add(layoutParams1);
        this.mGrid4ParamList.add(layoutParams2);
        this.mGrid4ParamList.add(layoutParams3);
    }

    private void initGrid9Param(int statusH, int screenW, int screenH, int bottomMargin, int margin) {
        int grid9W = (screenW - margin * 2) / 3;
        int grid9H = (screenH - statusH - margin * 2 - bottomMargin) / 3;
        RelativeLayout.LayoutParams layoutParams0 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams0.addRule(9);
        layoutParams0.addRule(10);
        layoutParams0.topMargin = margin;
        layoutParams0.leftMargin = margin;
        RelativeLayout.LayoutParams layoutParams1 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams1.addRule(14);
        layoutParams1.addRule(10);
        layoutParams1.topMargin = margin;
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams2.addRule(11);
        layoutParams2.addRule(10);
        layoutParams2.topMargin = margin;
        layoutParams2.rightMargin = margin;
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams3.addRule(10);
        layoutParams3.addRule(9);
        layoutParams3.leftMargin = margin;
        layoutParams3.topMargin = margin + grid9H;
        RelativeLayout.LayoutParams layoutParams4 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams4.addRule(14);
        layoutParams4.topMargin = margin + grid9H;
        RelativeLayout.LayoutParams layoutParams5 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams5.addRule(10);
        layoutParams5.addRule(11);
        layoutParams5.topMargin = margin + grid9H;
        layoutParams5.rightMargin = margin;
        RelativeLayout.LayoutParams layoutParams6 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams6.addRule(9);
        layoutParams6.addRule(12);
        layoutParams6.bottomMargin = margin + bottomMargin;
        layoutParams6.leftMargin = margin;
        RelativeLayout.LayoutParams layoutParams7 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams7.addRule(14);
        layoutParams7.addRule(12);
        layoutParams7.bottomMargin = margin + bottomMargin;
        RelativeLayout.LayoutParams layoutParams8 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams8.addRule(11);
        layoutParams8.addRule(12);
        layoutParams8.bottomMargin = margin + bottomMargin;
        layoutParams8.rightMargin = margin;
        this.mGrid9ParamList.add(layoutParams0);
        this.mGrid9ParamList.add(layoutParams1);
        this.mGrid9ParamList.add(layoutParams2);
        this.mGrid9ParamList.add(layoutParams3);
        this.mGrid9ParamList.add(layoutParams4);
        this.mGrid9ParamList.add(layoutParams5);
        this.mGrid9ParamList.add(layoutParams6);
        this.mGrid9ParamList.add(layoutParams7);
        this.mGrid9ParamList.add(layoutParams8);
    }

    public void initFloatLayoutParams() {
        RelativeLayout.LayoutParams layoutParams;
        int i;
        this.mFloatParamList = new ArrayList();
        RelativeLayout.LayoutParams layoutParams0 = new RelativeLayout.LayoutParams(-1, -1);
        this.mFloatParamList.add(layoutParams0);
        int midMargin = this.dip2px(10.0f);
        int lrMargin = this.dip2px(15.0f);
        int bottomMargin = this.dip2px(50.0f);
        int subWidth = this.dip2px(120.0f);
        int subHeight = this.dip2px(180.0f);
        for (i = 0; i < 3; ++i) {
            layoutParams = new RelativeLayout.LayoutParams(subWidth, subHeight);
            layoutParams.addRule(12);
            layoutParams.addRule(11);
            layoutParams.rightMargin = lrMargin;
            layoutParams.bottomMargin = bottomMargin + midMargin * (i + 1) + subHeight * i;
            this.mFloatParamList.add(layoutParams);
        }
        for (i = 0; i < 3; ++i) {
            layoutParams = new RelativeLayout.LayoutParams(subWidth, subHeight);
            layoutParams.addRule(12);
            layoutParams.addRule(9);
            layoutParams.leftMargin = lrMargin;
            layoutParams.bottomMargin = bottomMargin + midMargin * (i + 1) + subHeight * i;
            this.mFloatParamList.add(layoutParams);
        }
    }

    public void initTXCloudVideoView() {
        this.mVideoViewList = new ArrayList();
        for (int i = 0; i < 7; ++i) {
            TXCloudVideoView cloudVideoView = new TXCloudVideoView(this.mContext);
            cloudVideoView.setVisibility(8);
            cloudVideoView.setId(1000 + i);
            cloudVideoView.setClickable(true);
            cloudVideoView.setTag(R.string.str_tag_pos, (Object)i);
            cloudVideoView.setBackgroundColor(-16777216);
            this.mVideoViewList.add(i, cloudVideoView);
        }
    }

    public TXCloudVideoView getCloudVideoViewByIndex(int index) {
        return this.mVideoViewList.get(index);
    }

    public void updateLayoutFloat() {
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            TXCloudVideoView cloudVideoView = this.mVideoViewList.get(i);
            if (i < this.mFloatParamList.size()) {
                RelativeLayout.LayoutParams layoutParams = this.mFloatParamList.get(i);
                cloudVideoView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            cloudVideoView.setTag(R.string.str_tag_pos, (Object)i);
            cloudVideoView.setClickable(true);
            cloudVideoView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = (Integer)v.getTag(R.string.str_tag_pos);
                    TXCloudVideoView renderView = (TXCloudVideoView)v;
                    TXLog.i((String)TAG, (String)("click on pos: " + pos + "/userId: " + renderView.getUserId()));
                    if (null != renderView.getUserId()) {
                        TRTCVideoViewLayout.this.swapViewByIndex(0, pos);
                    }
                }
            });
            if (i == 0) continue;
            this.mLayout.bringChildToFront((View)cloudVideoView);
        }
    }

    public void updateLayoutGrid() {
        ArrayList<RelativeLayout.LayoutParams> paramList = this.mCount <= 4 ? this.mGrid4ParamList : this.mGrid9ParamList;
        int layoutIndex = 1;
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            TXCloudVideoView cloudVideoView = this.mVideoViewList.get(i);
            cloudVideoView.setClickable(false);
            cloudVideoView.setOnClickListener(null);
            String userId = cloudVideoView.getUserId();
            if (TextUtils.isEmpty((CharSequence)userId)) continue;
            if (userId.equalsIgnoreCase(this.mSelfUserId)) {
                cloudVideoView.setLayoutParams((ViewGroup.LayoutParams)paramList.get(0));
                continue;
            }
            if (layoutIndex >= paramList.size()) continue;
            cloudVideoView.setLayoutParams((ViewGroup.LayoutParams)paramList.get(layoutIndex++));
        }
    }

    public int changeMode() {
        if (this.mMode == 1) {
            this.mMode = 2;
            this.updateLayoutGrid();
        } else {
            this.mMode = 1;
            this.updateLayoutFloat();
        }
        return this.mMode;
    }

    public void swapViewByIndex(int src, int dst) {
        TXLog.i((String)TAG, (String)("swapViewByIndex src:" + src + ",dst:" + dst));
        TXCloudVideoView srcView = this.mVideoViewList.get(src);
        TXCloudVideoView dstView = this.mVideoViewList.get(dst);
        this.mVideoViewList.set(src, dstView);
        this.mVideoViewList.set(dst, srcView);
        if (this.mMode == 1) {
            this.updateLayoutFloat();
        } else {
            this.updateLayoutGrid();
        }
    }

    public void appendEventMessage(String userId, String message) {
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            if (!userId.equalsIgnoreCase(this.mVideoViewList.get(i).getUserId())) continue;
            this.mVideoViewList.get(i).appendEventInfo(message);
            break;
        }
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void showDebugView(int type) {
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            String vUserId;
            TXCloudVideoView renderView = this.mVideoViewList.get(i);
            if (renderView == null || TextUtils.isEmpty((CharSequence)(vUserId = renderView.getUserId()))) continue;
            renderView.showVideoDebugLog(type);
        }
    }

    public TXCloudVideoView onMemberEnter(String userId) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return null;
        }
        TXCloudVideoView videoView = null;
        int posIdx = 0;
        int posLocal = this.mVideoViewList.size();
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            TXCloudVideoView renderView = this.mVideoViewList.get(i);
            if (renderView == null) continue;
            String vUserId = renderView.getUserId();
            if (userId.equalsIgnoreCase(vUserId)) {
                return renderView;
            }
            if (videoView == null && TextUtils.isEmpty((CharSequence)vUserId)) {
                renderView.setUserId(userId);
                videoView = renderView;
                posIdx = i;
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)vUserId) || !vUserId.equalsIgnoreCase(this.mSelfUserId)) continue;
            posLocal = i;
        }
        TXLog.i((String)"lyj", (String)("onMemberEnter->posIdx: " + posIdx + ", posLast: " + posLocal));
        if (0 == posLocal) {
            this.swapViewByIndex(posIdx, posLocal);
        }
        ++this.mCount;
        if (this.mMode == 1) {
            this.updateLayoutFloat();
        } else {
            this.updateLayoutGrid();
        }
        return videoView;
    }

    public void onMemberLeave(String userId) {
        int posIdx = -1;
        int posLocal = this.mVideoViewList.size();
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            TXCloudVideoView renderView = this.mVideoViewList.get(i);
            if (renderView == null || null == renderView.getUserId()) continue;
            if (renderView.getUserId().equals(userId)) {
                renderView.setUserId(null);
                renderView.setVisibility(8);
                posIdx = i;
                continue;
            }
            if (!renderView.getUserId().equalsIgnoreCase(this.mSelfUserId)) continue;
            posLocal = i;
        }
        if (0 == posIdx) {
            this.swapViewByIndex(posIdx, posLocal);
        }
        if (posIdx != -1) {
            --this.mCount;
        }
        if (this.mMode == 1) {
            this.updateLayoutFloat();
        } else {
            this.updateLayoutGrid();
        }
    }

    public void onRoomEnter() {
        ++this.mCount;
        if (this.mMode == 1) {
            this.updateLayoutFloat();
        } else {
            this.updateLayoutGrid();
        }
    }

    public int getScreenWidth(Context context) {
        if (context == null) {
            return 0;
        }
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        return dm.widthPixels;
    }

    public int getScreenHeight(Context context) {
        if (context == null) {
            return 0;
        }
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        return dm.heightPixels;
    }

    public int getStatusBarHeight(Context context) {
        int statusBarHeight1 = -1;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight1 = context.getResources().getDimensionPixelSize(resourceId);
        }
        return statusBarHeight1;
    }
}

