/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.utils;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import androidx.appcompat.app.AlertDialog;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.kangxin.common.byh.inter.ILive;
import com.kangxin.doctor.Global;
import com.kangxin.doctor.libdata.http.callback.DownloadCallback;
import com.kangxin.doctor.libdata.http.utils.OkHttpUtils;
import com.tencent.rtmp.TXLiveBase;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

@Route(path="/liveservice/lib_init")
public class LibUtil
implements ILive {
    final int so_count = 5;
    CountDownLatch count = new CountDownLatch(5);
    String libPath;
    ProgressDialog dialog;
    AlertDialog alertDialog;
    private DownloadCallback mCallback;

    private File createLibDir() {
        File file = new File(this.libPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public boolean checkLibStatus(Context context) {
        return true;
    }

    private void initAlertDialog(final Context context) {
        this.alertDialog = new AlertDialog.Builder(context).setMessage((CharSequence)"\u68c0\u6d4b\u5230\u60a8\u9996\u6b21\u4f7f\u7528\u8be5\u529f\u80fd\uff0c\u9700\u8981\u8054\u7f51\u4e0b\u8f7d\u5927\u7ea610M\u7684\u670d\u52a1\u5305").setPositiveButton((CharSequence)"\u7acb\u5373\u4e0b\u8f7d", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface a, int which) {
                LibUtil.this.dialog.show();
                LibUtil.this.download(context, LibUtil.this.mCallback);
            }
        }).create();
    }

    private void initDialog(Context context) {
        this.dialog = new ProgressDialog(context);
        this.dialog.setMax(5);
        this.dialog.setProgressStyle(1);
        this.dialog.setMessage((CharSequence)"\u6b63\u5728\u52a0\u8f7d\u7ec4\u4ef6...");
    }

    public void loadLiveSdk() {
        TXLiveBase.setLibraryPath((String)this.libPath);
    }

    public void downloadSos(Context context, DownloadCallback callback) {
        if (this.checkLibStatus(context)) {
            callback.onSucc("\u6210\u529f");
            return;
        }
        this.mCallback = callback;
    }

    private void download(final Context context, final DownloadCallback callback) {
        for (int i = 0; i < 5; ++i) {
            this.downloadLiveSo(context, "https://ihos.ebaiyihui.com/" + Global.libs[i], new DownloadCallback(){

                public void onSucc(String destFileDir) {
                    LibUtil.this.count.countDown();
                    LibUtil.this.dialog.setProgress((int)(5L - LibUtil.this.count.getCount()));
                    if (LibUtil.this.count.getCount() == 0L) {
                        ((Activity)context).runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                callback.onSucc("\u4e0b\u8f7d\u5b8c\u6210");
                                LibUtil.this.loadLiveSdk();
                                LibUtil.this.dialog.cancel();
                            }
                        });
                    }
                }

                public void onFail(IOException e, String destFileDir) {
                }
            });
        }
    }

    private void downloadLiveSo(Context context, String downloadUrl, final DownloadCallback callback) {
        OkHttpUtils.getInstance().downLoadFile(context, downloadUrl, this.libPath, new DownloadCallback(){

            public void onSucc(String destFileDir) {
                callback.onSucc(destFileDir);
            }

            public void onFail(IOException e, String destFileDir) {
                e.printStackTrace();
            }
        });
    }

    public void init(Context context) {
    }
}

