/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.doctor.worktable.ManagerBankCardsFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.RequestWithRawCashFragment;
import com.kangxin.doctor.worktable.adapter.AccountBillinfoAdapter;
import com.kangxin.doctor.worktable.entity.AccountBillInfoEntity;
import com.kangxin.doctor.worktable.entity.AccountBillinfoDataEntity;
import com.kangxin.doctor.worktable.entity.BoundBankCardsInfoEntity;
import com.kangxin.doctor.worktable.entity.v2.DocDetailEntity;
import com.kangxin.doctor.worktable.presenter.IGetWithdrawalAmountPresenter;
import com.kangxin.doctor.worktable.presenter.impl.AccountBalancePersenter;
import com.kangxin.doctor.worktable.presenter.impl.AccountBillInfoPersenter;
import com.kangxin.doctor.worktable.presenter.impl.BankCardsInfoPresenter;
import com.kangxin.doctor.worktable.presenter.impl.GetWithdrawalAmountPresenter;
import com.kangxin.doctor.worktable.util.TimeUtil;
import com.kangxin.doctor.worktable.view.IAccountBalanceView;
import com.kangxin.doctor.worktable.view.IAccountBillinfoView;
import com.kangxin.doctor.worktable.view.IBankCardsInfoView;
import com.kangxin.doctor.worktable.view.IGetWithdrawalAmountView;
import com.kangxin.doctor.worktable.widget.CustomDatePicker;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.yokeyword.fragmentation.ISupportFragment;
import org.jetbrains.annotations.NotNull;

public class AccountIncomeFragment
extends BaseFragment
implements IToolView,
IAccountBalanceView,
IAccountBillinfoView,
IBankCardsInfoView,
IGetWithdrawalAmountView {
    private static final String TAG = "AccountIncomeFragment";
    @BindView(value=2131428096)
    RecyclerView vBudgetList;
    @BindView(value=2131428252)
    SmartRefreshLayout vRefreshLayout;
    private TextView mAccountBanlanceTv;
    private AccountBalancePersenter mAccountBalancePersenter;
    private AccountBillInfoPersenter mAccountBillInfoPersenter;
    private BankCardsInfoPresenter mBankCardsInfoPresenter;
    private IGetWithdrawalAmountPresenter mGetWithdrawalAmountPresenter;
    private ExpertInfoEntity.UserInfoVOBean mUserInfo;
    private List<AccountBillinfoDataEntity.ContentBean> mDatas = new ArrayList<AccountBillinfoDataEntity.ContentBean>();
    private AccountBillinfoAdapter mAccountBillinfoAdapter;
    private LinearLayout mDateSelecter;
    private TextView mBudgetTv;
    private ImageView mBudgetImg;
    private CustomDatePicker mCustomDatePicker;
    private int mLoadIndex = 1;
    private String mSelectTime;
    private TextView mQequestWithdrawCashTv;
    private TextView mWithdrawalAccountTv;

    public void init() {
        this.mUserInfo = VertifyDataUtil.getInstance((Context)this.getContext()).getUserInfo();
        this.initDatePicker();
        this.initViews();
    }

    private void reqAcountBillInfo(int pageNum, int pageSize) {
        AccountBillInfoEntity accountBillInfoEntity = new AccountBillInfoEntity();
        accountBillInfoEntity.setPageNum(pageNum);
        accountBillInfoEntity.setPageSize(pageSize);
        AccountBillInfoEntity.QueryBean queryBean = new AccountBillInfoEntity.QueryBean();
        String[] times = this.mSelectTime.split("-");
        this.mSelectTime = times[0] + "-" + times[1];
        queryBean.setEndDate(this.mSelectTime);
        String doctorId = VertifyDataUtil.getInstance((Context)this.getContext()).getDoctorId();
        queryBean.setObjectId(doctorId);
        queryBean.setStartDate(this.mSelectTime);
        accountBillInfoEntity.setQuery(queryBean);
        this.mAccountBillInfoPersenter.sendAccountBillinfo(accountBillInfoEntity, false);
    }

    private void initAcountBillInfo(int pageNum, int pageSize) {
        AccountBillInfoEntity accountBillInfoEntity = new AccountBillInfoEntity();
        accountBillInfoEntity.setPageNum(pageNum);
        accountBillInfoEntity.setPageSize(pageSize);
        AccountBillInfoEntity.QueryBean queryBean = new AccountBillInfoEntity.QueryBean();
        String doctorId = VertifyDataUtil.getInstance((Context)this.getContext()).getDoctorId();
        queryBean.setObjectId(doctorId);
        accountBillInfoEntity.setQuery(queryBean);
        this.mAccountBillInfoPersenter.sendAccountBillinfo(accountBillInfoEntity, false);
    }

    private void initViews() {
        this.mAccountBalancePersenter = new AccountBalancePersenter(this);
        this.mBankCardsInfoPresenter = new BankCardsInfoPresenter(this);
        this.mAccountBillInfoPersenter = new AccountBillInfoPersenter(this);
        this.mGetWithdrawalAmountPresenter = new GetWithdrawalAmountPresenter(this);
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.my_account_income_title));
        this.vToolRightView.setImageDrawable(this.getResources().getDrawable(R.drawable.commbyh_by_bank_card_icon));
        this.vToolRightView.setOnClickListener(v -> {
            ManagerBankCardsFragment managerBankCardsFragment = new ManagerBankCardsFragment();
            Bundle bundle = new Bundle();
            bundle.putInt("index", 1);
            managerBankCardsFragment.setArguments(bundle);
            this.start((ISupportFragment)managerBankCardsFragment);
        });
        this.mSelectTime = this.getCurTime().split(" ")[0];
        this.mAccountBanlanceTv = (TextView)this.findViewById(this.rootView, R.id.account_balance_tv);
        this.mBudgetTv = (TextView)this.findViewById(this.rootView, R.id.budget_tv);
        this.mBudgetImg = (ImageView)this.findViewById(this.rootView, R.id.budget_img);
        this.mQequestWithdrawCashTv = (TextView)this.findViewById(this.rootView, R.id.request_withdraw_cashtv);
        this.vRefreshLayout.setOnRefreshListener(refreshlayout -> {
            this.mLoadIndex = 1;
            this.reqAcountBillInfo(this.mLoadIndex, 10);
        });
        this.vRefreshLayout.setOnLoadmoreListener(refreshlayout -> {
            ++this.mLoadIndex;
            this.reqAcountBillInfo(this.mLoadIndex, 10);
        });
        this.mDateSelecter = (LinearLayout)this.findViewById(this.rootView, R.id.month_budget_layout);
        this.mDateSelecter.setOnClickListener((View.OnClickListener)new SelectDateOnClickListener());
        this.reqAcountBillInfo(1, 10);
        this.mAccountBillinfoAdapter = new AccountBillinfoAdapter(this.mDatas, this.getMContext());
        this.vBudgetList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.vBudgetList.setAdapter((RecyclerView.Adapter)this.mAccountBillinfoAdapter);
        this.mAccountBalancePersenter.reqGetAccountBalance(this.getContext(), false);
        this.mGetWithdrawalAmountPresenter.getWithdrawalAmount(this.getContext(), true);
        this.mWithdrawalAccountTv = (TextView)this.findViewById(this.rootView, R.id.withdrawal_account_tv);
    }

    private void initDatePicker() {
        this.mCustomDatePicker = new CustomDatePicker(this.getMContext(), this.getContext().getResources().getString(R.string.please_select_date_tips), time -> {
            this.mSelectTime = time.split(" ")[0];
            String currentTime = TimeUtil.timeStamp2Date(System.currentTimeMillis());
            if (this.mSelectTime.equals(currentTime.split(" ")[0])) {
                this.mBudgetTv.setText((CharSequence)"\u672c\u6708\u6536\u652f");
            } else {
                this.mBudgetTv.setText((CharSequence)this.mSelectTime.substring(0, 7));
            }
            this.reqAcountBillInfo(1, 10);
        }, "2008-01-01 00:00", this.getCurTime(), new CustomDatePicker.DialogShowOrDismiss(){

            @Override
            public void show() {
                AccountIncomeFragment.this.mBudgetTv.setTextColor(AccountIncomeFragment.this.getMContext().getResources().getColor(R.color.color_3576E0));
                AccountIncomeFragment.this.mBudgetImg.setImageResource(R.drawable.commbyh_up_normal);
            }

            @Override
            public void dismiss() {
                AccountIncomeFragment.this.mBudgetTv.setTextColor(AccountIncomeFragment.this.getMContext().getResources().getColor(R.color.text2));
                AccountIncomeFragment.this.mBudgetImg.setImageResource(R.drawable.commbyh_down_normal);
            }
        });
        this.mCustomDatePicker.showSpecificTime(false);
        this.mCustomDatePicker.setIsLoop(false);
    }

    public String getCurTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.CHINA);
        return sdf.format(new Date());
    }

    public String stampToDate(long timeMillis) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(timeMillis);
        return simpleDateFormat.format(date);
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_account_income;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.finish();
    }

    @Override
    public void getAccountSuccess(DocDetailEntity responseBody) {
        if (responseBody == null) {
            return;
        }
        float balance = responseBody.getBalance();
        String balanceStr = this.decimalNum(balance);
        Log.i((String)TAG, (String)("getAccountSuccess: result:" + balanceStr));
        this.mAccountBanlanceTv.setText((CharSequence)balanceStr);
    }

    private String decimalNum(float num) {
        String result = String.format("%1.2f", Float.valueOf(num));
        return result;
    }

    public void error(String msg) {
        if (this.mLoadIndex > 1) {
            this.vRefreshLayout.finishLoadmore();
        } else if (this.mLoadIndex == 1) {
            this.vRefreshLayout.finishRefresh();
        }
        this.showShortToast(this.getContext().getResources().getString(R.string.my_account_error));
        if (this.mAccountBillinfoAdapter != null) {
            this.mAccountBillinfoAdapter.setEnableLoadMore(false);
        }
        Log.i((String)"==================mag", (String)msg);
    }

    @Override
    public void receiceAccountBillinfoOk(AccountBillinfoDataEntity accountBillinfoDataEntity) {
        this.mQequestWithdrawCashTv.setOnClickListener((View.OnClickListener)new RequestWithdrawCashOnClickListener());
        this.mDatas = accountBillinfoDataEntity.getContent();
        if (this.mLoadIndex > 1) {
            this.mAccountBillinfoAdapter.addData(this.mAccountBillinfoAdapter.getItemCount() - 1, this.mDatas);
            this.vRefreshLayout.finishLoadmore();
        } else if (this.mLoadIndex == 1) {
            this.mAccountBillinfoAdapter.setNewData(this.mDatas);
            this.mAccountBillinfoAdapter.notifyDataSetChanged();
            this.vRefreshLayout.finishRefresh();
        }
    }

    @Override
    public void setBankCardsOk(ResponseBody responseBody) {
        if (responseBody == null) {
            return;
        }
        if (responseBody.getCode() == 200) {
            if (responseBody.getResult() == null) {
                return;
            }
            BoundBankCardsInfoEntity boundBankCardsInfoEntity = (BoundBankCardsInfoEntity)responseBody.getResult();
            RequestWithRawCashFragment requestWithRawCashFragment = new RequestWithRawCashFragment();
            Bundle bundle = new Bundle();
            bundle.putString("amount", this.mAccountBanlanceTv.getText().toString());
            bundle.putString("cardholder", boundBankCardsInfoEntity.getCardholder());
            requestWithRawCashFragment.setArguments(bundle);
            this.start((ISupportFragment)requestWithRawCashFragment);
        } else if (responseBody.getCode() == 201) {
            ManagerBankCardsFragment managerBankCardsFragment = new ManagerBankCardsFragment();
            Bundle bundle = new Bundle();
            bundle.putInt("index", 2);
            managerBankCardsFragment.setArguments(bundle);
            this.start((ISupportFragment)managerBankCardsFragment);
        }
    }

    @Override
    public void unBindCard() {
    }

    @Override
    public void getWithdrawalAmountSuccess(ResponseBody responseBody) {
        if (responseBody == null) {
            return;
        }
        if (responseBody.getCode() == 200) {
            Object result = responseBody.getResult();
            if (result != null) {
                float balance = 0.0f;
                if (result instanceof Double) {
                    balance = Float.valueOf(result + "").floatValue();
                } else if (result instanceof Float) {
                    balance = ((Float)result).floatValue();
                } else if (result instanceof Integer) {
                    balance = ((Float)result).floatValue();
                }
                String balanceStr = this.decimalNum(balance);
                Log.i((String)TAG, (String)("getWithdrawalAmountSuccess: result:" + balanceStr));
                this.mWithdrawalAccountTv.setText((CharSequence)("\u4f1a\u8bca\u63d0\u73b0\u4e2d\u91d1\u989d\uff1a" + balanceStr + "\u5143"));
            }
        } else {
            this.showShortToast(responseBody.getMsg());
        }
    }

    public boolean onBackPressedSupport() {
        this.finish();
        return true;
    }

    private void finish() {
        Objects.requireNonNull(this.getActivity()).finish();
    }

    private class RequestWithdrawCashOnClickListener
    implements View.OnClickListener {
        private RequestWithdrawCashOnClickListener() {
        }

        public void onClick(View v) {
            AccountIncomeFragment.this.mBankCardsInfoPresenter.sendBankCardDoctorId(AccountIncomeFragment.this.getContext(), true);
        }
    }

    private class SelectDateOnClickListener
    implements View.OnClickListener {
        private SelectDateOnClickListener() {
        }

        public void onClick(View v) {
            long timeStamp = System.currentTimeMillis();
            AccountIncomeFragment.this.mCustomDatePicker.show(AccountIncomeFragment.this.stampToDate(timeStamp));
        }
    }
}

