/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import butterknife.BindView;
import com.blankj.utilcode.util.RegexUtils;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.PatientEntity;
import com.kangxin.common.util.EditTextPlusUtil;
import com.kangxin.common.util.VerifyUtil;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.presenter.IAddPatientPresenter;
import com.kangxin.doctor.worktable.presenter.impl2.BHAddPatientPresenter;
import com.kangxin.doctor.worktable.view.IAddPatientView;
import com.kangxin.doctor.worktable.widget.SexSelectDialog;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class AddPatientFragment
extends BaseFragment
implements IToolView,
IAddPatientView {
    @BindView(value=2131428230)
    TextView vSexSelect;
    @BindView(value=2131428225)
    EditText vPatientName;
    @BindView(value=2131428215)
    EditText vPatientCard;
    @BindView(value=2131428213)
    EditText vPatientAge;
    @BindView(value=2131428227)
    EditText vPatientPhone;
    private IAddPatientPresenter mAddPatientPresenter = new BHAddPatientPresenter(this);
    int mSex = 0;
    private long mHospitalId;

    public static AddPatientFragment newInstance() {
        AddPatientFragment addPatientFragment = new AddPatientFragment();
        addPatientFragment.mHospitalId = 0L;
        Bundle bundle = new Bundle();
        bundle.putLong("hospitalId", 0L);
        addPatientFragment.setArguments(bundle);
        return addPatientFragment;
    }

    public static AddPatientFragment newInstance(long hospitalId) {
        AddPatientFragment addPatientFragment = new AddPatientFragment();
        addPatientFragment.mHospitalId = hospitalId;
        Bundle bundle = new Bundle();
        bundle.putLong("hospitalId", hospitalId);
        addPatientFragment.setArguments(bundle);
        return addPatientFragment;
    }

    public void init() {
        this.mHospitalId = this.getArguments().getLong("hospitalId");
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getString(R.string.add_patient_title));
        this.vRightTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.btn_finish_tip));
        this.vRightTextView.setTextColor(-1);
        this.vRightTextView.setVisibility(0);
        this.dispatchEvent();
    }

    private void dispatchEvent() {
        this.vSexSelect.setOnClickListener(v -> new SexSelectDialog(this.mContext).setListener((position, value) -> {
            this.mSex = value;
            this.vSexSelect.setText((CharSequence)(value == 1 ? this.getMContext().getResources().getString(R.string.sex_boy) : this.getMContext().getResources().getString(R.string.sex_girl)));
        }).show());
        this.vPatientCard.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (!StringUtils.isEmpty((CharSequence)s.toString())) {
                    if (RegexUtils.isIDCard18((CharSequence)s.toString())) {
                        int age = AddPatientFragment.this.idToAge(s.toString());
                        AddPatientFragment.this.vPatientAge.setText((CharSequence)("" + age));
                        return;
                    }
                    if (RegexUtils.isIDCard15((CharSequence)s.toString())) {
                        String idcardNo = s.toString();
                        idcardNo = VerifyUtil.changeIdcard((String)idcardNo);
                        int age = AddPatientFragment.this.idToAge(idcardNo);
                        AddPatientFragment.this.vPatientAge.setText((CharSequence)("" + age));
                        return;
                    }
                    if (s.toString().length() == 18) {
                        ToastUtils.showShort((CharSequence)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8eab\u4efd\u8bc1\u53f7");
                    }
                }
            }
        });
        this.vPatientCard.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus && !StringUtils.isEmpty((CharSequence)AddPatientFragment.this.vPatientCard.getText().toString())) {
                    if (RegexUtils.isIDCard18((CharSequence)AddPatientFragment.this.vPatientCard.getText().toString())) {
                        int age = AddPatientFragment.this.idToAge(AddPatientFragment.this.vPatientCard.getText().toString());
                        AddPatientFragment.this.vPatientAge.setText((CharSequence)("" + age));
                        return;
                    }
                    if (RegexUtils.isIDCard15((CharSequence)AddPatientFragment.this.vPatientCard.getText().toString())) {
                        String idcardNo = AddPatientFragment.this.vPatientCard.toString();
                        idcardNo = VerifyUtil.changeIdcard((String)idcardNo);
                        int age = AddPatientFragment.this.idToAge(idcardNo);
                        AddPatientFragment.this.vPatientAge.setText((CharSequence)("" + age));
                        return;
                    }
                    ToastUtils.showShort((CharSequence)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8eab\u4efd\u8bc1\u53f7");
                }
            }
        });
        this.vRightTextView.setOnClickListener(v -> {
            if (StringUtils.isEmpty((CharSequence)this.vPatientName.getText().toString())) {
                ToastUtils.showShort((CharSequence)"\u60a3\u8005\u59d3\u540d\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)this.vPatientAge.getText().toString())) {
                ToastUtils.showShort((CharSequence)"\u60a3\u8005\u5e74\u9f84\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)this.vPatientCard.getText().toString())) {
                ToastUtils.showShort((CharSequence)"\u60a3\u8005\u8eab\u4efd\u8bc1\u53f7\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)this.vPatientPhone.getText().toString())) {
                ToastUtils.showShort((CharSequence)"\u60a3\u8005\u8054\u7cfb\u65b9\u5f0f\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
                return;
            }
            PatientEntity patientEntity = new PatientEntity();
            patientEntity.setName(this.vPatientName.getText().toString().trim());
            patientEntity.setAge(Integer.parseInt(this.vPatientAge.getText().toString()));
            patientEntity.setIdCard(this.vPatientCard.getText().toString().replaceAll("x", "X").trim());
            patientEntity.setGender(this.mSex);
            patientEntity.setMobileNumber(this.vPatientPhone.getText().toString());
            patientEntity.setHospitalId(this.mHospitalId);
            this.mAddPatientPresenter.savePatientV2(patientEntity);
        });
        EditTextPlusUtil.rightAlign((EditText)this.vPatientName, null);
        EditTextPlusUtil.rightAlign((EditText)this.vPatientCard, null);
        EditTextPlusUtil.rightAlign((EditText)this.vPatientAge, null);
        EditTextPlusUtil.rightAlign((EditText)this.vPatientPhone, null);
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_add_patient;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }

    @Override
    public void finish() {
        this.pop();
    }

    private int idToAge(String IdNO) {
        IdNO = IdNO.trim();
        int leh = IdNO.length();
        String dates = "";
        if (leh == 18) {
            dates = IdNO.substring(6, 10);
            SimpleDateFormat df = new SimpleDateFormat("yyyy");
            String year = df.format(new Date());
            int u = Integer.parseInt(year) - Integer.parseInt(dates);
            return u;
        }
        if (leh == 15) {
            dates = IdNO.substring(6, 8);
            return Integer.parseInt(dates);
        }
        return 0;
    }
}

