/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.blankj.utilcode.util.StringUtils;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.adapter.SelectImageListAdapter;
import com.kangxin.common.byh.entity.response.PatientDetailEntity;
import com.kangxin.common.byh.widget.SelectImageDecoration;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.presenter.INewApplyDetailPresenter;
import com.kangxin.doctor.worktable.presenter.impl.NewApplyDetailPresenter;
import com.kangxin.doctor.worktable.view.INewApplyDetailView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import me.yokeyword.fragmentation.ISupportFragment;
import org.jetbrains.annotations.NotNull;

public class ApplyDetailFragment
extends BaseFragment
implements IToolView,
INewApplyDetailView {
    private PatientDetailEntity mPatientDetailEntity;
    @BindView(value=2131428225)
    TextView vPatientName;
    @BindView(value=2131428230)
    TextView vPatientSex;
    @BindView(value=2131428213)
    TextView vPatientAge;
    @BindView(value=2131428215)
    TextView vPatientCard;
    @BindView(value=2131428227)
    TextView vPatientPhone;
    @BindView(value=2131428216)
    TextView vPatientCase;
    @BindView(value=2131428214)
    TextView vPatientApplyTime;
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    @BindView(value=2131428106)
    TextView vCommitApply;
    private INewApplyDetailPresenter presenter;

    public static ApplyDetailFragment newInstance(PatientDetailEntity patientDetailEntity) {
        ApplyDetailFragment applyDetailFragment = new ApplyDetailFragment();
        applyDetailFragment.mPatientDetailEntity = patientDetailEntity;
        Bundle bundle = new Bundle();
        bundle.putSerializable("patientDetailEntity", (Serializable)patientDetailEntity);
        applyDetailFragment.setArguments(bundle);
        return applyDetailFragment;
    }

    public static ISupportFragment newInstance(String orderViewId) {
        ApplyDetailFragment applyDetailFragment = new ApplyDetailFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable("orderViewId", (Serializable)((Object)orderViewId));
        applyDetailFragment.setArguments(bundle);
        return applyDetailFragment;
    }

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.apply_details_title));
        this.mPatientDetailEntity = (PatientDetailEntity)this.getArguments().getSerializable("patientDetailEntity");
        String orderViewId = this.getArguments().getString("orderViewId");
        if (!StringUtils.isEmpty((CharSequence)orderViewId)) {
            this.vCommitApply.setVisibility(0);
        }
        this.presenter = new NewApplyDetailPresenter(this);
        if (!StringUtils.isEmpty((CharSequence)orderViewId)) {
            this.presenter.getNewApplyDetail(orderViewId);
        } else {
            this.fullOrderDetail(this.mPatientDetailEntity);
        }
        this.dispatchEvent();
    }

    private void dispatchEvent() {
        this.vCommitApply.setOnClickListener(v -> {});
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_order_detail;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }

    @Override
    public void fullOrderDetail(PatientDetailEntity result) {
        this.mPatientDetailEntity = result;
        this.vPatientName.setText((CharSequence)this.mPatientDetailEntity.getPatientName());
        this.vPatientSex.setText((CharSequence)(this.mPatientDetailEntity.getPatientSex() == 1 ? this.getMContext().getResources().getString(R.string.sex_boy) : this.getMContext().getResources().getString(R.string.sex_girl)));
        this.vPatientAge.setText((CharSequence)(this.mPatientDetailEntity.getPatientAge() + ""));
        this.vPatientCard.setText((CharSequence)this.mPatientDetailEntity.getPatIdCard());
        this.vPatientPhone.setText((CharSequence)this.mPatientDetailEntity.getPatientTel());
        this.vPatientCase.setText((CharSequence)this.mPatientDetailEntity.getPatCaseMainSuit());
        this.vPatientApplyTime.setText((CharSequence)this.mPatientDetailEntity.getPatCreateTime());
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.mContext, 5));
        this.vRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SelectImageDecoration(10));
        List caseAttachmentList = this.mPatientDetailEntity.getCaseAttachmentList();
        ArrayList<String> images = new ArrayList<String>();
        for (PatientDetailEntity.AttchMentEntity temp : caseAttachmentList) {
            images.add(temp.getUrl());
        }
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)new SelectImageListAdapter(images, true));
    }
}

