/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.base.kt.IFlushMoreView;
import com.kangxin.common.byh.base.ByBaseStateFlushMoreFragment;
import com.kangxin.common.byh.entity.OrderItemEntity;
import com.kangxin.common.byh.entity.OrderItemEntityV2;
import com.kangxin.common.byh.entity.response.PatientDetailEntity;
import com.kangxin.common.byh.service.IConsChatReceProvider;
import com.kangxin.doctor.worktable.OrderApplySignFragment;
import com.kangxin.doctor.worktable.OrderApplySuccessFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.OrderListAdapterV2;
import com.kangxin.doctor.worktable.presenter.INewApplyDetailPresenter;
import com.kangxin.doctor.worktable.presenter.IOrderListPresenter;
import com.kangxin.doctor.worktable.presenter.impl.NewApplyDetailPresenter;
import com.kangxin.doctor.worktable.presenter.impl.OrderListPresenter;
import com.kangxin.doctor.worktable.view.INewApplyDetailView;
import com.kangxin.doctor.worktable.view.INewApplyOrderListView;
import java.io.Serializable;
import java.util.ArrayList;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation.SupportFragment;

public class ApplyOrderListFragment
extends ByBaseStateFlushMoreFragment<OrderItemEntity>
implements INewApplyOrderListView,
IFlushMoreView<OrderItemEntity>,
INewApplyDetailView {
    private static final String TAG = "ApplyOrderListFragment";
    private int status;
    private IOrderListPresenter mNewApplyOrderListPresenter = new OrderListPresenter(this);
    private INewApplyDetailPresenter presenter = new NewApplyDetailPresenter(this);
    private OrderListAdapterV2 adapter;
    private IConsChatReceProvider mConsuChatReceiverProvider = (IConsChatReceProvider)ARouter.getInstance().build("/consuchat/receiver/ConsuChatReceiverProvider").navigation();

    public static ApplyOrderListFragment newInstance(int status) {
        ApplyOrderListFragment newApplyOrderListFragment = new ApplyOrderListFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("status", status);
        newApplyOrderListFragment.setArguments(bundle);
        return newApplyOrderListFragment;
    }

    public void init() {
        super.init();
        this.mConsuChatReceiverProvider.registerConsuChatReceiver();
        this.status = this.getArguments().getInt("status");
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.dispatchEvent();
    }

    protected void flushOrLoad(boolean isGetMore) {
        this.mNewApplyOrderListPresenter.getNewApplyOrderList(isGetMore, this.status);
    }

    private void dispatchEvent() {
        this.adapter = new OrderListAdapterV2(new ArrayList<OrderItemEntityV2>());
        this.adapter.setListener(new OrderListAdapterV2.OnClickItemListener(){

            @Override
            public void onClick(OrderItemEntity item) {
                int orderStatus = item.getOrderStatus();
                Log.i((String)ApplyOrderListFragment.TAG, (String)("onClick: orderStatus:" + orderStatus));
                switch (orderStatus) {
                    case 6: {
                        ApplyOrderListFragment.this.presenter.getNewApplyDetail(item.getOrderViewId());
                        Log.i((String)ApplyOrderListFragment.TAG, (String)"onClick: ORDER_STATUS_NEW_APPLY");
                        break;
                    }
                    case 10: {
                        OrderApplySuccessFragment orderApplySuccessFragment = OrderApplySuccessFragment.newInstance(item.getOrderViewId(), item.getOrderApplicationChannels());
                        ((SupportFragment)ApplyOrderListFragment.this.getParentFragment().getParentFragment()).start((ISupportFragment)orderApplySuccessFragment);
                        Log.i((String)ApplyOrderListFragment.TAG, (String)"onClick: ORDER_STATUS_UN_PAY");
                        break;
                    }
                    case 8: {
                        OrderApplySuccessFragment orderApplySuccessFragment2 = OrderApplySuccessFragment.newInstance(item.getOrderViewId(), item.getOrderApplicationChannels());
                        ((SupportFragment)ApplyOrderListFragment.this.getParentFragment().getParentFragment()).start((ISupportFragment)orderApplySuccessFragment2);
                        Log.i((String)ApplyOrderListFragment.TAG, (String)"onClick: ORDER_STATUS_WAIT_DISTRIBUTION");
                        break;
                    }
                    case 5: {
                        OrderApplySignFragment orderApplySignFragment = OrderApplySignFragment.newInstance(item.getOrderId(), item.getOrderViewId(), item.getDocHosName(), item.getOrderApplicationChannels());
                        ((SupportFragment)ApplyOrderListFragment.this.getParentFragment().getParentFragment()).start((ISupportFragment)orderApplySignFragment);
                        Log.i((String)ApplyOrderListFragment.TAG, (String)"onClick: ORDER_STATUS_WAIT_PATIENT_SIGN");
                        break;
                    }
                    case 20: {
                        ApplyOrderListFragment.this.sendConsMsgCast(item);
                        Log.i((String)ApplyOrderListFragment.TAG, (String)"onClick: ORDER_STATUS_WAITING");
                        break;
                    }
                    case 30: {
                        if (item.getOrderType() == 4 || item.getOrderType() == 5) {
                            // empty if block
                        }
                        ApplyOrderListFragment.this.sendConsMsgCast(item);
                        Log.i((String)ApplyOrderListFragment.TAG, (String)"onClick: ORDER_STATUS_RUNNING");
                        break;
                    }
                    case 0: {
                        ApplyOrderListFragment.this.sendConsMsgCast(item);
                        Log.i((String)ApplyOrderListFragment.TAG, (String)"onClick: 000");
                        break;
                    }
                    case 40: {
                        if (item.getOrderType() == 4 || item.getOrderType() == 5) {
                            // empty if block
                        }
                        ApplyOrderListFragment.this.sendConsMsgCast(item);
                        Log.i((String)ApplyOrderListFragment.TAG, (String)"onClick: ORDER_STATUS_FINISH");
                        break;
                    }
                    case 50: {
                        OrderApplySuccessFragment cancleFragment = OrderApplySuccessFragment.newInstance(item.getOrderViewId(), item.getOrderApplicationChannels());
                        ((SupportFragment)ApplyOrderListFragment.this.getParentFragment().getParentFragment()).start((ISupportFragment)cancleFragment);
                        Log.i((String)ApplyOrderListFragment.TAG, (String)"onClick: ORDER_STATUS_CANCEL");
                        break;
                    }
                }
            }
        });
    }

    private void sendConsMsgCast(OrderItemEntity orderItemEntity) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.mConsuChatReceiverProvider.sendConsuChatReceiver((Serializable)orderItemEntity);
        } else {
            Intent intent = new Intent("com.kangxin.doctor.worktable.orderlist.consulation.chat");
            intent.putExtra("ORDER_ITEM_ENTITY", (Serializable)orderItemEntity);
            this.getContext().sendBroadcast(intent);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mConsuChatReceiverProvider.unRegisterConsuChatReceiver();
    }

    protected BaseQuickAdapter getBaseQuickAdapter() {
        return this.adapter;
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_order_list_new_apply;
    }

    @Override
    public void fullOrderDetail(PatientDetailEntity result) {
        ARouter.getInstance().build("/patientdetail/patient_detail_activity").withInt("MSG_JUMP_TYPE", 5381).withSerializable("MSG_APPLY_DETAIL", (Serializable)result).navigation();
    }
}

