/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.text.TextClickableSpan;
import com.kangxin.doctor.worktable.BoundBankCardsVerifyFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.BankCardEntity;
import com.kangxin.doctor.worktable.presenter.IVerifyBankCardPresenter;
import com.kangxin.doctor.worktable.presenter.impl.VerifyBankCardPresenter;
import com.kangxin.doctor.worktable.view.IVerifyBankCardView;
import java.io.Serializable;
import me.yokeyword.fragmentation.ISupportFragment;
import org.jetbrains.annotations.NotNull;

public class BoundBankCardsSaveInfoChildFragment
extends BaseFragment
implements IToolView,
IVerifyBankCardView {
    private static final String TAG = "BoundBankCardsSaveInfoChildF";
    private TextView mBankNameTv;
    private TextView mBankTypeTv;
    private EditText mBankOpeningBankEt;
    private EditText mReservedPhoneNumberEt;
    private TextView mNextStepTv;
    private TextView mUserAgreementTv;
    private String mCardHolder;
    private String mBankCardno;
    private String mBankCardType;
    private String mIdCardNo;
    private CheckBox vCheckBox;
    private boolean mIsChecked = false;
    private IVerifyBankCardPresenter mVerifyBankCardPresenter = new VerifyBankCardPresenter(this);

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.add_bound_bankcard_title));
        this.initViews();
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mCardHolder = bundle.getString("cardholder");
            this.mBankCardno = bundle.getString("bankcardno");
            this.mBankCardType = bundle.getString("bankcardtype");
            this.mIdCardNo = bundle.getString("idcardno");
            if (this.mBankCardType.contains("\u00b7")) {
                String[] split = this.mBankCardType.split("\u00b7");
                this.mBankNameTv.setText((CharSequence)split[0]);
                this.mBankTypeTv.setText((CharSequence)split[1]);
            }
        }
    }

    private void initViews() {
        this.mBankNameTv = (TextView)this.findViewById(this.rootView, R.id.bank_name);
        this.mBankTypeTv = (TextView)this.findViewById(this.rootView, R.id.card_type);
        this.mBankOpeningBankEt = (EditText)this.findViewById(this.rootView, R.id.bank_opening_bank);
        this.mReservedPhoneNumberEt = (EditText)this.findViewById(this.rootView, R.id.reserved_phone_number);
        this.mNextStepTv = (TextView)this.findViewById(this.rootView, R.id.fragment_savebankinfo2_textview_submit);
        this.mNextStepTv.setOnClickListener((View.OnClickListener)new NextStepOnClickListener());
        this.vCheckBox = (CheckBox)this.findViewById(this.rootView, R.id.vCheckBox);
        this.vCheckBox.setOnCheckedChangeListener((buttonView, isChecked) -> {
            this.mIsChecked = isChecked;
        });
        this.mUserAgreementTv = (TextView)this.findViewById(this.rootView, R.id.user_agreement_tv);
        String agreement = this.mUserAgreementTv.getText().toString();
        SpannableString spannableString = new SpannableString((CharSequence)agreement);
        this.setOnclickSpan(spannableString, agreement, "\u300a\u7528\u6237\u534f\u8bae\u300b", view -> {
            Bundle bundle = new Bundle();
            bundle.putString("loadurl", "https://patient.ebaiyihui.com/agreement/legalNotice.html");
            bundle.putString("title", "\u7528\u6237\u534f\u8bae");
            ARouter.getInstance().build("/user/agreen/AgreementNoticeCountryActivity").with(bundle).navigation();
        });
        this.mUserAgreementTv.setText((CharSequence)spannableString);
        this.mUserAgreementTv.setMovementMethod(LinkMovementMethod.getInstance());
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_save_bank_child_info;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
        BoundBankCardsSaveInfoChildFragment.HideKeyboard(this.rootView);
    }

    public SpannableString setOnclickSpan(SpannableString spannableString, String allString, String clickString, View.OnClickListener onClickListener) {
        spannableString.setSpan((Object)new TextClickableSpan(-14904854, onClickListener), allString.indexOf(clickString), allString.indexOf(clickString) + clickString.length(), 33);
        return spannableString;
    }

    @Override
    public void getVerifyBankCardOk(ResponseBody responseBody) {
        if (responseBody == null) {
            return;
        }
        if (responseBody.getCode() == 200) {
            if (responseBody.getResult() == null) {
                BoundBankCardsSaveInfoChildFragment.HideKeyboard(this.rootView);
                return;
            }
            BankCardEntity bankCardEntity = (BankCardEntity)responseBody.getResult();
            if (bankCardEntity.getRespCode().equals("0000")) {
                BoundBankCardsVerifyFragment verifyFragment = new BoundBankCardsVerifyFragment();
                Bundle bundle = new Bundle();
                bundle.putSerializable("bankcardentity", (Serializable)bankCardEntity);
                bundle.putString("openingbank", this.mBankOpeningBankEt.getText().toString().trim());
                verifyFragment.setArguments(bundle);
                this.start((ISupportFragment)verifyFragment);
            } else {
                this.showShortToast(bankCardEntity.getRespMessage());
            }
            BoundBankCardsSaveInfoChildFragment.HideKeyboard(this.rootView);
        } else {
            BoundBankCardsSaveInfoChildFragment.HideKeyboard(this.rootView);
            this.showShortToast(responseBody.getMsg());
        }
    }

    public static void HideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }

    private class NextStepOnClickListener
    implements View.OnClickListener {
        private NextStepOnClickListener() {
        }

        public void onClick(View v) {
            String openingBank = BoundBankCardsSaveInfoChildFragment.this.mBankOpeningBankEt.getText().toString().trim();
            if (TextUtils.isEmpty((CharSequence)openingBank)) {
                BoundBankCardsSaveInfoChildFragment.this.showShortToast(BoundBankCardsSaveInfoChildFragment.this.getResources().getString(R.string.please_input_opening_bank_tips));
                return;
            }
            String phoneNum = BoundBankCardsSaveInfoChildFragment.this.mReservedPhoneNumberEt.getText().toString().trim();
            if (TextUtils.isEmpty((CharSequence)phoneNum)) {
                BoundBankCardsSaveInfoChildFragment.this.showShortToast(BoundBankCardsSaveInfoChildFragment.this.getResources().getString(R.string.please_input_phone_num_tips));
                return;
            }
            if (!BoundBankCardsSaveInfoChildFragment.this.mIsChecked) {
                BoundBankCardsSaveInfoChildFragment.this.showShortToast(BoundBankCardsSaveInfoChildFragment.this.getResources().getString(R.string.please_read_agree_tips));
                return;
            }
            BankCardEntity bankCardEntity = new BankCardEntity();
            bankCardEntity.setName(BoundBankCardsSaveInfoChildFragment.this.mCardHolder);
            bankCardEntity.setCardNo(BoundBankCardsSaveInfoChildFragment.this.mBankCardno);
            bankCardEntity.setIdNo(BoundBankCardsSaveInfoChildFragment.this.mIdCardNo);
            bankCardEntity.setPhoneNo(phoneNum);
            BoundBankCardsSaveInfoChildFragment.this.mVerifyBankCardPresenter.getVerifyBankCardPresenter(bankCardEntity, true);
        }
    }
}

