/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.VertifyIDCardEntity;
import com.kangxin.common.byh.present.IVerifyPresenter;
import com.kangxin.common.byh.present.VerifyPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IVerNameByIdcardView;
import com.kangxin.common.util.VerifyUtil;
import com.kangxin.doctor.worktable.BoundBankCardsSaveInfoChildFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.util.BankCardUtils;
import me.yokeyword.fragmentation.ISupportFragment;
import org.jetbrains.annotations.NotNull;

public class BoundBankCardsSaveInfoFragment
extends BaseFragment
implements IToolView,
IVerNameByIdcardView {
    private static final String TAG = "BoundBankCardsSaveInfoF";
    private TextView mCardholderTv;
    private TextView mIdCardNoTv;
    private EditText mBankNumberEt;
    private TextView mNextStepTv;
    private String mBankCardAndType;
    private String mIdCardNo;
    private IVerifyPresenter mVerifyPresent;
    private String mUserName;

    public void init() {
        this.mVerifyPresent = new VerifyPresenter((IVerNameByIdcardView)this);
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.add_bound_bankcard_title));
        this.initViews();
    }

    private void initViews() {
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getContext()).getUserInfo();
        this.mUserName = userInfoVOBean.getName();
        this.mCardholderTv = (TextView)this.findViewById(this.rootView, R.id.tv_cardholder);
        this.mCardholderTv.setText((CharSequence)this.mUserName);
        this.mIdCardNoTv = (TextView)this.findViewById(this.rootView, R.id.tv_id_cardno);
        this.mIdCardNo = userInfoVOBean.getCredNo();
        String regex = "(\\w{1})(\\w+)(\\w{1})";
        if (!TextUtils.isEmpty((CharSequence)this.mIdCardNo)) {
            this.mIdCardNoTv.setText((CharSequence)this.mIdCardNo.replaceAll(regex, "$1****************$3"));
        }
        this.mBankNumberEt = (EditText)this.findViewById(this.rootView, R.id.et_bank_number);
        this.mBankNumberEt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String cardNum = BoundBankCardsSaveInfoFragment.this.mBankNumberEt.getText().toString().trim();
                if (cardNum.length() == 6) {
                    String nameOfBank = BankCardUtils.getNameOfBank(cardNum);
                    if (!TextUtils.isEmpty((CharSequence)nameOfBank)) {
                        BoundBankCardsSaveInfoFragment.this.mBankCardAndType = nameOfBank;
                    }
                } else if (cardNum.length() == 8) {
                    String nameOfBank = BankCardUtils.getNameOfBank(cardNum);
                    if (!TextUtils.isEmpty((CharSequence)nameOfBank)) {
                        BoundBankCardsSaveInfoFragment.this.mBankCardAndType = nameOfBank;
                    }
                } else if (cardNum.length() >= 15 || cardNum.length() <= 19) {
                    String nameOfBank = BankCardUtils.getDetailNameOfBank(cardNum);
                    if (!TextUtils.isEmpty((CharSequence)nameOfBank)) {
                        BoundBankCardsSaveInfoFragment.this.mBankCardAndType = nameOfBank;
                    }
                } else if (cardNum.length() > 19) {
                    BoundBankCardsSaveInfoFragment.this.mBankCardAndType = "";
                } else {
                    BoundBankCardsSaveInfoFragment.this.mBankCardAndType = "";
                }
            }
        });
        this.mNextStepTv = (TextView)this.findViewById(this.rootView, R.id.fragment_savebankinfo2_textview_submit);
        this.mNextStepTv.setOnClickListener((View.OnClickListener)new NextStepOnClickListener());
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_save_bank_info;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
        BoundBankCardsSaveInfoFragment.HideKeyboard(this.rootView);
    }

    public void vertifySuccess(VertifyIDCardEntity vertifyIDCardEntity) {
        if (TextUtils.isEmpty((CharSequence)this.mBankNumberEt.getText().toString().trim())) {
            this.showShortToast(this.getContext().getResources().getString(R.string.please_input_cardnum_tips));
        } else if (TextUtils.isEmpty((CharSequence)this.mBankCardAndType)) {
            this.showShortToast(this.getContext().getResources().getString(R.string.please_input_cardnum_right_tips));
        } else {
            BoundBankCardsSaveInfoChildFragment childFragment = new BoundBankCardsSaveInfoChildFragment();
            Bundle bundle = new Bundle();
            bundle.putString("cardholder", this.mCardholderTv.getText().toString());
            bundle.putString("bankcardno", this.mBankNumberEt.getText().toString().trim());
            bundle.putString("bankcardtype", this.mBankCardAndType);
            bundle.putString("idcardno", this.mIdCardNo);
            childFragment.setArguments(bundle);
            this.start((ISupportFragment)childFragment);
        }
    }

    public static void HideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }

    private class NextStepOnClickListener
    implements View.OnClickListener {
        private NextStepOnClickListener() {
        }

        public void onClick(View v) {
            BoundBankCardsSaveInfoFragment.this.mIdCardNo = VerifyUtil.changeIdcard((String)BoundBankCardsSaveInfoFragment.this.mIdCardNo);
            BoundBankCardsSaveInfoFragment.this.mVerifyPresent.verNameByIdcard(BoundBankCardsSaveInfoFragment.this.getContext(), BoundBankCardsSaveInfoFragment.this.mUserName, BoundBankCardsSaveInfoFragment.this.mIdCardNo);
        }
    }
}

