/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.util.VerifyUtil;
import com.kangxin.doctor.worktable.ManagerBankCardsFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.BankCardEntity;
import com.kangxin.doctor.worktable.entity.BankCardsSaveRequestEntity;
import com.kangxin.doctor.worktable.presenter.IValidatePhoneCodePresenter;
import com.kangxin.doctor.worktable.presenter.impl.BoundBankCardsPresenter;
import com.kangxin.doctor.worktable.presenter.impl.ValidatePhoneAndCodePresenter;
import com.kangxin.doctor.worktable.presenter.impl.WithdrawCashSmsMsgPresenter;
import com.kangxin.doctor.worktable.util.CountDownUtils;
import com.kangxin.doctor.worktable.view.BoundBankCardsView;
import com.kangxin.doctor.worktable.view.IValidatePhoneAndCodeView;
import com.kangxin.doctor.worktable.view.IWithdrawCashSmsMsgView;
import me.yokeyword.fragmentation.ISupportFragment;
import org.jetbrains.annotations.NotNull;

public class BoundBankCardsVerifyFragment
extends BaseFragment
implements IToolView,
IWithdrawCashSmsMsgView,
BoundBankCardsView,
IValidatePhoneAndCodeView {
    private static final String TAG = "BoundBankCardsVerifyF";
    private EditText mVercodeEdit;
    private TextView mPhoneNumTv;
    private TextView mNextStepTv;
    private TextView mVercodeTv;
    private TextView mErrNoticeTv;
    private String mPhoneNum;
    private String mOpeningBank;
    private BankCardEntity mBankCardEntity;
    private CountDownUtils mCountDownUtils;
    private WithdrawCashSmsMsgPresenter mWithdrawCashSmsMsgPresenter = new WithdrawCashSmsMsgPresenter(this);
    private IValidatePhoneCodePresenter mValidatePhoneCodePresenter = new ValidatePhoneAndCodePresenter(this);
    private BoundBankCardsPresenter mBoundBankCardsPresenter = new BoundBankCardsPresenter(this);
    private String mAuthKey;

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.add_bound_bankcard_title));
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mBankCardEntity = (BankCardEntity)bundle.getSerializable("bankcardentity");
            this.mPhoneNum = this.mBankCardEntity.getPhoneNo();
            this.mOpeningBank = bundle.getString("openingbank");
        }
        this.initViews();
    }

    private void initViews() {
        this.mVercodeEdit = (EditText)this.findViewById(this.rootView, R.id.sms_verify_et);
        this.mVercodeTv = (TextView)this.findViewById(this.rootView, R.id.tv_vercode);
        this.mErrNoticeTv = (TextView)this.findViewById(this.rootView, R.id.err_notice);
        this.mNextStepTv = (TextView)this.findViewById(this.rootView, R.id.fragment_savebankinfo2_textview_submit);
        this.mPhoneNumTv = (TextView)this.findViewById(this.rootView, R.id.verify_phone_number);
        this.mCountDownUtils = new CountDownUtils(this.mVercodeTv).setCountDownMillis(60000L).setCountDownColor(R.color.white, R.color.colorPrimary);
        String maskNumber = this.mPhoneNum.substring(0, 3) + "****" + this.mPhoneNum.substring(7, this.mPhoneNum.length());
        this.mPhoneNumTv.setText((CharSequence)maskNumber);
        if (VerifyUtil.isMobilePhoneNumber((String)this.mPhoneNum)) {
            this.isVercodeUsable(true);
        } else {
            this.isVercodeUsable(false);
        }
        this.addEdtChangeListener();
    }

    private void addEdtChangeListener() {
        this.mVercodeTv.setOnClickListener(view -> {
            if (!TextUtils.isEmpty((CharSequence)this.mPhoneNum)) {
                this.isVercodeUsable(true);
            } else {
                this.isVercodeUsable(false);
            }
            this.mWithdrawCashSmsMsgPresenter.sendWithdrawCashSmsMsgPhoneNum(this.mPhoneNum, false);
            this.mCountDownUtils.start();
            this.isVercodeUsable(false);
        });
        this.mCountDownUtils.setOnDownEndListener(() -> {
            if (!TextUtils.isEmpty((CharSequence)this.mPhoneNum)) {
                this.isVercodeUsable(true);
            } else {
                this.isVercodeUsable(false);
            }
        });
        this.mVercodeEdit.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @RequiresApi(api=16)
            public void afterTextChanged(Editable editable) {
                BoundBankCardsVerifyFragment.this.mErrNoticeTv.setVisibility(8);
            }
        });
        this.mNextStepTv.setOnClickListener((View.OnClickListener)new NextStepOnClickListener());
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_bound_bank_card_verify;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
        BoundBankCardsVerifyFragment.HideKeyboard(this.rootView);
        this.mCountDownUtils.reset();
    }

    @Override
    public void boundBankOk(ResponseBody responseBody) {
        if (responseBody == null) {
            return;
        }
        if (responseBody.getCode() == 200) {
            BoundBankCardsVerifyFragment.HideKeyboard(this.rootView);
            this.showShortToast(responseBody.getMsg());
            ManagerBankCardsFragment managerBankCardsFragment = new ManagerBankCardsFragment();
            Bundle bundle = new Bundle();
            bundle.putInt("index", 3);
            managerBankCardsFragment.setArguments(bundle);
            this.start((ISupportFragment)managerBankCardsFragment);
        } else {
            BoundBankCardsVerifyFragment.HideKeyboard(this.rootView);
            this.showShortToast(responseBody.getMsg());
        }
    }

    @Override
    public void getSmsMsgOk(ResponseBody responseBody) {
        if (responseBody == null) {
            return;
        }
        if (responseBody.getCode() == 200) {
            LoginSuccess loginSuccess = (LoginSuccess)responseBody.getResult();
            this.mAuthKey = loginSuccess.getAuthKey();
        } else {
            this.showShortToast(responseBody.getMsg());
        }
    }

    public void onError(String msg) {
        this.showShortToast(msg);
    }

    @Override
    public void getValidatePhoneAndCodeOk(ResponseBody responseBody) {
        if (responseBody == null) {
            return;
        }
        if (responseBody.getCode() == 200) {
            BoundBankCardsVerifyFragment.HideKeyboard(this.rootView);
            this.reqBindBankCard(false);
        } else {
            this.showShortToast(responseBody.getMsg());
        }
    }

    private void reqBindBankCard(boolean isLoading) {
        BankCardsSaveRequestEntity bankCardsSaveRequestEntity = new BankCardsSaveRequestEntity();
        String docId = VertifyDataUtil.getInstance((Context)this.getContext()).getDoctorId();
        bankCardsSaveRequestEntity.setDoctorId(Long.parseLong(docId));
        bankCardsSaveRequestEntity.setBankOutlets(this.mOpeningBank);
        bankCardsSaveRequestEntity.setCardNo(this.mBankCardEntity.getCardNo());
        bankCardsSaveRequestEntity.setCardType(this.mBankCardEntity.getBankKind());
        bankCardsSaveRequestEntity.setIssuingBank(this.mBankCardEntity.getBankName());
        bankCardsSaveRequestEntity.setTelephone(this.mBankCardEntity.getPhoneNo());
        this.mBoundBankCardsPresenter.sendBoundBankCardsInfo(bankCardsSaveRequestEntity, isLoading);
    }

    private void isVercodeUsable(boolean isUse) {
        if (this.getContext() == null) {
            return;
        }
        if (isUse) {
            this.mCountDownUtils.setUsable(true);
            Drawable vercodeDraw = this.getContext().getResources().getDrawable(R.drawable.worktab_by_bg_vercode_order);
            this.mVercodeTv.setBackground(vercodeDraw);
            this.mVercodeTv.setTextColor(this.getResources().getColor(R.color.colorPrimary));
            this.mVercodeTv.setClickable(true);
            this.mVercodeTv.setFocusable(true);
            this.mVercodeTv.setText((CharSequence)"\u53d1\u9001\u9a8c\u8bc1\u7801");
        } else {
            this.mCountDownUtils.setUsable(false);
            Drawable edtDraw = this.getContext().getResources().getDrawable(R.drawable.worktab_by_bg_vercode_order);
            this.mVercodeTv.setBackground(edtDraw);
            this.mVercodeTv.setTextColor(this.getResources().getColor(R.color.color_999999));
            this.mVercodeTv.setText((CharSequence)"\u53d1\u9001\u9a8c\u8bc1\u7801");
            this.mVercodeTv.setClickable(false);
            this.mVercodeTv.setFocusable(false);
        }
    }

    public static void HideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }

    private class NextStepOnClickListener
    implements View.OnClickListener {
        private NextStepOnClickListener() {
        }

        public void onClick(View v) {
            String verCode = BoundBankCardsVerifyFragment.this.mVercodeEdit.getText().toString().trim();
            if (TextUtils.isEmpty((CharSequence)BoundBankCardsVerifyFragment.this.mAuthKey)) {
                ToastUtils.showLong((CharSequence)"\u8bf7\u5148\u53d1\u9001\u9a8c\u8bc1\u7801");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)verCode)) {
                BoundBankCardsVerifyFragment.this.mErrNoticeTv.setVisibility(0);
                BoundBankCardsVerifyFragment.this.mErrNoticeTv.setText((CharSequence)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            BoundBankCardsVerifyFragment.this.mValidatePhoneCodePresenter.getValidatePhoneCodePresenter(BoundBankCardsVerifyFragment.this.mPhoneNum, verCode, BoundBankCardsVerifyFragment.this.mAuthKey, true);
        }
    }
}

