/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.kangxin.common.Pretty;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.util.ImgUtils;
import com.kangxin.common.byh.util.JSONEncodeUtil;
import com.kangxin.common.byh.util.QRCodeUtil;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.util.DisplayUtil;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.v2.CardCodeEntity;
import com.kangxin.doctor.worktable.presenter.IBusinessCardSharingPresenter;
import com.kangxin.doctor.worktable.presenter.impl.BusinessCardSharingPresenter;
import com.kangxin.doctor.worktable.util.ImageUtils;
import com.kangxin.doctor.worktable.view.IBusinessCardSharingView;
import com.kangxin.doctor.worktable.widget.ShareAlertDialog;
import com.kangxin.share.WeChatShare;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BusinessCardSharingFragment
extends BaseFragment
implements IToolView,
IBusinessCardSharingView,
ShareAlertDialog.ClickShareCallBack {
    private static final String TAG = "BusinessCardSharingFrag";
    private TextView vDoctorNameTv;
    private TextView vProfessionalTitlesTv;
    private TextView vHospitalDepTv;
    private ImageView vHeadShotImg;
    private ImageView vQrCodeImg;
    private Button vSaveBtn;
    private Button vShareBtn;
    private IBusinessCardSharingPresenter mCardPresenter = new BusinessCardSharingPresenter(this);
    private LinearLayout vQrCodeLayout;
    private ShareAlertDialog mDialog;
    private WeChatShare mWeChatShare;

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.business_card_share_title));
        this.vToolTitleTextView.setTextColor(this.getContext().getResources().getColor(R.color.color_333333));
        this.vToolLeftImage.setImageResource(R.mipmap.ic_login_close);
        this.mCardPresenter.getBusinessAdressInfo(this.getContext(), true);
        this.vDoctorNameTv = (TextView)this.findViewById(this.rootView, R.id.doctor_name_tv);
        this.vProfessionalTitlesTv = (TextView)this.findViewById(this.rootView, R.id.professional_titles_tv);
        this.vHospitalDepTv = (TextView)this.findViewById(this.rootView, R.id.hospital_department_tv);
        this.vHeadShotImg = (ImageView)this.findViewById(this.rootView, R.id.head_shot_img);
        this.vQrCodeImg = (ImageView)this.findViewById(this.rootView, R.id.qr_code_img);
        this.vSaveBtn = (Button)this.findViewById(this.rootView, R.id.business_card_save_btn);
        this.vShareBtn = (Button)this.findViewById(this.rootView, R.id.business_card_share_btn);
        this.vQrCodeLayout = (LinearLayout)this.findViewById(this.rootView, R.id.qr_card_layout);
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getContext()).getUserInfo();
        if (userInfoVOBean != null) {
            String headerUrl;
            String perfession;
            String doctorName = userInfoVOBean.getName();
            if (!TextUtils.isEmpty((CharSequence)doctorName)) {
                this.vDoctorNameTv.setText((CharSequence)doctorName);
            }
            if (!TextUtils.isEmpty((CharSequence)(perfession = userInfoVOBean.getProfession()))) {
                this.vProfessionalTitlesTv.setText((CharSequence)perfession);
            }
            String hospitalName = userInfoVOBean.getHospitalName();
            String hospitalDeptName = userInfoVOBean.getHospitalDeptName();
            if (!TextUtils.isEmpty((CharSequence)hospitalName) && !TextUtils.isEmpty((CharSequence)hospitalDeptName)) {
                this.vHospitalDepTv.setText((CharSequence)(hospitalName + "\t\t" + hospitalDeptName));
            }
            if (!TextUtils.isEmpty((CharSequence)(headerUrl = userInfoVOBean.getHeadPortrait()))) {
                Pretty.create().loadImage(headerUrl).diskCacheStrategy(DiskCacheStrategy.NONE).bitmapTransform(2).into(this.vHeadShotImg);
            }
        }
        this.mWeChatShare = new WeChatShare(this.getContext());
        this.mWeChatShare.register();
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_business_card_sharing;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        Objects.requireNonNull(this.getActivity()).finish();
    }

    @Override
    public void getBusinessAddressInfo(CardCodeEntity cardCodeEntity) {
        if (cardCodeEntity == null) {
            return;
        }
        String codeUrl = cardCodeEntity.getShareCode();
        if (TextUtils.isEmpty((CharSequence)codeUrl)) {
            return;
        }
        String content = JSONEncodeUtil.getDecodeJSONStr((String)codeUrl);
        QRCodeUtil.bindQrImage((Context)this.getMContext(), null, (String)content, (int)DisplayUtil.dip2px((Context)this.getMContext(), (float)500.0f), (ImageView)this.vQrCodeImg);
        this.vSaveBtn.setOnClickListener((View.OnClickListener)new SaveAndSharedOnClickListener());
        this.vShareBtn.setOnClickListener((View.OnClickListener)new SaveAndSharedOnClickListener());
    }

    public Bitmap convertViewToBitmap(View view) {
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        return bitmap;
    }

    @Override
    public void shareToByh() {
        File imgFile = ImageUtils.saveImage(this.getBitmap(), Environment.getExternalStorageDirectory() + "/images/", "byh_share.jpg");
        String imgPath = imgFile.getAbsolutePath();
        ARouter.getInstance().build("/framecontry/FrameContrActivity").withInt("MSG_JUMP_TYPE", 5396).withString("imgPath", imgPath).navigation();
        this.mDialog.dismiss();
    }

    @Override
    public void shareToWx() {
        this.mWeChatShare.sharePicture(this.getBitmap(), 0);
        this.mDialog.dismiss();
    }

    @Override
    public void shareToWxFriends() {
        this.mWeChatShare.sharePicture(this.getBitmap(), 1);
        this.mDialog.dismiss();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mWeChatShare.unregister();
    }

    private Bitmap getBitmap() {
        return this.convertViewToBitmap((View)this.vQrCodeLayout);
    }

    private class SaveAndSharedOnClickListener
    implements View.OnClickListener {
        private SaveAndSharedOnClickListener() {
        }

        public void onClick(View v) {
            if (v.getId() == R.id.business_card_save_btn) {
                ImgUtils.saveImageToGallery((Context)BusinessCardSharingFragment.this._mActivity, (Bitmap)BusinessCardSharingFragment.this.getBitmap());
            } else if (v.getId() == R.id.business_card_share_btn) {
                BusinessCardSharingFragment.this.mDialog = new ShareAlertDialog(BusinessCardSharingFragment.this.mContext);
                BusinessCardSharingFragment.this.mDialog.show();
                BusinessCardSharingFragment.this.mDialog.setOnShareClickListener(BusinessCardSharingFragment.this);
            }
        }
    }
}

