/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.byh.base.ByBaseStateFlushMoreFragment;
import com.kangxin.common.byh.entity.ConsulationReportItemEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.doctor.worktable.ConsulationReportImageFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.ReportDetailFragment;
import com.kangxin.doctor.worktable.adapter.ConsulationReportItemAdapter;
import com.kangxin.doctor.worktable.inter.IReportSearchObservable;
import com.kangxin.doctor.worktable.presenter.IConsulationReportPresenter;
import com.kangxin.doctor.worktable.presenter.impl.ConsulationReportPresenter;
import com.kangxin.doctor.worktable.view.IConsulationReportListView;
import java.util.ArrayList;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation.SupportFragment;
import org.greenrobot.eventbus.Subscribe;

public class ConsulationReportFragment
extends ByBaseStateFlushMoreFragment<ConsulationReportItemEntity>
implements IConsulationReportListView<ConsulationReportItemEntity>,
IReportSearchObservable {
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    private int mOrderType;
    private String mReportContent = "";
    private IConsulationReportPresenter mConsulationReportPresenter = new ConsulationReportPresenter(this);
    private BaseQuickAdapter<ConsulationReportItemEntity, ? extends BaseViewHolder> mAdapter = new ConsulationReportItemAdapter(new ArrayList<ConsulationReportItemEntity>());

    public static ConsulationReportFragment newInstance(int mOrderType) {
        ConsulationReportFragment consulationReportFragment = new ConsulationReportFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("orderType", mOrderType);
        consulationReportFragment.setArguments(bundle);
        return consulationReportFragment;
    }

    public void init() {
        super.init();
        Bundle arguments = this.getArguments();
        this.mOrderType = arguments.getInt("orderType");
        this.dispatchEvent();
    }

    protected void flushOrLoad(boolean isGetMore) {
        this.mConsulationReportPresenter.getReportList(this.mOrderType, this.mReportContent, isGetMore);
    }

    private void dispatchEvent() {
        this.mAdapter.setOnItemClickListener((adapter, view, position) -> {
            ConsulationReportItemEntity itemEntity = (ConsulationReportItemEntity)this.mAdapter.getData().get(position);
            if (itemEntity.getIsWrite() == 1) {
                if (itemEntity.getPhotoReport() != null && !itemEntity.getPhotoReport().equals("")) {
                    ((SupportFragment)this.getParentFragment()).start((ISupportFragment)ConsulationReportImageFragment.newInstance(itemEntity.getPhotoReport()));
                } else {
                    ((SupportFragment)this.getParentFragment()).start((ISupportFragment)ReportDetailFragment.newInstance(itemEntity.getOrderViewId()));
                }
            } else {
                ((SupportFragment)this.getParentFragment()).start((ISupportFragment)ReportDetailFragment.newInstance(itemEntity.getOrderViewId()));
            }
        });
    }

    @Subscribe
    public void finishReportWriter(ByhCommEvent.FinishPageEvent envnt) {
        this.mConsulationReportPresenter.getReportList(this.mOrderType, this.mReportContent, false);
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_consulation_report_list;
    }

    public boolean onBackPressedSupport() {
        this._mActivity.finish();
        return true;
    }

    protected BaseQuickAdapter<ConsulationReportItemEntity, ? extends BaseViewHolder> getBaseQuickAdapter() {
        return this.mAdapter;
    }

    public void noData() {
        super.noData();
        this.mAdapter.setNewData(null);
    }

    @Override
    public void onChange(String searchText) {
        this.mReportContent = searchText;
        this.mConsulationReportPresenter.getReportList(this.mOrderType, this.mReportContent, false);
    }
}

