/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import butterknife.BindView;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.v2.HospitalDepEntityV2;
import com.kangxin.common.byh.entity.v2.HospitalDepsmallEntityV2;
import com.kangxin.common.byh.entity.v2.OneDepEntityV2;
import com.kangxin.common.byh.entity.v2.TwoDepEntityV2;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.widget.RelationMoveLayout;
import com.kangxin.common.widget.adapter.RelationMoveAdapter;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.v2.BHHospitalDepAdapter;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

public class DepartmentFilterFragment
extends BaseFragment
implements IToolView {
    private static final String TAG = "DepartmentFilterFragmen";
    private static final int REQUEST_DEPARTMENT_CODE = 2;
    @BindView(value=2131428255)
    RelationMoveLayout vRelationShipLayout;
    @BindView(value=2131427708)
    View vActionBarView;
    BHHospitalDepAdapter mDepAdapter;
    private long mHospitalId;
    private static boolean isHideActionBar = false;
    private int mLeftPosition;
    private boolean isShowHotDepartment = true;
    private String openCode;

    public static DepartmentFilterFragment newInstance(long mHospitalId) {
        DepartmentFilterFragment departmentFilterFragment = new DepartmentFilterFragment();
        Bundle bundle = new Bundle();
        bundle.putLong("mHospitalId", mHospitalId);
        bundle.putBoolean("isShowHotDepartment", false);
        departmentFilterFragment.setArguments(bundle);
        return departmentFilterFragment;
    }

    public static DepartmentFilterFragment newInstance(long mHospitalId, String openCode) {
        DepartmentFilterFragment departmentFilterFragment = new DepartmentFilterFragment();
        Bundle bundle = new Bundle();
        bundle.putLong("mHospitalId", mHospitalId);
        bundle.putBoolean("isShowHotDepartment", false);
        bundle.putString("openCode", openCode);
        departmentFilterFragment.setArguments(bundle);
        return departmentFilterFragment;
    }

    public static DepartmentFilterFragment newInstance(int mHospitalId, boolean isShowHotDepartment) {
        DepartmentFilterFragment departmentFilterFragment = new DepartmentFilterFragment();
        Bundle bundle = new Bundle();
        bundle.putLong("mHospitalId", (long)mHospitalId);
        bundle.putBoolean("isShowHotDepartment", isShowHotDepartment);
        departmentFilterFragment.setArguments(bundle);
        return departmentFilterFragment;
    }

    public static DepartmentFilterFragment newInstance(int mHospitalId, String appCode, boolean isShowHotDepartment, boolean isHideAb) {
        isHideActionBar = isHideAb;
        DepartmentFilterFragment departmentFilterFragment = new DepartmentFilterFragment();
        Bundle bundle = new Bundle();
        bundle.putLong("mHospitalId", (long)mHospitalId);
        bundle.putString("openCode", appCode);
        bundle.putBoolean("isShowHotDepartment", isShowHotDepartment);
        departmentFilterFragment.setArguments(bundle);
        return departmentFilterFragment;
    }

    public void init() {
        if (isHideActionBar) {
            this.vActionBarView.setVisibility(8);
        }
        this.openCode = this.getArguments().getString("openCode");
        this.mHospitalId = this.getArguments().getLong("mHospitalId");
        this.isShowHotDepartment = this.getArguments().getBoolean("isShowHotDepartment");
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.select_department_title));
        Log.i((String)TAG, (String)("BHHospitalDepAdapter: mHosId:" + this.mHospitalId + ", openCode:" + this.openCode));
        this.mDepAdapter = this.mHospitalId == 0L ? new BHHospitalDepAdapter(this.mContext, this.isShowHotDepartment) : new BHHospitalDepAdapter(this.mContext, this.mHospitalId, this.openCode);
        this.vRelationShipLayout.setAdapter((RelationMoveAdapter)this.mDepAdapter);
        this.vRelationShipLayout.setRightOnItemClickListener((view, position, code, name) -> {
            Bundle bundle = new Bundle();
            TextView textview = (TextView)view.findViewById(R.id.vText);
            bundle.putString("departmentName", textview.getText().toString());
            bundle.putInt("departmentId", Integer.parseInt(code));
            this.setFragmentResult(2, bundle);
            if (this.mHospitalId == 0L) {
                this.sendStandardDeptDataEvent(position);
            } else {
                this.sendSelDeptDataEvent(position);
            }
            this.finishCurrentView();
        });
        this.vRelationShipLayout.setLeftOnItemClickListener((view, position, code, s) -> {
            this.mLeftPosition = position;
        });
    }

    private void sendStandardDeptDataEvent(int rightPosition) {
        List<OneDepEntityV2> oneDepEntityV2s;
        if (this.mDepAdapter != null && (oneDepEntityV2s = this.mDepAdapter.getHopitalList()) != null && oneDepEntityV2s.size() > 0) {
            List twoDepEntityV2List;
            OneDepEntityV2 oneDepEntityV2 = oneDepEntityV2s.get(this.mLeftPosition);
            ByhCommEvent.HosDeptDataEvent hosDeptDataEvent = new ByhCommEvent.HosDeptDataEvent();
            if (oneDepEntityV2 != null) {
                hosDeptDataEvent.setStdFirstDeptName(oneDepEntityV2.getStdFirstDeptName());
                hosDeptDataEvent.setStdFirstDeptCode(oneDepEntityV2.getStdFirstDeptId() + "");
            }
            if ((twoDepEntityV2List = oneDepEntityV2.getStdSecondDeptVOS()) != null && twoDepEntityV2List.size() > 0) {
                TwoDepEntityV2 twoDepEntity = (TwoDepEntityV2)twoDepEntityV2List.get(rightPosition);
                hosDeptDataEvent.setStdSecondDeptName(twoDepEntity.getStdSecondDeptName());
                hosDeptDataEvent.setStdSecondDeptCode(twoDepEntity.getStdSecondDeptId() + "");
            }
            EventBus.getDefault().post((Object)hosDeptDataEvent);
        }
    }

    private void sendSelDeptDataEvent(int rightPosition) {
        List<HospitalDepEntityV2> hospitalDepEntitys;
        if (this.mDepAdapter != null && (hospitalDepEntitys = this.mDepAdapter.getHospitalListDep()) != null && hospitalDepEntitys.size() > 0) {
            HospitalDepsmallEntityV2 depsmallDeptEntity;
            List hospitalDepsmallList;
            HospitalDepEntityV2 hospitalDepEntity = hospitalDepEntitys.get(this.mLeftPosition);
            ByhCommEvent.HosDeptDataEvent hosDeptDataEvent = new ByhCommEvent.HosDeptDataEvent();
            if (hospitalDepEntity != null) {
                hosDeptDataEvent.setHosDeptCode(hospitalDepEntity.getStandDeptId());
            }
            if ((hospitalDepsmallList = hospitalDepEntity.getDeptList()) != null && hospitalDepsmallList.size() > 0 && (depsmallDeptEntity = (HospitalDepsmallEntityV2)hospitalDepsmallList.get(rightPosition)) != null) {
                hosDeptDataEvent.setStdDeptId(depsmallDeptEntity.getDeptId());
                hosDeptDataEvent.setStdDeptName(depsmallDeptEntity.getDeptName());
                hosDeptDataEvent.setStdFirstDeptCode(depsmallDeptEntity.getFirstDeptId());
                hosDeptDataEvent.setStdFirstDeptName(depsmallDeptEntity.getFirstDeptName());
                hosDeptDataEvent.setStdSecondDeptCode(depsmallDeptEntity.getSecondDeptId());
                hosDeptDataEvent.setStdSecondDeptName(depsmallDeptEntity.getSecondDeptName());
                hosDeptDataEvent.setHosDeptName(depsmallDeptEntity.getDeptName());
            }
            EventBus.getDefault().post((Object)hosDeptDataEvent);
        }
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_department_filter;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }
}

