/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.byh.base.ByBaseStateFlushMoreFragment;
import com.kangxin.common.byh.entity.ExpertItemEntity;
import com.kangxin.common.byh.entity.ExpertServiceEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.fragment.ExpertCardFragment;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.byh.widget.BottomSelectDialog;
import com.kangxin.common.byh.widget.HorizonRectDecoration;
import com.kangxin.doctor.worktable.OrderApplyFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.ExpertListAdapter;
import com.kangxin.doctor.worktable.presenter.IExpertListPresenter;
import com.kangxin.doctor.worktable.presenter.impl2.ExpertListPresenter;
import com.kangxin.doctor.worktable.view.IExpertListView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import java.util.ArrayList;
import java.util.List;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation.SupportFragment;
import org.greenrobot.eventbus.Subscribe;

public class ExpertListFragment
extends ByBaseStateFlushMoreFragment<ExpertItemEntity>
implements IExpertListView<ExpertItemEntity> {
    @BindView(value=2131428153)
    RecyclerView vExpertList;
    @BindView(value=2131428276)
    SmartRefreshLayout vSmartRefreshLayout;
    protected int hospitalId;
    protected long departmentId;
    protected String mSearchKey = "";
    protected String mCityCode = "";
    protected String mDepartmentCode = "";
    protected int mExpertLevel = 0;
    protected String mOrderType = "";
    protected boolean isFamousExpert = false;
    protected int applicationChannel = 10;
    protected int STATUS = 1;
    protected ArrayList<ExpertItemEntity> mExpertList = new ArrayList();
    protected IExpertListPresenter mExpertListPresenter = new ExpertListPresenter(this);
    private IUpdateVerStatus mUpdateStatus;
    private int mConsuStatus;

    public static ExpertListFragment newInstance(int hospitalId, long departmentId) {
        ExpertListFragment expertListFragment = new ExpertListFragment();
        expertListFragment.departmentId = departmentId;
        expertListFragment.hospitalId = hospitalId;
        Bundle bundle = new Bundle();
        bundle.putInt("hospitalId", hospitalId);
        bundle.putLong("departmentId", departmentId);
        bundle.putBoolean("isFamousExpert", false);
        bundle.putString("mCityCode", "");
        bundle.putString("mDepartmentCode", "");
        bundle.putInt("mExpertLevel", 104);
        bundle.putString("mOrderType", "52120");
        expertListFragment.setArguments(bundle);
        return expertListFragment;
    }

    public static ExpertListFragment newInstance(boolean isFamousExpert) {
        return ExpertListFragment.newInstance(isFamousExpert, "", "", 0, "");
    }

    public static ExpertListFragment newInstance(boolean isFamousExpert, String mCityCode, String mDepartmentCode, int mExpertLevel, String mOrderType) {
        ExpertListFragment expertListFragment = new ExpertListFragment();
        expertListFragment.isFamousExpert = isFamousExpert;
        expertListFragment.mCityCode = mCityCode;
        expertListFragment.mDepartmentCode = mDepartmentCode;
        expertListFragment.mExpertLevel = mExpertLevel;
        expertListFragment.mOrderType = mOrderType;
        Bundle bundle = new Bundle();
        bundle.putInt("hospitalId", 0);
        bundle.putInt("departmentId", 0);
        bundle.putBoolean("isFamousExpert", isFamousExpert);
        bundle.putString("mCityCode", mCityCode);
        bundle.putString("mDepartmentCode", mDepartmentCode);
        bundle.putInt("mExpertLevel", mExpertLevel);
        bundle.putString("mOrderType", mOrderType);
        return expertListFragment;
    }

    public void init() {
        this.mUpdateStatus = (IUpdateVerStatus)ARouter.getInstance().build("/service_update/SERVICE_UPDATE_VER_STATUS").navigation();
        this.mConsuStatus = this.mUpdateStatus.getConsuStatus(this.getMContext());
        super.init();
    }

    public void onInitComplete() {
        super.onInitComplete();
        if (this.isFamousExpert) {
            this.applicationChannel = 20;
        }
        if (this.mConsuStatus == 4627) {
            this.applicationChannel = 40;
        }
        this.vExpertList.addItemDecoration((RecyclerView.ItemDecoration)new HorizonRectDecoration());
        this.dispatchEvent();
    }

    protected void flushOrLoad(boolean isGetMore) {
        if (this.isFamousExpert) {
            this.mExpertListPresenter.getFilterExpertList(isGetMore, this.mSearchKey, this.mCityCode, this.mDepartmentCode, this.mExpertLevel, this.mOrderType, 1, 2);
        } else {
            this.mExpertListPresenter.getExpertList(isGetMore, this.mSearchKey, this.hospitalId, this.departmentId, 2);
        }
    }

    protected void dispatchEvent() {
        if (this.mAdapter == null) {
            this.mAdapter = this.getBaseQuickAdapter();
        }
        this.mAdapter.setOnItemChildClickListener((adapter, view, position) -> {
            ExpertItemEntity expertItemEntity;
            int i = view.getId();
            if (i == R.id.vApply && ((expertItemEntity = (ExpertItemEntity)this.mAdapter.getData().get(position)) == null || expertItemEntity.getDoctorDetailInfoEntity() == null)) {
                LogUtils.e((Object[])new Object[]{"\u9884\u8ba1\u7a7a\u6307\u9488\u5f02\u5e38"});
            }
        });
        this.mAdapter.setOnItemClickListener((adapter, view, position) -> {
            ExpertItemEntity expertItemEntity = (ExpertItemEntity)this.mAdapter.getData().get(position);
            if (expertItemEntity != null && expertItemEntity.getDoctorDetailInfoEntity() != null) {
                boolean isOnlyShow = false;
                ((SupportFragment)this.getParentFragment()).start((ISupportFragment)ExpertCardFragment.newInstance((long)Long.parseLong(expertItemEntity.getDoctorDetailInfoEntity().getUserId()), (int)this.applicationChannel, (boolean)expertItemEntity.isOpenVideoService(), (boolean)expertItemEntity.isOpenGraphService(), (boolean)isOnlyShow));
            } else {
                LogUtils.e((Object[])new Object[]{"\u9884\u8ba1\u7a7a\u6307\u9488\u5f02\u5e38"});
            }
        });
    }

    private boolean isOpenVideoService(ExpertItemEntity expertItemEntity) {
        boolean flag = false;
        List doctorServiceInfoEntityList = expertItemEntity.getDoctorServiceInfoEntityList();
        ArrayList<String> services = new ArrayList<String>();
        for (ExpertServiceEntity entity : doctorServiceInfoEntityList) {
            services.add(entity.getServiceCode());
        }
        flag = services.contains("52120") && this.isFamousExpert || services.contains("103");
        return flag;
    }

    private boolean isOpenGraphService(ExpertItemEntity expertItemEntity) {
        boolean flag = false;
        List doctorServiceInfoEntityList = expertItemEntity.getDoctorServiceInfoEntityList();
        ArrayList<String> services = new ArrayList<String>();
        for (ExpertServiceEntity entity : doctorServiceInfoEntityList) {
            services.add(entity.getServiceCode());
        }
        flag = services.contains("52110") && this.isFamousExpert || services.contains("101");
        return flag;
    }

    protected void openTypeDialog(long doctorId, final ExpertItemEntity expertItemEntity) {
        final BottomSelectDialog bottomSelectDialog = new BottomSelectDialog(this.mContext, 2);
        bottomSelectDialog.show();
        bottomSelectDialog.setListener(new BottomSelectDialog.OptionsOnClickListener(){

            public void onOptionSelected(int position, int value) {
                if (position == 1) {
                    if (ExpertListFragment.this.isOpenVideoService(expertItemEntity)) {
                        assert (ExpertListFragment.this.getParentFragment() != null);
                        ((SupportFragment)ExpertListFragment.this.getParentFragment()).start((ISupportFragment)OrderApplyFragment.newInstance(expertItemEntity, 4, ExpertListFragment.this.applicationChannel));
                    } else {
                        ToastUtils.showShort((CharSequence)ExpertListFragment.this.getContext().getResources().getString(R.string.video_service_not_open_tips));
                    }
                } else if (position == 2) {
                    if (ExpertListFragment.this.isOpenGraphService(expertItemEntity)) {
                        assert (ExpertListFragment.this.getParentFragment() != null);
                        ((SupportFragment)ExpertListFragment.this.getParentFragment()).start((ISupportFragment)OrderApplyFragment.newInstance(expertItemEntity, 5, ExpertListFragment.this.applicationChannel));
                    } else {
                        ToastUtils.showShort((CharSequence)ExpertListFragment.this.getContext().getResources().getString(R.string.graphic_Service_not_open_tips));
                    }
                } else {
                    bottomSelectDialog.dismiss();
                }
            }
        });
    }

    protected BaseQuickAdapter<ExpertItemEntity, ? extends BaseViewHolder> getBaseQuickAdapter() {
        return new ExpertListAdapter(this.isFamousExpert, this.mExpertList);
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_expert_list;
    }

    @Override
    public void filter(String mSearchKey, String cityCode, String departmentCode, int expertLevel, String orderType) {
        this.mSearchKey = mSearchKey;
        this.mCityCode = cityCode;
        this.mDepartmentCode = departmentCode;
        this.mExpertLevel = expertLevel;
        this.mOrderType = orderType;
        this.flushOrLoad(false);
    }

    @Subscribe(sticky=true)
    public void injectFlush(ByhCommEvent.FlushExpertList key) {
        LogUtils.i((Object[])new Object[]{"injectFlush,key == " + key.searchKey});
        this.mSearchKey = key.searchKey;
        this.flushOrLoad(false);
    }
}

