/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.PopupWindow;
import android.widget.TextView;
import butterknife.BindView;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.widget.FilterView;
import com.kangxin.common.widget.RelationMoveLayout;
import com.kangxin.common.widget.adapter.RelationMoveAdapter;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.v2.BHHospitalDepAdapter;
import com.kangxin.doctor.worktable.adapter.v2.BHProvinceAdapter;
import com.kangxin.doctor.worktable.fragment.v2.ExpertListFragmentBH;
import com.kangxin.doctor.worktable.view.IExpertListView;
import java.util.Objects;
import me.yokeyword.fragmentation.ISupportFragment;
import org.jetbrains.annotations.NotNull;

public class FamousExpertFragment
extends BaseFragment
implements IToolView {
    @BindView(value=2131428167)
    FilterView vFilterView;
    @BindView(value=2131428269)
    EditText vSearchView;
    @BindView(value=2131428170)
    View vGrayBG;
    RelationMoveLayout vNationLayout;
    PopupWindow vNationPopWindow;
    RelationMoveAdapter mNationAdapter;
    RelationMoveLayout vDepLayout;
    PopupWindow vDepPopWindow;
    RelationMoveAdapter mDepAdapter;
    View vTypeSelectView;
    PopupWindow vFilter;
    private String mDefaultCityCode = "";
    private String mDefaultDepartmentCode = "";
    private int mDefaultExpertLevel = 0;
    private String mDefaultOrderType = "";
    private String mCityCode = this.mDefaultCityCode;
    private String mDepartmentCode = this.mDefaultDepartmentCode;
    private int mExpertLevel = this.mDefaultExpertLevel;
    private String mOrderType = this.mDefaultOrderType;
    private String mSearchKey = "";
    private IExpertListView mExpertListView = ExpertListFragmentBH.newInstance(true);
    private boolean mSecondDepSelected = false;
    private boolean mCitySelected = false;

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.selec_expert_title));
        this.loadRootFragment(R.id.vRootFragment, (ISupportFragment)this.mExpertListView);
        this.filterCountry();
        this.filterDepartment();
        this.filterExpert();
        this.dispatchEvent();
        this.hideSoftInput();
    }

    private void filterExpert() {
        this.vTypeSelectView = View.inflate((Context)this.mContext, (int)R.layout.by_view_select_type, null);
        this.vFilter = new PopupWindow(this.vTypeSelectView, -1, -2, true);
        this.vFilter.setOnDismissListener(() -> this.vFilterView.foldFilter());
        TextView expertLevel1 = (TextView)this.vTypeSelectView.findViewById(R.id.vExpertLevel1);
        TextView expertLevel2 = (TextView)this.vTypeSelectView.findViewById(R.id.vExpertLevel2);
        expertLevel1.setTag((Object)false);
        expertLevel2.setTag((Object)false);
        TextView vExpertVideo = (TextView)this.vTypeSelectView.findViewById(R.id.vExpertVideo);
        TextView vExpertGraph = (TextView)this.vTypeSelectView.findViewById(R.id.vExpertGraph);
        vExpertVideo.setTag((Object)false);
        vExpertGraph.setTag((Object)false);
        TextView vReset = (TextView)this.vTypeSelectView.findViewById(R.id.vReset);
        TextView vSure = (TextView)this.vTypeSelectView.findViewById(R.id.vSure);
        expertLevel1.setOnClickListener(v -> {
            this.switchLevelStyle(expertLevel1, expertLevel2, 1);
            this.countLevel(expertLevel1, expertLevel2);
            this.filterQuest();
        });
        expertLevel2.setOnClickListener(v -> {
            this.switchLevelStyle(expertLevel1, expertLevel2, 2);
            this.countLevel(expertLevel1, expertLevel2);
            this.filterQuest();
        });
        vExpertVideo.setOnClickListener(v -> {
            this.switchTypeStyle(vExpertVideo, vExpertGraph, 1);
            this.countType(vExpertVideo, vExpertGraph);
            this.filterQuest();
        });
        vExpertGraph.setOnClickListener(v -> {
            this.switchTypeStyle(vExpertVideo, vExpertGraph, 2);
            this.countType(vExpertVideo, vExpertGraph);
            this.filterQuest();
        });
        vReset.setOnClickListener(v -> this.reset(expertLevel1, expertLevel2, vExpertVideo, vExpertGraph));
        vSure.setOnClickListener(v -> {
            this.vFilter.dismiss();
            this.filterQuest();
        });
        this.vSearchView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                FamousExpertFragment.this.mSearchKey = s.toString();
                FamousExpertFragment.this.filterQuest();
            }
        });
        this.setListener();
    }

    private void setListener() {
        this.vSearchView.setOnEditorActionListener((v, actionId, event) -> event.getKeyCode() == 66);
    }

    private void reset(TextView switch1, TextView switch2, TextView switch3, TextView switch4) {
        switch1.setTag((Object)false);
        switch2.setTag((Object)false);
        switch3.setTag((Object)false);
        switch4.setTag((Object)false);
        this.unselectStyle(switch1);
        this.unselectStyle(switch2);
        this.unselectStyle(switch3);
        this.unselectStyle(switch4);
        this.mExpertLevel = this.mDefaultExpertLevel;
        this.mOrderType = this.mDefaultOrderType;
    }

    private void countType(TextView switch1, TextView switch2) {
        boolean tag1 = (Boolean)switch1.getTag();
        boolean tag2 = (Boolean)switch2.getTag();
        this.mOrderType = tag1 ? "52120" : (tag2 ? "52110" : this.mDefaultOrderType);
    }

    private void countLevel(TextView switch1, TextView switch2) {
        boolean tag1 = (Boolean)switch1.getTag();
        boolean tag2 = (Boolean)switch2.getTag();
        this.mExpertLevel = tag1 ? 104 : (tag2 ? 103 : this.mDefaultExpertLevel);
    }

    private void filterQuest() {
        this.mExpertListView.filter(this.mSearchKey, this.mCityCode, this.mDepartmentCode, this.mExpertLevel, this.mOrderType);
    }

    private void switchTypeStyle(TextView switch1, TextView switch2, int clickPosition) {
        boolean tag = (Boolean)switch1.getTag();
        boolean tag2 = (Boolean)switch2.getTag();
        if (clickPosition == 1) {
            if (tag) {
                this.unselectStyle(switch1);
                switch1.setTag((Object)(!tag ? 1 : 0));
            } else {
                this.selectStyle(switch1);
                switch1.setTag((Object)(!tag ? 1 : 0));
            }
            if (tag2) {
                this.unselectStyle(switch2);
                switch2.setTag((Object)(!tag2 ? 1 : 0));
            }
        } else {
            if (tag2) {
                this.unselectStyle(switch2);
                switch2.setTag((Object)(!tag2 ? 1 : 0));
            } else {
                this.selectStyle(switch2);
                switch2.setTag((Object)(!tag2 ? 1 : 0));
            }
            if (tag) {
                this.unselectStyle(switch1);
                switch1.setTag((Object)(!tag ? 1 : 0));
            }
        }
    }

    private void switchLevelStyle(TextView switch1, TextView switch2, int clickPosition) {
        boolean tag = (Boolean)switch1.getTag();
        boolean tag2 = (Boolean)switch2.getTag();
        if (clickPosition == 1) {
            if (tag) {
                this.unselectStyle(switch1);
                switch1.setTag((Object)(!tag ? 1 : 0));
            } else {
                this.selectStyle(switch1);
                switch1.setTag((Object)(!tag ? 1 : 0));
            }
            if (tag2) {
                this.unselectStyle(switch2);
                switch2.setTag((Object)(!tag2 ? 1 : 0));
            }
        } else {
            if (tag2) {
                this.unselectStyle(switch2);
                switch2.setTag((Object)(!tag2 ? 1 : 0));
            } else {
                this.selectStyle(switch2);
                switch2.setTag((Object)(!tag2 ? 1 : 0));
            }
            if (tag) {
                this.unselectStyle(switch1);
                switch1.setTag((Object)(!tag ? 1 : 0));
            }
        }
    }

    private void unselectStyle(TextView switch2) {
        switch2.setTextColor(this.mContext.getResources().getColor(R.color.gray_333333));
        switch2.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.by_background_gray));
    }

    private void selectStyle(TextView switch1) {
        switch1.setTextColor(this.mContext.getResources().getColor(R.color.colorPrimary));
        switch1.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.by_background_cardview_blue));
    }

    private void filterDepartment() {
        this.vDepLayout = new RelationMoveLayout(this.mContext);
        this.mDepAdapter = new BHHospitalDepAdapter(this.mContext);
        this.vDepLayout.setAdapter(this.mDepAdapter);
        this.vDepPopWindow = new PopupWindow((View)this.vDepLayout, -1, 1000, true);
        this.vDepPopWindow.setOnDismissListener(() -> this.vFilterView.foldDepartment());
    }

    private void filterCountry() {
        this.vNationLayout = new RelationMoveLayout(this.mContext);
        this.mNationAdapter = new BHProvinceAdapter(this.mContext);
        this.vNationLayout.setAdapter(this.mNationAdapter);
        this.vNationPopWindow = new PopupWindow((View)this.vNationLayout, -1, 1000, true);
        this.vNationPopWindow.setOnDismissListener(() -> this.vFilterView.foldCountry());
    }

    private void dispatchEvent() {
        this.vFilter.setOnDismissListener(() -> {
            this.vGrayBG.setVisibility(4);
            this.vFilterView.updateStyle(2);
        });
        this.vDepPopWindow.setOnDismissListener(() -> {
            this.vGrayBG.setVisibility(4);
            this.vFilterView.updateStyle(1);
        });
        this.vNationPopWindow.setOnDismissListener(() -> {
            this.vGrayBG.setVisibility(4);
            this.vFilterView.updateStyle(0);
        });
        this.vFilterView.setCityListener(v -> {
            this.vFilter.showAsDropDown((View)this.vFilterView);
            this.vGrayBG.setVisibility(0);
        });
        this.vFilterView.setProvenceListener(v -> {
            this.flushDepartment();
            this.vDepPopWindow.showAsDropDown((View)this.vFilterView);
            this.vGrayBG.setVisibility(0);
        });
        this.vFilterView.setCountryListener(v -> {
            this.flushCity();
            this.vNationPopWindow.showAsDropDown((View)this.vFilterView);
            this.vGrayBG.setVisibility(0);
        });
        this.vNationLayout.setRightOnItemClickListener((view, position, code, name) -> {
            Log.i((String)"famous + code", (String)code);
            this.mCityCode = code.equals("0") ? this.mDefaultCityCode : code;
            this.mCitySelected = true;
            TextView textView = (TextView)view.findViewById(R.id.vText);
            this.vFilterView.updateCity(textView.getText().toString());
            this.filterQuest();
            this.vNationPopWindow.dismiss();
        });
        this.vDepLayout.setLeftOnItemClickListener((view, position, code, name) -> {});
        this.vDepLayout.setRightOnItemClickListener((view, position, code, name) -> {
            if (code.equals("0")) {
                code = "";
            }
            this.mDepartmentCode = code;
            this.mSecondDepSelected = true;
            TextView textView = (TextView)view.findViewById(R.id.vText);
            this.vFilterView.updateDep(textView.getText().toString());
            this.filterQuest();
            this.vDepPopWindow.dismiss();
        });
    }

    private void flushDepartment() {
        if (this.mSecondDepSelected) {
            return;
        }
        this.filterDepartment();
        this.dispatchEvent();
    }

    private void flushCity() {
        if (this.mCitySelected) {
            return;
        }
        this.filterCountry();
        this.dispatchEvent();
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_expert_famous;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolbar);
    }

    public void finishCurrentView() {
        Objects.requireNonNull(this.getActivity()).finish();
    }
}

