/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.EducationExperciseEneity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.EducationInfoBody;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.presenter.EduInfoPresent;
import com.kangxin.doctor.worktable.view.AddEduInfoView;
import com.kangxin.doctor.worktable.widget.CustomDatePicker;
import com.kangxin.doctor.worktable.widget.WheelDialog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

public class GradustedInstitutionsAddFragment
extends BaseFragment
implements IToolView,
AddEduInfoView {
    private static final String TAG = "GradustedInstitutionsAd";
    private EditText mGradustedEt;
    private LinearLayout mProfessionalLayout;
    private TextView mProfessionalTv;
    private ImageView mProfessionalImg;
    private TextView mStartTimeTv;
    private TextView mEndTimeTv;
    private ImageView mStartTimeImg;
    private ImageView mEndTimeImg;
    private LinearLayout mStartTimeLl;
    private LinearLayout mEndTimeLl;
    private TextView mSubmitTv;
    private String mStartTimeStr;
    private String mEndTimeStr;
    public static List<String> mList = new ArrayList<String>();
    private EduInfoPresent mAddEduInfoPresent;
    private int mEducationId;

    public void init() {
        this.mAddEduInfoPresent = new EduInfoPresent(this);
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.gradusted_institutions_title));
        this.mGradustedEt = (EditText)this.findViewById(this.rootView, R.id.graduation_et);
        this.mProfessionalLayout = (LinearLayout)this.findViewById(this.rootView, R.id.professional_layout);
        this.mProfessionalTv = (TextView)this.findViewById(this.rootView, R.id.professional_tv);
        this.mProfessionalImg = (ImageView)this.findViewById(this.rootView, R.id.professional_img);
        this.mProfessionalLayout.setOnClickListener(v -> this.dialogList());
        this.mGradustedEt.setGravity(8388629);
        this.mGradustedEt.setTextDirection(3);
        this.mGradustedEt.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ARouter.getInstance().build("/minecenter/SearchSchoolActivity").navigation();
            }
        });
        this.mStartTimeTv = (TextView)this.findViewById(this.rootView, R.id.entrance_hours_tv);
        this.mEndTimeTv = (TextView)this.findViewById(this.rootView, R.id.graduation_time_tv);
        this.mStartTimeImg = (ImageView)this.findViewById(this.rootView, R.id.entrance_hours_img);
        this.mEndTimeImg = (ImageView)this.findViewById(this.rootView, R.id.graduation_time_img);
        this.mStartTimeLl = (LinearLayout)this.findViewById(this.rootView, R.id.entrance_hours_layout);
        this.mEndTimeLl = (LinearLayout)this.findViewById(this.rootView, R.id.graduation_time_layout);
        this.mStartTimeLl.setOnClickListener((View.OnClickListener)new SelectStartOrEndOnClickListener());
        this.mEndTimeLl.setOnClickListener((View.OnClickListener)new SelectStartOrEndOnClickListener());
        this.mSubmitTv = (TextView)this.findViewById(this.rootView, R.id.submit_educationeal_experience_tv);
        this.mSubmitTv.setOnClickListener(v -> {
            String gradusted = this.mGradustedEt.getText().toString().trim();
            String professional = this.mProfessionalTv.getText().toString();
            if (TextUtils.isEmpty((CharSequence)gradusted)) {
                this.showShortToast(this.getContext().getResources().getString(R.string.please_input_gradusted_tips));
                return;
            }
            if (professional.equals("\u8bf7\u9009\u62e9\u5b66\u5386")) {
                this.showShortToast("\u8bf7\u9009\u62e9\u5b66\u5386");
                this.mProfessionalTv.setTextColor(this.getResources().getColor(R.color.color_999999));
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.mStartTimeStr)) {
                this.showShortToast(this.getContext().getResources().getString(R.string.please_select_date_tips));
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.mEndTimeStr)) {
                this.showShortToast(this.getContext().getResources().getString(R.string.please_select_date_tips));
                return;
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = format.parse(this.mStartTimeStr);
                Date date1 = format.parse(this.mEndTimeStr);
                if (date.getTime() > date1.getTime()) {
                    this.showShortToast("\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u622a\u6b62\u65e5\u671f");
                    return;
                }
                if (date.getTime() == date1.getTime()) {
                    this.showShortToast("\u8d77\u59cb\u65e5\u671f\u4e0e\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u76f8\u540c");
                    return;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            GradustedInstitutionsAddFragment.HideKeyboard(this.rootView);
            EducationInfoBody educationInfoBody = new EducationInfoBody();
            String docId = VertifyDataUtil.getInstance((Context)this.getContext()).getLoginUserId() + "";
            educationInfoBody.setDoctorId(docId);
            educationInfoBody.setEducationId(this.mEducationId);
            educationInfoBody.setEducationName(professional);
            educationInfoBody.setEndTime(this.mEndTimeStr);
            educationInfoBody.setStartTime(this.mStartTimeStr);
            educationInfoBody.setSchoolName(gradusted);
            this.mAddEduInfoPresent.reqSaveEducationInfo(educationInfoBody);
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveSchoolDataEvent(ByhCommEvent.SchoolDataEvent schoolDataEvent) {
        String schoolName = schoolDataEvent.getSchoolName();
        this.mGradustedEt.setText((CharSequence)schoolName);
    }

    private void dialogList() {
        this.mProfessionalImg.setImageResource(R.mipmap.up_normal);
        WheelDialog wheelDialog = new WheelDialog(this.getMContext());
        wheelDialog.setLabels(mList);
        wheelDialog.setOnWheelSelectListener((index, selectLabel) -> {
            this.mEducationId = index;
            this.mProfessionalTv.setText((CharSequence)selectLabel);
            this.mProfessionalImg.setImageResource(R.mipmap.down_normal);
            this.mProfessionalTv.setTextColor(this.getResources().getColor(R.color.color_333333));
            wheelDialog.dismiss();
        });
        wheelDialog.show();
        wheelDialog.setCancelable(false);
        wheelDialog.setOnDismissListener(dialog -> {
            this.mProfessionalImg.setImageResource(R.mipmap.down_normal);
            wheelDialog.dismiss();
        });
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_graduated_institutions_add;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        GradustedInstitutionsAddFragment.HideKeyboard(this.rootView);
        this.pop();
    }

    @Override
    public void addEducationOk() {
        EventBus.getDefault().post((Object)new WorkTabEvent.EduAdd(new EducationExperciseEneity()));
        this.pop();
    }

    public void onError(String msg) {
    }

    public String stampToDate(long timeMillis) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(timeMillis);
        return simpleDateFormat.format(date);
    }

    public String getCurTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.CHINA);
        return sdf.format(new Date());
    }

    public static void HideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }

    static {
        mList.add("\u5c0f\u5b66");
        mList.add("\u521d\u4e2d");
        mList.add("\u9ad8\u4e2d");
        mList.add("\u521d\u4e2d\u4e2d\u4e13");
        mList.add("\u9ad8\u4e2d\u4e2d\u4e13");
        mList.add("\u5927\u4e13");
        mList.add("\u672c\u79d1");
        mList.add("\u7814\u7a76\u751f");
        mList.add("\u535a\u58eb");
    }

    private class SelectStartOrEndOnClickListener
    implements View.OnClickListener {
        private SelectStartOrEndOnClickListener() {
        }

        public void onClick(View v) {
            int i = v.getId();
            if (i == R.id.entrance_hours_layout) {
                GradustedInstitutionsAddFragment.HideKeyboard(GradustedInstitutionsAddFragment.this.rootView);
                CustomDatePicker customDatePickerStart = new CustomDatePicker(GradustedInstitutionsAddFragment.this.getMContext(), GradustedInstitutionsAddFragment.this.getContext().getResources().getString(R.string.please_select_date_tips), new CustomDatePicker.ResultHandler(){

                    @Override
                    public void handle(String time) {
                        GradustedInstitutionsAddFragment.this.mStartTimeStr = time.split(" ")[0];
                        GradustedInstitutionsAddFragment.this.mStartTimeTv.setText((CharSequence)GradustedInstitutionsAddFragment.this.mStartTimeStr.substring(0, 7));
                        GradustedInstitutionsAddFragment.this.mStartTimeTv.setTextColor(GradustedInstitutionsAddFragment.this.getResources().getColor(R.color.color_333333));
                    }
                }, "1980-01-01 00:00", GradustedInstitutionsAddFragment.this.getCurTime(), new CustomDatePicker.DialogShowOrDismiss(){

                    @Override
                    public void show() {
                        GradustedInstitutionsAddFragment.this.mStartTimeImg.setImageResource(R.mipmap.up_normal);
                    }

                    @Override
                    public void dismiss() {
                        GradustedInstitutionsAddFragment.this.mStartTimeImg.setImageResource(R.mipmap.down_normal);
                    }
                });
                customDatePickerStart.showSpecificTime(false);
                customDatePickerStart.setIsLoop(false);
                customDatePickerStart.show(GradustedInstitutionsAddFragment.this.stampToDate(System.currentTimeMillis()));
            } else if (i == R.id.graduation_time_layout) {
                GradustedInstitutionsAddFragment.HideKeyboard(GradustedInstitutionsAddFragment.this.rootView);
                CustomDatePicker customDatePickerEnd = new CustomDatePicker(GradustedInstitutionsAddFragment.this.getMContext(), GradustedInstitutionsAddFragment.this.getContext().getResources().getString(R.string.please_select_date_tips), new CustomDatePicker.ResultHandler(){

                    @Override
                    public void handle(String time) {
                        GradustedInstitutionsAddFragment.this.mEndTimeStr = time.split(" ")[0];
                        GradustedInstitutionsAddFragment.this.mEndTimeTv.setText((CharSequence)GradustedInstitutionsAddFragment.this.mEndTimeStr.substring(0, 7));
                        GradustedInstitutionsAddFragment.this.mEndTimeTv.setTextColor(GradustedInstitutionsAddFragment.this.getResources().getColor(R.color.color_333333));
                    }
                }, "1980-01-01 00:00", GradustedInstitutionsAddFragment.this.getCurTime(), new CustomDatePicker.DialogShowOrDismiss(){

                    @Override
                    public void show() {
                        GradustedInstitutionsAddFragment.this.mEndTimeImg.setImageResource(R.mipmap.up_normal);
                    }

                    @Override
                    public void dismiss() {
                        GradustedInstitutionsAddFragment.this.mEndTimeImg.setImageResource(R.mipmap.down_normal);
                    }
                });
                customDatePickerEnd.showSpecificTime(false);
                customDatePickerEnd.setIsLoop(false);
                customDatePickerEnd.show(GradustedInstitutionsAddFragment.this.stampToDate(System.currentTimeMillis()));
            }
        }
    }
}

