/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.EducationExperciseEneity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.EduSubInfoBody;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.presenter.EduInfoPresent;
import com.kangxin.doctor.worktable.view.DelEduView;
import com.kangxin.doctor.worktable.view.UpdateEduInfoView;
import com.kangxin.doctor.worktable.widget.CustomDatePicker;
import com.kangxin.doctor.worktable.widget.WheelDialog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

public class GradustedInstitutionsDeleteFragment
extends BaseFragment
implements IToolView,
DelEduView,
UpdateEduInfoView {
    private static final String TAG = "GradustedInstitutionsDe";
    private EditText mGradustedEt;
    private LinearLayout mProfessionalLayout;
    private TextView mProfessionalTv;
    private ImageView mProfessionalImg;
    private TextView mStartTimeTv;
    private TextView mEndTimeTv;
    private ImageView mStartTimeImg;
    private ImageView mEndTimeImg;
    private LinearLayout mStartTimeLl;
    private LinearLayout mEndTimeLl;
    private TextView mDeleteTv;
    private int mIndex;
    private String mStartTimeStr;
    private String mEndTimeStr;
    public static List<String> mList = new ArrayList<String>();
    private EduInfoPresent mEduInfoPresent;
    private EduInfoPresent mUpdateEduInfoPresent;
    private int mDelId = -1;

    public void init() {
        this.mEduInfoPresent = new EduInfoPresent(this);
        this.mUpdateEduInfoPresent = new EduInfoPresent(this);
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.gradusted_institutions_title));
        this.vRightTextView.setVisibility(0);
        this.vRightTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.forget_pw_submit));
        this.vRightTextView.setTextColor(this.getResources().getColor(R.color.white));
        this.vRightTextView.setOnClickListener(v -> {
            String gradusted = this.mGradustedEt.getText().toString().trim();
            String professional = this.mProfessionalTv.getText().toString();
            if (TextUtils.isEmpty((CharSequence)gradusted)) {
                this.showShortToast(this.getContext().getResources().getString(R.string.please_input_gradusted_tips));
                return;
            }
            if (professional.equals("\u8bf7\u9009\u62e9\u5b66\u5386")) {
                this.showShortToast("\u8bf7\u9009\u62e9\u5b66\u5386");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.mStartTimeStr)) {
                this.showShortToast(this.getContext().getResources().getString(R.string.please_select_date_tips));
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.mEndTimeStr)) {
                this.showShortToast(this.getContext().getResources().getString(R.string.please_select_date_tips));
                return;
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = format.parse(this.mStartTimeStr);
                Date date1 = format.parse(this.mEndTimeStr);
                if (date.getTime() > date1.getTime()) {
                    this.showShortToast("\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u622a\u6b62\u65e5\u671f");
                    return;
                }
                if (date.getTime() == date1.getTime()) {
                    this.showShortToast("\u8d77\u59cb\u65e5\u671f\u4e0e\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u76f8\u540c");
                    return;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            EduSubInfoBody eduSubInfoBody = new EduSubInfoBody();
            String docId = VertifyDataUtil.getInstance((Context)this.getContext()).getLoginUserId() + "";
            eduSubInfoBody.setDoctorId(docId);
            eduSubInfoBody.setId(this.mDelId);
            eduSubInfoBody.setSchoolName(this.mGradustedEt.getText().toString().trim());
            eduSubInfoBody.setEducationName(this.mProfessionalTv.getText().toString());
            eduSubInfoBody.setStartTime(this.mStartTimeStr);
            eduSubInfoBody.setEndTime(this.mEndTimeStr);
            this.mUpdateEduInfoPresent.reqUpdateEduInfo(eduSubInfoBody);
            GradustedInstitutionsDeleteFragment.HideKeyboard(this.rootView);
        });
        this.mGradustedEt = (EditText)this.findViewById(this.rootView, R.id.graduation_et);
        this.mProfessionalLayout = (LinearLayout)this.findViewById(this.rootView, R.id.professional_layout);
        this.mProfessionalTv = (TextView)this.findViewById(this.rootView, R.id.professional_tv);
        this.mProfessionalImg = (ImageView)this.findViewById(this.rootView, R.id.professional_img);
        this.mProfessionalLayout.setOnClickListener(v -> this.dialogList());
        this.mGradustedEt.setGravity(8388629);
        this.mGradustedEt.setTextDirection(3);
        this.mGradustedEt.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ARouter.getInstance().build("/minecenter/SearchSchoolActivity").navigation();
            }
        });
        this.mStartTimeTv = (TextView)this.findViewById(this.rootView, R.id.entrance_hours_tv);
        this.mEndTimeTv = (TextView)this.findViewById(this.rootView, R.id.graduation_time_tv);
        this.mStartTimeImg = (ImageView)this.findViewById(this.rootView, R.id.entrance_hours_img);
        this.mEndTimeImg = (ImageView)this.findViewById(this.rootView, R.id.graduation_time_img);
        this.mStartTimeLl = (LinearLayout)this.findViewById(this.rootView, R.id.entrance_hours_layout);
        this.mEndTimeLl = (LinearLayout)this.findViewById(this.rootView, R.id.graduation_time_layout);
        this.mStartTimeLl.setOnClickListener((View.OnClickListener)new StartAndEndOnClickListener());
        this.mEndTimeLl.setOnClickListener((View.OnClickListener)new StartAndEndOnClickListener());
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mIndex = bundle.getInt("index");
            this.mDelId = bundle.getInt("id");
            String name = bundle.getString("name");
            this.mGradustedEt.setText((CharSequence)name);
            String major = bundle.getString("major");
            this.mProfessionalTv.setText((CharSequence)major);
            this.mProfessionalTv.setTextColor(this.getResources().getColor(R.color.color_333333));
            this.mStartTimeStr = bundle.getString("startTime");
            if (this.mStartTimeStr.length() == 0) {
                return;
            }
            this.mStartTimeTv.setTextColor(this.getResources().getColor(R.color.color_333333));
            this.mStartTimeTv.setText((CharSequence)this.mStartTimeStr.split(" ")[0].substring(0, 7));
            this.mEndTimeStr = bundle.getString("endTime");
            if (this.mEndTimeStr.length() == 0) {
                return;
            }
            this.mEndTimeTv.setTextColor(this.getResources().getColor(R.color.color_333333));
            this.mEndTimeTv.setText((CharSequence)this.mEndTimeStr.split(" ")[0].substring(0, 7));
        }
        this.mDeleteTv = (TextView)this.findViewById(this.rootView, R.id.delete_educationeal_experience_tv);
        this.mDeleteTv.setOnClickListener((View.OnClickListener)new DeleteOnClickListener());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveSchoolDataEvent(ByhCommEvent.SchoolDataEvent schoolDataEvent) {
        String schoolName = schoolDataEvent.getSchoolName();
        this.mGradustedEt.setText((CharSequence)schoolName);
    }

    private void dialogList() {
        this.mProfessionalImg.setImageResource(R.mipmap.up_normal);
        WheelDialog wheelDialog = new WheelDialog(this.getMContext());
        wheelDialog.setLabels(mList);
        wheelDialog.setOnWheelSelectListener((index, selectLabel) -> {
            this.mProfessionalTv.setText((CharSequence)selectLabel);
            this.mProfessionalImg.setImageResource(R.mipmap.down_normal);
            this.mProfessionalTv.setTextColor(this.getResources().getColor(R.color.color_333333));
            wheelDialog.dismiss();
        });
        wheelDialog.show();
        wheelDialog.setCancelable(false);
        wheelDialog.setOnDismissListener(dialog -> {
            this.mProfessionalImg.setImageResource(R.mipmap.down_normal);
            wheelDialog.dismiss();
        });
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_graduated_institutions_details;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        GradustedInstitutionsDeleteFragment.HideKeyboard(this.rootView);
        this.pop();
    }

    @Override
    public void delEduOk() {
        EventBus.getDefault().post((Object)new WorkTabEvent.EduDelEvent(this.mIndex));
        this.pop();
    }

    public void onError(String msg) {
    }

    @Override
    public void updateEduInfoOk() {
        EventBus.getDefault().post((Object)new WorkTabEvent.EduCommitEvent(this.mIndex, new EducationExperciseEneity()));
        this.pop();
    }

    public String stampToDate(long timeMillis) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(timeMillis);
        return simpleDateFormat.format(date);
    }

    public String getCurTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.CHINA);
        return sdf.format(new Date());
    }

    public static void HideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }

    static {
        mList.add("\u5c0f\u5b66");
        mList.add("\u521d\u4e2d");
        mList.add("\u9ad8\u4e2d");
        mList.add("\u521d\u4e2d\u4e2d\u4e13");
        mList.add("\u9ad8\u4e2d\u4e2d\u4e13");
        mList.add("\u5927\u4e13");
        mList.add("\u672c\u79d1");
        mList.add("\u7814\u7a76\u751f");
        mList.add("\u535a\u58eb");
    }

    private class DeleteOnClickListener
    implements View.OnClickListener {
        private DeleteOnClickListener() {
        }

        public void onClick(View v) {
            GradustedInstitutionsDeleteFragment.HideKeyboard(GradustedInstitutionsDeleteFragment.this.rootView);
            GradustedInstitutionsDeleteFragment.this.mEduInfoPresent.reqDeleteEduInfo(GradustedInstitutionsDeleteFragment.this.mDelId + "");
        }
    }

    private class StartAndEndOnClickListener
    implements View.OnClickListener {
        private StartAndEndOnClickListener() {
        }

        public void onClick(View v) {
            int i = v.getId();
            if (i == R.id.entrance_hours_layout) {
                CustomDatePicker customDatePickerStart = new CustomDatePicker(GradustedInstitutionsDeleteFragment.this.getMContext(), GradustedInstitutionsDeleteFragment.this.getContext().getResources().getString(R.string.please_select_date_tips), new CustomDatePicker.ResultHandler(){

                    @Override
                    public void handle(String time) {
                        GradustedInstitutionsDeleteFragment.this.mStartTimeStr = time.split(" ")[0];
                        GradustedInstitutionsDeleteFragment.this.mStartTimeTv.setText((CharSequence)GradustedInstitutionsDeleteFragment.this.mStartTimeStr.substring(0, 7));
                        GradustedInstitutionsDeleteFragment.this.mStartTimeTv.setTextColor(GradustedInstitutionsDeleteFragment.this.getResources().getColor(R.color.color_333333));
                    }
                }, "1980-01-01 00:00", GradustedInstitutionsDeleteFragment.this.getCurTime(), new CustomDatePicker.DialogShowOrDismiss(){

                    @Override
                    public void show() {
                        GradustedInstitutionsDeleteFragment.this.mStartTimeImg.setImageResource(R.mipmap.up_normal);
                    }

                    @Override
                    public void dismiss() {
                        GradustedInstitutionsDeleteFragment.this.mStartTimeImg.setImageResource(R.mipmap.down_normal);
                    }
                });
                customDatePickerStart.showSpecificTime(false);
                customDatePickerStart.setIsLoop(false);
                customDatePickerStart.show(GradustedInstitutionsDeleteFragment.this.stampToDate(System.currentTimeMillis()));
            } else if (i == R.id.graduation_time_layout) {
                CustomDatePicker customDatePickerEnd = new CustomDatePicker(GradustedInstitutionsDeleteFragment.this.getMContext(), GradustedInstitutionsDeleteFragment.this.getContext().getResources().getString(R.string.please_select_date_tips), new CustomDatePicker.ResultHandler(){

                    @Override
                    public void handle(String time) {
                        GradustedInstitutionsDeleteFragment.this.mEndTimeStr = time.split(" ")[0];
                        GradustedInstitutionsDeleteFragment.this.mEndTimeTv.setText((CharSequence)GradustedInstitutionsDeleteFragment.this.mEndTimeStr.substring(0, 7));
                        GradustedInstitutionsDeleteFragment.this.mEndTimeTv.setTextColor(GradustedInstitutionsDeleteFragment.this.getResources().getColor(R.color.color_333333));
                    }
                }, "1980-01-01 00:00", GradustedInstitutionsDeleteFragment.this.getCurTime(), new CustomDatePicker.DialogShowOrDismiss(){

                    @Override
                    public void show() {
                        GradustedInstitutionsDeleteFragment.this.mEndTimeImg.setImageResource(R.mipmap.up_normal);
                    }

                    @Override
                    public void dismiss() {
                        GradustedInstitutionsDeleteFragment.this.mEndTimeImg.setImageResource(R.mipmap.down_normal);
                    }
                });
                customDatePickerEnd.showSpecificTime(false);
                customDatePickerEnd.setIsLoop(false);
                customDatePickerEnd.show(GradustedInstitutionsDeleteFragment.this.stampToDate(System.currentTimeMillis()));
            }
        }
    }
}

