/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.doctor.worktable.GradustedInstitutionsAddFragment;
import com.kangxin.doctor.worktable.GradustedInstitutionsDeleteFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.GradustedInstitutionsListAdapter;
import com.kangxin.doctor.worktable.entity.EduSubInfoBody;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.presenter.EduInfoPresent;
import com.kangxin.doctor.worktable.view.BindEduInfoView;
import java.util.List;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

public class GradustedInstitutionsListFragment
extends BaseFragment
implements IToolView,
BindEduInfoView {
    private static final String TAG = "GradustedInstitutionsLi";
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    private TextView mAddGraduatedTv;
    private GradustedInstitutionsListAdapter mGradustedInstitutionsListAdapter;
    private EduInfoPresent mEduInfoPresent;

    public void init() {
        ARouter.getInstance().inject((Object)this);
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.gradusted_institutions_title));
        this.mAddGraduatedTv = (TextView)this.findViewById(this.rootView, R.id.add_graduated_institutions);
        this.mAddGraduatedTv.setOnClickListener((View.OnClickListener)new AddDataOnClickListener());
        this.initAdapter();
        this.mEduInfoPresent = new EduInfoPresent(this);
        this.requestListDatas();
    }

    private void initAdapter() {
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.mGradustedInstitutionsListAdapter = new GradustedInstitutionsListAdapter();
        this.mGradustedInstitutionsListAdapter.setOnItemClickListener((adapter, view, position) -> {
            GradustedInstitutionsDeleteFragment gIDeleteFragment = new GradustedInstitutionsDeleteFragment();
            EduSubInfoBody educationExperciseEneity = (EduSubInfoBody)adapter.getItem(position);
            Bundle bundle = new Bundle();
            bundle.putInt("index", position);
            bundle.putString("name", educationExperciseEneity.getSchoolName());
            bundle.putString("major", educationExperciseEneity.getEducationName());
            bundle.putString("startTime", educationExperciseEneity.getStartTime());
            bundle.putString("endTime", educationExperciseEneity.getEndTime());
            bundle.putInt("id", educationExperciseEneity.getId());
            gIDeleteFragment.setArguments(bundle);
            this.start((ISupportFragment)gIDeleteFragment);
        });
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)this.mGradustedInstitutionsListAdapter);
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_graduated_institutions;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }

    @Override
    public void bindEduInfo(List<EduSubInfoBody> educationInfoBodies) {
        this.mGradustedInstitutionsListAdapter.setNewData(educationInfoBodies);
        this.mGradustedInstitutionsListAdapter.notifyDataSetChanged();
    }

    public void onError(String msg) {
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveAddEducation(WorkTabEvent.EduAdd event) {
        this.showShortToast(this.getContext().getResources().getString(R.string.gradusted_add_success));
        this.requestListDatas();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveDeletePosition(WorkTabEvent.EduDelEvent event) {
        this.showShortToast(this.getContext().getResources().getString(R.string.gradusted_delate_success));
        this.requestListDatas();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveCommitData(WorkTabEvent.EduCommitEvent event) {
        this.requestListDatas();
    }

    private void requestListDatas() {
        String docId = VertifyDataUtil.getInstance((Context)this.getContext()).getLoginUserId() + "";
        this.mEduInfoPresent.reqGetEducationInfo(docId);
    }

    private class AddDataOnClickListener
    implements View.OnClickListener {
        private AddDataOnClickListener() {
        }

        public void onClick(View v) {
            GradustedInstitutionsAddFragment gIAddFragment = new GradustedInstitutionsAddFragment();
            GradustedInstitutionsListFragment.this.start((ISupportFragment)gIAddFragment);
        }
    }
}

