/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import com.alibaba.android.arouter.launcher.ARouter;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.doctor.worktable.AccountIncomeFragment;
import com.kangxin.doctor.worktable.BoundBankCardsSaveInfoFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.BoundBankCardsInfoEntity;
import com.kangxin.doctor.worktable.presenter.IUnBundlingBankCardPresenter;
import com.kangxin.doctor.worktable.presenter.impl.BankCardsInfoPresenter;
import com.kangxin.doctor.worktable.presenter.impl.UnBundlingBankCardPresenter;
import com.kangxin.doctor.worktable.view.IBankCardsInfoView;
import com.kangxin.doctor.worktable.view.IUnBundlingBankCardsView;
import com.kangxin.doctor.worktable.widget.UnbundlingAlertDialog;
import me.yokeyword.fragmentation.ISupportFragment;
import org.jetbrains.annotations.NotNull;

public class ManagerBankCardsFragment
extends BaseFragment
implements IToolView,
IBankCardsInfoView,
UnbundlingAlertDialog.ClickUnbundlingBankCard,
IUnBundlingBankCardsView {
    private TextView mBankNameTv;
    private TextView mBankNumberTv;
    private TextView mBankTypeTv;
    private RelativeLayout mAddBankCard;
    private BankCardsInfoPresenter mBankCardsInfoPresenter;
    private IUnBundlingBankCardPresenter mUnBundlingBankCardPresenter;
    private LinearLayout vIsBoundLayout;
    private LinearLayout vNotBoundLayout;
    private UnbundlingAlertDialog mDialog;
    private int mIndex = -1;
    private int mCode = -1;
    private boolean isBindCard = false;

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)this.getResources().getString(R.string.manager_bank_card_title));
        this.vToolRightView.setImageDrawable(this.getResources().getDrawable(R.drawable.commbyh_by_bank_card_more_icon));
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mIndex = bundle.getInt("index");
        }
        this.initViews();
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_managing_bank_cards;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.finish();
    }

    private void initViews() {
        this.mBankCardsInfoPresenter = new BankCardsInfoPresenter(this);
        this.mUnBundlingBankCardPresenter = new UnBundlingBankCardPresenter(this);
        this.mBankNameTv = (TextView)this.findViewById(this.rootView, R.id.bank_name_tv);
        this.mBankNumberTv = (TextView)this.findViewById(this.rootView, R.id.tv_bank_number);
        this.mBankTypeTv = (TextView)this.findViewById(this.rootView, R.id.bank_type_tv);
        this.mAddBankCard = (RelativeLayout)this.findViewById(this.rootView, R.id.add_bankcard_rl);
        this.mAddBankCard.setOnClickListener((View.OnClickListener)new ClickOnClickListener());
        this.vIsBoundLayout = (LinearLayout)this.findViewById(this.rootView, R.id.bankcards_isbound_layout);
        this.vNotBoundLayout = (LinearLayout)this.findViewById(this.rootView, R.id.bankcards_notbound_layout);
        this.vIsBoundLayout.setVisibility(8);
        this.vNotBoundLayout.setVisibility(8);
        if (this.mIndex == 1) {
            this.mBankCardsInfoPresenter.sendBankCardDoctorId(this.getContext(), true);
        } else if (this.mIndex == 2) {
            this.vIsBoundLayout.setVisibility(8);
            this.vNotBoundLayout.setVisibility(0);
        } else if (this.mIndex == 3) {
            this.mBankCardsInfoPresenter.sendBankCardDoctorId(this.getContext(), true);
        }
        this.vToolRightView.setOnClickListener(v -> {
            if (this.isBindCard) {
                this.mDialog = new UnbundlingAlertDialog(this.mContext);
                this.mDialog.show();
                this.mDialog.setOnUnbundlingBankCardListener(this);
            } else {
                this.showShortToast("\u672a\u7ed1\u5b9a\u94f6\u884c\u5361");
            }
        });
    }

    @Override
    public void setBankCardsOk(ResponseBody responseBody) {
        if (responseBody == null) {
            return;
        }
        this.setViews(responseBody.getCode(), responseBody.getMsg(), (BoundBankCardsInfoEntity)responseBody.getResult());
    }

    @Override
    public void unBindCard() {
        this.vIsBoundLayout.setVisibility(8);
        this.vNotBoundLayout.setVisibility(0);
    }

    @Override
    public void unBundlingBankCard() {
        this.mDialog.dismiss();
        this.mUnBundlingBankCardPresenter.unBundlingBankCard(this.getContext(), true);
    }

    @Override
    public void unBundlingBankCardsOk(ResponseBody responseBody) {
        if (responseBody == null) {
            return;
        }
        if (responseBody.getCode() == 200) {
            this.mBankCardsInfoPresenter.sendBankCardDoctorId(this.getContext(), true);
        } else {
            this.showShortToast(responseBody.getMsg());
        }
    }

    private void showVerNameDialog() {
        new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.worktab_vername_title).setMessage(R.string.worktab_vername_desc).setPositiveButton((CharSequence)"\u6682\u4e0d\u7ed1\u5361", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setNegativeButton((CharSequence)"\u8fdb\u884c\u5b9e\u540d\u8ba4\u8bc1", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ARouter.getInstance().build("/framcontrwk/FrameNotitleActivity").withInt("MSG_JUMP_TYPE", 86403).navigation();
            }
        }).show();
    }

    private void setViews(int code, String msg, BoundBankCardsInfoEntity boundBankCardsInfoEntity) {
        this.mCode = code;
        if (code == 200) {
            if (boundBankCardsInfoEntity == null) {
                return;
            }
            this.isBindCard = true;
            this.mBankNameTv.setText((CharSequence)boundBankCardsInfoEntity.getIssuingBank());
            this.mBankTypeTv.setText((CharSequence)boundBankCardsInfoEntity.getCardType());
            String cardNo = boundBankCardsInfoEntity.getCardNo();
            this.mBankNumberTv.setText((CharSequence)cardNo.substring(cardNo.length() - 4, cardNo.length()));
            this.vIsBoundLayout.setVisibility(0);
            this.vNotBoundLayout.setVisibility(8);
        } else {
            this.vIsBoundLayout.setVisibility(8);
            this.vNotBoundLayout.setVisibility(0);
        }
    }

    public boolean onBackPressedSupport() {
        this.finish();
        return true;
    }

    private void finish() {
        if (this.mIndex == 1) {
            this.pop();
        } else if (this.mIndex == 2) {
            this.pop();
        } else if (this.mIndex == 3) {
            AccountIncomeFragment accountIncomeFragment = new AccountIncomeFragment();
            this.start((ISupportFragment)accountIncomeFragment);
        }
    }

    private class ClickOnClickListener
    implements View.OnClickListener {
        private ClickOnClickListener() {
        }

        public void onClick(View v) {
            ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)ManagerBankCardsFragment.this.getContext()).getUserInfo();
            if (userInfoVOBean != null) {
                String idcardNum = userInfoVOBean.getCredNo();
                if (TextUtils.isEmpty((CharSequence)idcardNum)) {
                    ManagerBankCardsFragment.this.showVerNameDialog();
                } else {
                    BoundBankCardsSaveInfoFragment boundBankCardsSaveInfoFragment = new BoundBankCardsSaveInfoFragment();
                    ManagerBankCardsFragment.this.start((ISupportFragment)boundBankCardsSaveInfoFragment);
                }
            }
        }
    }
}

