/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import butterknife.OnClick;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.VertifyClickListener;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.v2.DocDetailEntity;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.presenter.impl.AccountBalancePersenter;
import com.kangxin.doctor.worktable.view.IAccountBalanceView;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

@Route(path="/minecenter/MineCenterFragment")
public class MineCenterFragment
extends BaseFragment
implements IToolView,
IAccountBalanceView {
    private ImageView vHeadShotImg;
    private TextView vDoctorNameTv;
    private LinearLayout vDoctorpPofessionalLl;
    private TextView vProfessionalTitlesTv;
    private ImageView vExpertsImg;
    private TextView vHospitalDeptTv;
    private TextView vIncomeTv;
    private ImageView vIsShowImg;
    private TextView vDynamicTv;
    private AccountBalancePersenter mAccountBalancePresenter = new AccountBalancePersenter(this);
    private boolean mIsShowIncome = false;
    private String mIncomeResult;
    @Autowired
    IUpdateVerStatus updateVerStatus;

    public void init() {
        this.vToolLeftImage.setVisibility(8);
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.mine_center_title));
        this.vToolRightView.setImageResource(R.drawable.wktab_ic_erweima);
        this.vToolRightView.setVisibility(0);
        this.vToolRightView.setOnClickListener((View.OnClickListener)new VertifyClickListener(){

            protected void onClickOk(View view) {
                ARouter.getInstance().build("/minecard/BusinessCardSharingActivity").navigation();
            }
        });
        this.initView();
    }

    private void initView() {
        this.vHeadShotImg = (ImageView)this.findViewById(this.rootView, R.id.head_shot_img);
        this.vDoctorNameTv = (TextView)this.findViewById(this.rootView, R.id.textView);
        this.vDoctorpPofessionalLl = (LinearLayout)this.findViewById(this.rootView, R.id.pofessional_ll);
        this.vProfessionalTitlesTv = (TextView)this.findViewById(this.rootView, R.id.textView2);
        this.vExpertsImg = (ImageView)this.findViewById(this.rootView, R.id.image_title);
        this.vHospitalDeptTv = (TextView)this.findViewById(this.rootView, R.id.textView3);
        this.vIncomeTv = (TextView)this.findViewById(this.rootView, R.id.textView6);
        this.vIsShowImg = (ImageView)this.findViewById(this.rootView, R.id.is_show_img);
        this.vDynamicTv = (TextView)this.findViewById(this.rootView, R.id.textView8);
        this.getUserInfoDate();
        this.addOnClickListener();
    }

    private void getUserInfoDate() {
        ExpertInfoEntity expertInfoEntity = VertifyDataUtil.getInstance((Context)this.getMContext()).getExpertInfo();
        LoginSuccess loginSuccess = VertifyDataUtil.getInstance((Context)this.getMContext()).getLoginData();
        if (expertInfoEntity == null || loginSuccess == null) {
            this.initStatus();
            return;
        }
        this.isSeeShow();
        this.vIsShowImg.setEnabled(true);
        this.vIsShowImg.setClickable(true);
        this.vDoctorpPofessionalLl.setVisibility(0);
        int status = 0;
        switch (status) {
            case 5: {
                int userType = 0;
                if (userType == 2) {
                    this.vExpertsImg.setVisibility(0);
                    break;
                }
                if (userType == 3) {
                    this.vExpertsImg.setVisibility(0);
                    break;
                }
                this.vExpertsImg.setVisibility(8);
                break;
            }
            case 21554: {
                this.vExpertsImg.setVisibility(8);
                break;
            }
            case 7: {
                this.vExpertsImg.setVisibility(8);
                break;
            }
            case -5: {
                this.vExpertsImg.setVisibility(8);
                break;
            }
            case 1: {
                this.vExpertsImg.setVisibility(8);
                break;
            }
            case 2: {
                this.vExpertsImg.setVisibility(8);
                break;
            }
            case -1: {
                this.vExpertsImg.setVisibility(8);
                break;
            }
            case 3: {
                this.vExpertsImg.setVisibility(8);
                break;
            }
            case 4: {
                this.vExpertsImg.setVisibility(8);
                break;
            }
            case 9: {
                this.vExpertsImg.setVisibility(8);
            }
        }
    }

    private void addOnClickListener() {
        this.vIsShowImg.setOnClickListener(v -> {
            if (this.mIsShowIncome) {
                this.vIsShowImg.setImageResource(R.mipmap.ic_see);
                this.mIsShowIncome = false;
                if (TextUtils.isEmpty((CharSequence)this.mIncomeResult)) {
                    this.vIncomeTv.setText((CharSequence)"0");
                } else {
                    this.vIncomeTv.setText((CharSequence)this.mIncomeResult);
                }
            } else {
                this.vIsShowImg.setImageResource(R.mipmap.ic_nosee);
                this.mIsShowIncome = true;
                this.vIncomeTv.setText((CharSequence)"******");
            }
        });
        this.findViewById(this.rootView, R.id.constraint_layout).setOnClickListener((View.OnClickListener)new VertifyClickListener(8755){

            protected void onClickOk(View view) {
                ARouter.getInstance().build("/mineperson/PersonalInformationActivity").navigation();
            }
        });
        this.findViewById(this.rootView, R.id.constraintLayout2).setOnClickListener((View.OnClickListener)new VertifyClickListener(){

            protected void onClickOk(View view) {
                ARouter.getInstance().build("/mineservice/ServiceSettingCountryActivity").navigation();
            }
        });
        this.findViewById(this.rootView, R.id.constraintLayout3).setOnClickListener((View.OnClickListener)new VertifyClickListener(8755){

            protected void onClickOk(View view) {
                ARouter.getInstance().build("/minefeedback/FeedbackInfoActivity").navigation();
            }
        });
        this.findViewById(this.rootView, R.id.constraintLayout4).setOnClickListener((View.OnClickListener)new VertifyClickListener(8755){

            protected void onClickOk(View view) {
                ARouter.getInstance().build("/minecontact/ContactUsActivity").navigation();
            }
        });
    }

    @OnClick(value={2131427451})
    public void clickSetting() {
        ARouter.getInstance().build("/seting/AboutActivity").navigation();
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_mine_center;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
    }

    @Override
    public void getAccountSuccess(DocDetailEntity responseBody) {
        if (responseBody == null) {
            return;
        }
        this.mIncomeResult = responseBody.getBalance() + "";
        this.isSeeShow();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void updatePage(ByhCommEvent.LoginOkEvent loginOkEvent) {
        this.getUserInfoDate();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void exitAppUpdatePage(ByhCommEvent.ExitAppOk exitAppOk) {
        this.initStatus();
    }

    private void initStatus() {
        this.mIsShowIncome = false;
        this.vDoctorpPofessionalLl.setVisibility(8);
        this.vExpertsImg.setVisibility(8);
        this.vHeadShotImg.setImageResource(R.drawable.ic_byh_comm_header);
        this.vDoctorNameTv.setText((CharSequence)this.getContext().getResources().getString(R.string.no_login_name));
        this.vHospitalDeptTv.setText((CharSequence)this.getContext().getResources().getString(R.string.no_login_hosipital));
        this.vDoctorpPofessionalLl.setVisibility(8);
        this.vIncomeTv.setText((CharSequence)"0");
        this.vDynamicTv.setText((CharSequence)"0");
        this.vIsShowImg.setImageResource(R.mipmap.ic_nosee);
        this.vIncomeTv.setText((CharSequence)"******");
        this.vIsShowImg.setEnabled(false);
        this.vIsShowImg.setClickable(false);
    }

    private void isSeeShow() {
        if (this.mIsShowIncome) {
            this.vIsShowImg.setImageResource(R.mipmap.ic_see);
            if (!TextUtils.isEmpty((CharSequence)this.mIncomeResult)) {
                this.vIncomeTv.setText((CharSequence)this.mIncomeResult);
            } else {
                this.vIncomeTv.setText((CharSequence)"0");
            }
        } else {
            this.vIsShowImg.setImageResource(R.mipmap.ic_nosee);
            this.vIncomeTv.setText((CharSequence)"******");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveJobTitle(WorkTabEvent.UpdateDataSuccess setHeadShotSuccess) {
        this.updateVerStatus.updateDocDetailInfo(this.getContext(), new IUpdateVerStatus.OnUpdateDocDetailInfoCallback(){

            public void updateDocDetailInfoOk() {
                MineCenterFragment.this.getUserInfoDate();
            }

            public void updateDocDetailInfoErr(String err) {
                MineCenterFragment.this.showShortToast(err);
            }
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN, sticky=true)
    public void receiveUpdateData(ByhCommEvent.UpdatePersonalCenter updatePersonalCenter) {
        switch (updatePersonalCenter.getStatus()) {
            case 4096: {
                this.initStatus();
                this.vDoctorNameTv.setText((CharSequence)"\u6b63\u5728\u52aa\u529b\u83b7\u53d6\u6570\u636e\u4e2d...");
                this.vHospitalDeptTv.setVisibility(8);
                break;
            }
            case 4097: {
                new Handler().postDelayed(() -> this.getUserInfoDate(), 200L);
                this.vHospitalDeptTv.setVisibility(0);
                break;
            }
            case 4098: {
                this.initStatus();
                this.vDoctorNameTv.setText((CharSequence)"\u83b7\u53d6\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u91cd\u542f\u5e94\u7528");
                this.vHospitalDeptTv.setVisibility(8);
            }
        }
    }
}

