/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.view.View;
import android.widget.CheckBox;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.base.ByBaseStateTitleFlushMoreFragment;
import com.kangxin.common.byh.entity.OrderItemEntity;
import com.kangxin.common.byh.entity.response.PatientDetailEntity;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.v2.NewOrderApplyAdapterV2;
import com.kangxin.doctor.worktable.presenter.IPatientNewApplyPresenter;
import com.kangxin.doctor.worktable.presenter.impl.PatientNewApplyPresenter;
import com.kangxin.doctor.worktable.view.IPatientNewApplyListView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import java.io.Serializable;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

public class NewApplyFragment
extends ByBaseStateTitleFlushMoreFragment<OrderItemEntity>
implements IToolView,
IPatientNewApplyListView<OrderItemEntity> {
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    @BindView(value=2131428252)
    SmartRefreshLayout vRefreshLayout;
    private PatientDetailEntity mPatientDetailEntity;
    private OrderItemEntity mOrderItemEntity;
    private IPatientNewApplyPresenter mPatientNewApplyPresenter = new PatientNewApplyPresenter(this);

    public void init() {
        super.init();
        this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.new_apply_title));
        this.vRightTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.btn_finish_tip));
        this.vRightTextView.setTextColor(-1);
        this.vRightTextView.setVisibility(0);
    }

    public void onInitComplete() {
        super.onInitComplete();
        this.dispatchEvent();
    }

    protected void flushOrLoad(boolean isGetMore) {
        this.mPatientNewApplyPresenter.getPatientNewApplyList(isGetMore);
    }

    private void dispatchEvent() {
        this.mAdapter.setOnItemChildClickListener((adapter, view, position) -> {
            int id2 = view.getId();
            if (id2 == R.id.vLookCase) {
                this.mPatientNewApplyPresenter.getPatientDetail(((OrderItemEntity)this.mAdapter.getData().get(position)).getOrderViewId(), true);
            } else if (id2 == R.id.vSelect) {
                this.mOrderItemEntity = view instanceof CheckBox ? (!view.isSelected() ? (OrderItemEntity)this.mAdapter.getData().get(position) : null) : (OrderItemEntity)this.mAdapter.getData().get(position);
                if (this.mOrderItemEntity == null) {
                    ToastUtils.showShort((CharSequence)this.getContext().getResources().getString(R.string.at_least_select));
                    return;
                }
                this.mPatientNewApplyPresenter.getPatientDetail(this.mOrderItemEntity.getOrderViewId(), false);
            }
        });
        this.vRefreshLayout.setOnRefreshListener(refreshlayout -> this.mPatientNewApplyPresenter.getPatientNewApplyList(false));
        this.mAdapter.setOnLoadMoreListener(() -> this.mPatientNewApplyPresenter.getPatientNewApplyList(true), this.vRecyclerView);
        this.vRightTextView.setOnClickListener(v -> {
            if (this.mOrderItemEntity == null) {
                ToastUtils.showShort((CharSequence)this.getContext().getResources().getString(R.string.at_least_select));
                return;
            }
            this.mPatientNewApplyPresenter.getPatientDetail(this.mOrderItemEntity.getOrderViewId(), false);
        });
    }

    protected BaseQuickAdapter<OrderItemEntity, ? extends BaseViewHolder> getBaseQuickAdapter() {
        return new NewOrderApplyAdapterV2(null);
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_order_apply_new_patient;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }

    @Override
    public void success(PatientDetailEntity patientDetailEntity) {
        EventBus.getDefault().post((Object)patientDetailEntity.parsePatientEntity());
        this.finishCurrentView();
    }

    @Override
    public void toPatientDetail(PatientDetailEntity patientDetailEntity) {
        patientDetailEntity.setHideBottomButton(true);
        Bundle bundle = new Bundle();
        bundle.putInt("MSG_JUMP_TYPE", 5381);
        bundle.putSerializable("MSG_APPLY_DETAIL", (Serializable)patientDetailEntity);
        ARouter.getInstance().build("/patientdetail/patient_detail_activity").with(bundle).navigation();
    }

    public int showContentLayout() {
        return R.id.vRefreshLayout;
    }
}

