/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.activity.MulitImageShowActivity;
import com.kangxin.common.byh.adapter.SelectImageListAdapter;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.ExpertItemEntity;
import com.kangxin.common.byh.entity.OrderApplyEntity;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.PatientEntity;
import com.kangxin.common.byh.entity.UpdateCaseEntity;
import com.kangxin.common.byh.entity.response.PatientDetailEntity;
import com.kangxin.common.byh.entity.v2.ExpertItemEntityV2;
import com.kangxin.common.byh.inter.IPatientCaseUpdateEvent;
import com.kangxin.common.byh.present.IOrderApplyPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.widget.BottomSelectDialog;
import com.kangxin.common.byh.widget.SelectImageDecoration;
import com.kangxin.doctor.worktable.AddPatientFragment;
import com.kangxin.doctor.worktable.BuildConfig;
import com.kangxin.doctor.worktable.CityFragment;
import com.kangxin.doctor.worktable.DepartmentFilterFragment;
import com.kangxin.doctor.worktable.FamousExpertFragment;
import com.kangxin.doctor.worktable.NewApplyFragment;
import com.kangxin.doctor.worktable.OrderApplySignFragment;
import com.kangxin.doctor.worktable.OrderApplySuccessFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.SampleHospitalListFragment;
import com.kangxin.doctor.worktable.SelectHospitalFragment;
import com.kangxin.doctor.worktable.presenter.impl2.BHOrderApplyPresenter;
import com.kangxin.doctor.worktable.util.SkipUtil;
import com.kangxin.doctor.worktable.view.IOrderApplyView;
import com.kangxin.doctor.worktable.widget.OrderTypeSelectDialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.jetbrains.annotations.NotNull;

public class OrderApplyFragment
extends BaseFragment
implements IToolView,
IOrderApplyView {
    private static final int REQUEST_CITY_CODE = 1;
    private static final int REQUEST_DEPARTMENT_CODE = 2;
    private static final int REQUEST_HOSPITAL_CODE = 3;
    @BindView(value=2131428101)
    TextView vChangeExpert;
    @BindView(value=2131428084)
    TextView vAddPatient;
    @BindView(value=2131428272)
    TextView vSelectPatient;
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    @BindView(value=2131428197)
    TextView vMustUploadCaseFile;
    @BindView(value=2131428154)
    TextView vExpertName;
    @BindView(value=2131428150)
    TextView vExpertLevel;
    @BindView(value=2131428147)
    TextView vExpertHospital;
    @BindView(value=2131428142)
    TextView vExpertDepartment;
    @BindView(value=2131428209)
    TextView vOrderType;
    @BindView(value=2131428225)
    TextView vPatientName;
    @BindView(value=2131428230)
    TextView vPatientSex;
    @BindView(value=2131428213)
    TextView vPatientAge;
    @BindView(value=2131428215)
    TextView vPatientCard;
    @BindView(value=2131428227)
    TextView vPatientPhone;
    @BindView(value=2131428244)
    TextView vPresentHistory;
    @BindView(value=2131428194)
    EditText vMainSuit;
    @BindView(value=2131428260)
    EditText vResult;
    @BindView(value=2131428196)
    EditText vMudi;
    @BindView(value=2131428236)
    EditText vPerHistory;
    @BindView(value=2131428195)
    EditText vMedicalHistory;
    @BindView(value=2131428164)
    EditText vFamilyHistory;
    @BindView(value=2131428092)
    TextView vAreaSelect;
    @BindView(value=2131428183)
    TextView vHospitalSelect;
    @BindView(value=2131428131)
    TextView vDepartmentSelect;
    @BindView(value=2131428211)
    TextView vOrderTypeSelect;
    @BindView(value=2131428148)
    ConstraintLayout vExpertInfo;
    @BindView(value=2131428246)
    ConstraintLayout vQuickDistribute;
    @BindView(value=2131428247)
    ConstraintLayout vQucikDistributeHeadLayout;
    @BindView(value=2131428105)
    TextView vCommit;
    @BindView(value=2131428268)
    ScrollView vScrollView;
    AlertDialog vAlertDialog;
    OrderTypeSelectDialog orderTypeSelectDialog;
    private SelectImageListAdapter mAdapter;
    private ExpertItemEntity mExpertEntity;
    private int mOrderType;
    private int mApplicationChannels = 10;
    private boolean isQuickDistribute = false;
    private String mPatientId;
    private long mHospitalId;
    private Integer mDepartmentId;
    private int mCityId;
    private IOrderApplyPresenter mOrderApplyPresenter = new BHOrderApplyPresenter(this);
    List<PatientDetailEntity.AttchMentEntity> caseAttachmentList;
    List<Integer> ids = new ArrayList<Integer>();
    private Long mOrderId;
    boolean isUpdateOrder;
    private OrderDetailEntity orderDetailEntity = null;
    private PatientEntity mPatientEntity;

    public static OrderApplyFragment newInstance(int mApplicationChannels) {
        ExpertItemEntity entity = new ExpertItemEntity();
        if (mApplicationChannels == 30) {
            return OrderApplyFragment.newInstance(entity, 4, true);
        }
        return OrderApplyFragment.newInstance(entity, 4, 10);
    }

    public static OrderApplyFragment newInstance(ExpertItemEntity mExpertEntity, int mOrderType, boolean isQuickDistribute) {
        OrderApplyFragment orderApplyFragment = new OrderApplyFragment();
        orderApplyFragment.mExpertEntity = mExpertEntity;
        orderApplyFragment.mOrderType = mOrderType;
        orderApplyFragment.isQuickDistribute = isQuickDistribute;
        Bundle bundle = new Bundle();
        bundle.putSerializable("mExpertEntity", (Serializable)mExpertEntity);
        bundle.putInt("mOrderType", mOrderType);
        if (isQuickDistribute) {
            orderApplyFragment.mApplicationChannels = 30;
        }
        bundle.putInt("mApplicationChannels", orderApplyFragment.mApplicationChannels);
        bundle.putBoolean("isQuickDistribute", isQuickDistribute);
        orderApplyFragment.setArguments(bundle);
        return orderApplyFragment;
    }

    public static OrderApplyFragment newInstance(ExpertItemEntity expertItemEntity, int orderType, int mApplicationChannels) {
        OrderApplyFragment orderApplyFragment = new OrderApplyFragment();
        orderApplyFragment.mExpertEntity = expertItemEntity;
        orderApplyFragment.mOrderType = orderType;
        orderApplyFragment.mApplicationChannels = mApplicationChannels;
        Bundle bundle = new Bundle();
        bundle.putSerializable("mExpertEntity", (Serializable)expertItemEntity);
        bundle.putInt("mOrderType", orderType);
        bundle.putBoolean("isQuickDistribute", orderApplyFragment.isQuickDistribute);
        bundle.putInt("mApplicationChannels", mApplicationChannels);
        orderApplyFragment.setArguments(bundle);
        return orderApplyFragment;
    }

    public static OrderApplyFragment newInstance(OrderDetailEntity orderApplyEntity, boolean isUpdateOrder) {
        ExpertItemEntity expertItemEntity = ExpertItemEntity.parse((OrderDetailEntity)orderApplyEntity);
        PatientEntity patientEntity = PatientEntity.parse((OrderDetailEntity)orderApplyEntity);
        OrderApplyFragment orderApplyFragment = new OrderApplyFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable("mExpertEntity", (Serializable)expertItemEntity);
        bundle.putInt("mOrderType", orderApplyEntity.getOrderType());
        bundle.putBoolean("isQuickDistribute", orderApplyFragment.isQuickDistribute);
        bundle.putInt("mApplicationChannels", orderApplyEntity.getOrderApplicationChannels());
        bundle.putSerializable("mPatientEntity", (Serializable)patientEntity);
        bundle.putBoolean("isUpdateOrder", isUpdateOrder);
        bundle.putSerializable("orderEntity", (Serializable)orderApplyEntity);
        orderApplyFragment.setArguments(bundle);
        return orderApplyFragment;
    }

    public void init() {
        Bundle arguments = this.getArguments();
        this.mOrderType = arguments.getInt("mOrderType");
        this.mApplicationChannels = arguments.getInt("mApplicationChannels");
        this.isQuickDistribute = arguments.getBoolean("isQuickDistribute");
        this.mExpertEntity = (ExpertItemEntity)arguments.getSerializable("mExpertEntity");
        PatientEntity mPatientEntity = null;
        if (arguments.getSerializable("mPatientEntity") != null) {
            mPatientEntity = (PatientEntity)arguments.getSerializable("mPatientEntity");
        }
        this.isUpdateOrder = arguments.getBoolean("isUpdateOrder", false);
        if (arguments.getSerializable("orderEntity") != null) {
            this.orderDetailEntity = (OrderDetailEntity)arguments.getSerializable("orderEntity");
        }
        this.vToolTitleTextView.setText((CharSequence)"\u4f1a\u8bca\u7533\u8bf7\u5355");
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext, 0, false));
        ArrayList arrayList = new ArrayList();
        this.mAdapter = new SelectImageListAdapter(arrayList);
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.showAddImage();
        this.vRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SelectImageDecoration(20));
        this.initAlertDialog();
        this.orderTypeSelectDialog = new OrderTypeSelectDialog(this.mContext);
        if (this.mExpertEntity == null || this.mExpertEntity.getDoctorDetailInfoEntity() != null) {
            // empty if block
        }
        if (mPatientEntity != null) {
            this.fullPatientInfo(mPatientEntity);
        }
        if (this.orderDetailEntity != null) {
            this.fullOrderInfo();
        }
        this.styleSwitch();
        this.dispatchEvent();
    }

    private void fullOrderInfo() {
        this.vMainSuit.setText((CharSequence)this.orderDetailEntity.getPatCaseMainSuit());
        this.vPresentHistory.setText((CharSequence)this.orderDetailEntity.getPresentHistory());
        this.vPerHistory.setText((CharSequence)this.orderDetailEntity.getPastHistory());
        this.vFamilyHistory.setText((CharSequence)this.orderDetailEntity.getPatCaseFamilyHistory());
        this.vMedicalHistory.setText((CharSequence)this.orderDetailEntity.getPatCaseMedicationHistory());
        this.vResult.setText((CharSequence)this.orderDetailEntity.getPatPrimaryDiagno());
        this.vMudi.setText((CharSequence)this.orderDetailEntity.getPatCaseConsultAim());
    }

    private void styleSwitch() {
        if (this.isQuickDistribute && !this.isUpdateOrder) {
            this.vExpertInfo.setVisibility(4);
            this.vQuickDistribute.setVisibility(0);
            this.vQucikDistributeHeadLayout.setVisibility(0);
        } else {
            this.vExpertInfo.setVisibility(0);
            this.vQuickDistribute.setVisibility(4);
            this.vQucikDistributeHeadLayout.setVisibility(8);
            this.fullExpertInfo(this.mExpertEntity);
        }
        if (!BuildConfig.isMustUploadCaseFile.booleanValue()) {
            this.vMustUploadCaseFile.setVisibility(8);
        }
        if (this.isUpdateOrder) {
            this.vAddPatient.setVisibility(8);
            this.vSelectPatient.setVisibility(8);
            this.vChangeExpert.setVisibility(8);
        }
    }

    private void initAlertDialog() {
        this.vAlertDialog = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)this.getContext().getResources().getString(R.string.consultation_application_title)).setMessage((CharSequence)this.getContext().getResources().getString(R.string.exit_applicaiton_tips)).setPositiveButton((CharSequence)this.getContext().getResources().getString(R.string.cancle), (dialog, which) -> dialog.dismiss()).setNegativeButton((CharSequence)this.getContext().getResources().getString(R.string.ok_exit), (dialog, which) -> {
            if (this.isQuickDistribute) {
                this._mActivity.finish();
            } else {
                this.pop();
            }
        }).create();
    }

    private void dispatchEvent() {
        this.orderTypeSelectDialog.setListener((position, value) -> {
            if (value == 4) {
                this.vOrderTypeSelect.setText((CharSequence)this.getContext().getResources().getString(R.string.video));
            } else if (value == 5) {
                this.vOrderTypeSelect.setText((CharSequence)this.getContext().getResources().getString(R.string.graphic));
            }
            this.mOrderType = value;
        });
        this.vHospitalSelect.setOnClickListener(v -> this.startForResult((ISupportFragment)SampleHospitalListFragment.newInstance(this.mCityId + "", false), 3));
        this.vAreaSelect.setOnClickListener(v -> this.startForResult((ISupportFragment)new CityFragment(), 1));
        this.vDepartmentSelect.setOnClickListener(v -> this.startForResult((ISupportFragment)DepartmentFilterFragment.newInstance(this.mHospitalId), 2));
        this.vOrderTypeSelect.setOnClickListener(v -> this.orderTypeSelectDialog.show());
        this.mAdapter.setOnItemChildClickListener(new SelectImageListAdapter.OnItemChildClickListener(){

            public void onDelete(int position) {
                if (OrderApplyFragment.this.caseAttachmentList != null && OrderApplyFragment.this.caseAttachmentList.size() > 0) {
                    OrderApplyFragment.this.caseAttachmentList.remove(position);
                }
                if (OrderApplyFragment.this.mAdapter.getImageDatas() != null && OrderApplyFragment.this.mAdapter.getImageDatas().size() > 0) {
                    OrderApplyFragment.this.mAdapter.getImageDatas().remove(position);
                }
                if (OrderApplyFragment.this.ids != null && OrderApplyFragment.this.ids.size() > 0) {
                    OrderApplyFragment.this.ids.remove(position);
                }
                OrderApplyFragment.this.mAdapter.notifyDataSetChanged();
            }

            public void onLook(int position) {
                Bundle bundle = new Bundle();
                List imageDatas = OrderApplyFragment.this.mAdapter.getImageDatas();
                ArrayList<String> images = new ArrayList<String>();
                for (int i = 0; i < imageDatas.size(); ++i) {
                    String s = (String)imageDatas.get(i);
                    if (StringUtils.isEmpty((CharSequence)s)) continue;
                    images.add(s);
                }
                bundle.putStringArrayList("images", images);
                bundle.putInt("position", position);
                SkipUtil.skipActivity((Activity)OrderApplyFragment.this._mActivity, MulitImageShowActivity.class, bundle);
            }

            public void onAdd() {
                BottomSelectDialog bottomSelectDialog = new BottomSelectDialog(OrderApplyFragment.this.mContext, 3);
                OrderApplyFragment.this.requestEachPermission(new String[]{"android.permission.CAMERA"}).subscribe(permission2 -> {
                    if (permission2.granted) {
                        bottomSelectDialog.show();
                    } else {
                        ToastUtils.showShort((CharSequence)(OrderApplyFragment.this.getContext().getResources().getString(R.string.give_permissions_tips) + permission2.name));
                    }
                });
                bottomSelectDialog.setImageSelectListener(new BottomSelectDialog.ImageSelectListener(){

                    public void onImageList(List<String> strings) {
                        OrderApplyFragment.this.mAdapter.addImageData(strings);
                    }
                });
            }
        });
        this.vChangeExpert.setOnClickListener(v -> {
            if (this.mApplicationChannels == 10) {
                this.popTo(SelectHospitalFragment.class, false);
            } else if (this.mApplicationChannels == 20) {
                this.popTo(FamousExpertFragment.class, false);
            }
        });
        this.vAddPatient.setOnClickListener(v -> this.start((ISupportFragment)AddPatientFragment.newInstance()));
        this.vSelectPatient.setOnClickListener(v -> this.start((ISupportFragment)new NewApplyFragment()));
        this.vCommit.setOnClickListener(v -> {
            if (this.isUpdateOrder) {
                UpdateCaseEntity caseEntity = this.gatherCaseData();
                this.mOrderApplyPresenter.updateOrderCase(caseEntity, this.mAdapter.getImageDatas(), this.ids);
            } else {
                OrderApplyEntity orderApplyEntity = this.gatherData();
                if (orderApplyEntity == null) {
                    return;
                }
                this.mOrderApplyPresenter.applyOrder(orderApplyEntity, this.mAdapter.getImageDatas(), this.ids);
            }
        });
    }

    private UpdateCaseEntity gatherCaseData() {
        UpdateCaseEntity caseEntity = new UpdateCaseEntity();
        caseEntity.setDcmPackUrl(this.orderDetailEntity.getDcmPackUrl());
        caseEntity.setDcmFileUrl(this.orderDetailEntity.getDcmFileUrl());
        caseEntity.setConsultAim(this.vMudi.getText().toString());
        caseEntity.setFamilyHistory(this.vFamilyHistory.getText().toString());
        caseEntity.setMainSuit(this.vMainSuit.getText().toString());
        caseEntity.setMedicationHistory(this.vMedicalHistory.getText().toString());
        caseEntity.setOrderId(this.orderDetailEntity.getOrderId());
        caseEntity.setPastHistory(this.vPerHistory.getText().toString());
        caseEntity.setPresentHistory(this.vPresentHistory.getText().toString());
        caseEntity.setPrimaryDiagno(this.vResult.getText().toString());
        return caseEntity;
    }

    private OrderApplyEntity gatherData() {
        OrderApplyEntity orderApplyEntity = new OrderApplyEntity();
        orderApplyEntity.setApplicationChannels(this.mApplicationChannels);
        if (this.mApplicationChannels == 30 && this.mHospitalId == 0L || this.mApplicationChannels == 20) {
            orderApplyEntity.setDeptType(2);
            if (this.mExpertEntity == null || this.mExpertEntity.getDoctorDetailInfoEntity() == null) {
                orderApplyEntity.setDeptId(this.mDepartmentId);
            }
        } else {
            orderApplyEntity.setDeptType(1);
            if (this.mExpertEntity == null || this.mExpertEntity.getDoctorDetailInfoEntity() == null) {
                orderApplyEntity.setDeptId(this.mDepartmentId);
            }
        }
        orderApplyEntity.setOrderId(this.mOrderId);
        if (this.mExpertEntity == null || this.mExpertEntity.getDoctorDetailInfoEntity() != null) {
            // empty if block
        }
        if (this.mOrderId == null || this.mApplicationChannels != 30) {
            // empty if block
        }
        orderApplyEntity.setType(this.mOrderType);
        orderApplyEntity.setPatientId(this.mPatientId);
        orderApplyEntity.setMainSuit(this.vMainSuit.getText().toString());
        orderApplyEntity.setConsultAim(this.vMudi.getText().toString());
        orderApplyEntity.setPrimaryDiagno(this.vResult.getText().toString());
        orderApplyEntity.setInitiatorType("2");
        orderApplyEntity.setMobileNumber(this.vPatientPhone.getText().toString());
        orderApplyEntity.setAge(this.vPatientAge.getText().toString());
        orderApplyEntity.setPatientName(this.vPatientName.toString());
        orderApplyEntity.setSex(this.vPatientSex.getText().toString().equals("\u7537") ? 1 : 2);
        orderApplyEntity.setFamilyHistory(this.vFamilyHistory.getText().toString());
        orderApplyEntity.setMedicationHistory(this.vMedicalHistory.getText().toString());
        orderApplyEntity.setExpertDepId(orderApplyEntity.getDeptId());
        orderApplyEntity.setPastHistory(this.vPerHistory.getText().toString());
        orderApplyEntity.setPresentHistory(this.vPresentHistory.getText().toString());
        if (StringUtils.isEmpty((CharSequence)orderApplyEntity.getMainSuit())) {
            ToastUtils.showShort((CharSequence)Objects.requireNonNull(this.getContext()).getResources().getString(R.string.complained_not_null_tips));
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)orderApplyEntity.getPresentHistory())) {
            ToastUtils.showShort((CharSequence)Objects.requireNonNull(this.getContext()).getResources().getString(R.string.current_history_not_null_tips));
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)orderApplyEntity.getPastHistory())) {
            ToastUtils.showShort((CharSequence)Objects.requireNonNull(this.getContext()).getResources().getString(R.string.going_to_history_not_null_tips));
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)orderApplyEntity.getConsultAim())) {
            ToastUtils.showShort((CharSequence)Objects.requireNonNull(this.getContext()).getResources().getString(R.string.consultation_not_null_tips));
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)orderApplyEntity.getPrimaryDiagno())) {
            ToastUtils.showShort((CharSequence)Objects.requireNonNull(this.getContext()).getResources().getString(R.string.preliminary_diagnosis_not_null_tips));
            return null;
        }
        if (this.mPatientId == null) {
            ToastUtils.showShort((CharSequence)"\u9700\u8981\u9009\u62e9\u60a3\u8005");
            return null;
        }
        return orderApplyEntity;
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_order_apply;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.vAlertDialog.show();
    }

    @Override
    public void fullExpertInfo(ExpertItemEntity expertItemEntity) {
        if (expertItemEntity == null) {
            return;
        }
        ExpertInfoEntity expert = expertItemEntity.getDoctorDetailInfoEntity();
        if (expert != null) {
            // empty if block
        }
        if (this.mOrderType == 4) {
            this.vOrderType.setText((CharSequence)this.getContext().getResources().getString(R.string.video));
        } else if (this.mOrderType == 5) {
            this.vOrderType.setText((CharSequence)this.getContext().getResources().getString(R.string.graphic));
        }
    }

    @Override
    public void fullExpertInfo(ExpertItemEntityV2 expertItemEntity) {
    }

    @Override
    @Subscribe(sticky=true)
    public void fullPatientInfo(PatientEntity patientEntity) {
        this.mPatientEntity = patientEntity;
        this.mPatientId = patientEntity.getViewId();
        this.vPatientName.setText((CharSequence)patientEntity.getName());
        patientEntity.setHospitalId((long)VertifyDataUtil.getInstance((Context)this.mContext).getLoginData().getHospitalId());
        this.vPatientAge.setText((CharSequence)(patientEntity.getAge() + ""));
        this.vPatientCard.setText((CharSequence)(patientEntity.getIdCard() + ""));
        this.vPatientPhone.setText((CharSequence)(patientEntity.getMobileNumber() + ""));
        int gender = patientEntity.getGender();
        this.vPatientSex.setText((CharSequence)(gender == 1 ? this.getContext().getResources().getString(R.string.sex_boy) : this.getContext().getResources().getString(R.string.sex_girl)));
        this.vMainSuit.setText((CharSequence)patientEntity.getPatCaseMainSuit());
        this.mOrderId = patientEntity.getOrderId();
        this.caseAttachmentList = patientEntity.getCaseAttachmentList();
        if (this.caseAttachmentList == null && this.caseAttachmentList.size() <= 0) {
            ToastUtils.showShort((CharSequence)Objects.requireNonNull(this.getContext()).getResources().getString(R.string.please_upload_the_case_information));
            return;
        }
        ArrayList<String> images = new ArrayList<String>();
        if (this.caseAttachmentList != null && this.caseAttachmentList.size() > 0) {
            for (PatientDetailEntity.AttchMentEntity entity : this.caseAttachmentList) {
                images.add(entity.getUrl());
                this.ids.add(entity.getId());
            }
        }
        this.mAdapter.setImageNewData(images);
        EventBus.getDefault().removeStickyEvent((Object)patientEntity);
    }

    public void onFragmentResult(int requestCode, int resultCode, Bundle data) {
        super.onFragmentResult(requestCode, resultCode, data);
        if (data != null) {
            if (requestCode == 1) {
                this.mCityId = data.getInt("cityCode");
                this.vAreaSelect.setText((CharSequence)data.getString("cityName"));
            } else if (requestCode == 2) {
                this.mDepartmentId = data.getInt("departmentId");
                this.vDepartmentSelect.setText((CharSequence)data.getString("departmentName"));
            } else if (requestCode == 3) {
                this.mHospitalId = data.getInt("hospitalId");
                this.vHospitalSelect.setText((CharSequence)data.getString("hospitalName"));
            }
        }
    }

    @Override
    public void toSign(long orderId, String viewId, String doctorHosName, int applicationChannels, int initiatorType) {
        if (initiatorType == 1) {
            this.start((ISupportFragment)OrderApplySuccessFragment.newInstance(viewId, applicationChannels));
        } else {
            this.start((ISupportFragment)OrderApplySignFragment.newInstance(orderId, viewId, doctorHosName, applicationChannels));
        }
    }

    @Override
    public void toPatientCaseViewAndUpdate() {
        EventBus.getDefault().post((Object)new IPatientCaseUpdateEvent(){});
        this.pop();
    }
}

