/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import butterknife.BindView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.doctor.worktable.OrderApplySuccessFragment;
import com.kangxin.doctor.worktable.PatientSignFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.UploadPatientSignFragment;
import com.kangxin.doctor.worktable.presenter.IOrderApplySignPresenter;
import com.kangxin.doctor.worktable.presenter.clc.ClcOrderApplySignPresent;
import com.kangxin.doctor.worktable.presenter.impl2.BHOrderApplySignPresenter;
import com.kangxin.doctor.worktable.view.IOrderApplySignView;
import com.kangxin.doctor.worktable.widget.PatientAgressDialog;
import com.kangxin.doctor.worktable.widget.ShareToPatientSignDialog;
import me.yokeyword.fragmentation.ISupportFragment;
import org.jetbrains.annotations.NotNull;

public class OrderApplySignFragment
extends BaseFragment
implements IToolView,
IOrderApplySignView {
    private static final String TAG = "OrderApplySignFragment";
    private static final int REQUEST_IMAGE_SIGN = 1;
    private static final int REQUEST_WRITE_SIGN = 2;
    @BindView(value=2131428232)
    TextView vPatientSign;
    @BindView(value=2131428274)
    TextView vShare;
    @BindView(value=2131428297)
    TextView vUploadSign;
    @BindView(value=2131428105)
    TextView vCommit;
    @BindView(value=2131427955)
    View vShareSignLayout;
    @BindView(value=2131427991)
    TextView mStepDescView;
    @BindView(value=2131427928)
    TextView mSelDiamdDescView;
    private PatientAgressDialog vPatientAgressDialog;
    private long mOrderId;
    private String mHandWriteUrl;
    private String mImgUpUrl;
    private String mTag;
    private String mDoctorHosName;
    private String mViewId;
    private boolean isWriteSign = false;
    private int applicationChannel;
    private IOrderApplySignPresenter mOrderApplySignPresenter;
    private static boolean isFinishActivity;
    private int mConsuStatus;
    @Autowired
    IUpdateVerStatus mUpdateVerStatus;

    public static OrderApplySignFragment newInstance(long mOrderId, String viewId, String doctorHosName, int applicationChannels) {
        OrderApplySignFragment orderApplySignFragment = new OrderApplySignFragment();
        orderApplySignFragment.mOrderId = mOrderId;
        orderApplySignFragment.mDoctorHosName = doctorHosName;
        orderApplySignFragment.applicationChannel = applicationChannels;
        Bundle bundle = new Bundle();
        bundle.putLong("mOrderId", mOrderId);
        bundle.putString("viewId", viewId);
        bundle.putString("mDoctorHosName", doctorHosName);
        bundle.putInt("applicationChannels", applicationChannels);
        orderApplySignFragment.setArguments(bundle);
        return orderApplySignFragment;
    }

    public static OrderApplySignFragment newInstance(long mOrderId, String viewId, String doctorHosName, int applicationChannels, boolean finishActivity) {
        isFinishActivity = finishActivity;
        return OrderApplySignFragment.newInstance(mOrderId, viewId, doctorHosName, applicationChannels);
    }

    public void init() {
        String diaName = "";
        this.mConsuStatus = this.mUpdateVerStatus.getConsuStatus(this.getMContext());
        if (this.mConsuStatus == 4627) {
            diaName = "\u95e8\u8bca";
            this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.consultation_application_title_remote));
            this.mOrderApplySignPresenter = new ClcOrderApplySignPresent(this);
        } else if (this.mConsuStatus == 4626) {
            diaName = "\u4f1a\u8bca";
            this.vToolTitleTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.consultation_application_title));
            this.mOrderApplySignPresenter = new BHOrderApplySignPresenter(this);
        }
        this.mStepDescView.setText((CharSequence)("\u53ef\u5728" + diaName + "\u8ba2\u5355\u4e2d\u518d\u6b21\u8fdb\u5165"));
        this.mSelDiamdDescView.setText((CharSequence)("\u8bf7\u4efb\u9009\u4e00\u79cd\u7b7e\u7f72\u65b9\u5f0f\uff0c\u5b8c\u6210" + diaName + "\u7533\u8bf7"));
        this.mOrderId = this.getArguments().getLong("mOrderId");
        this.mDoctorHosName = this.getArguments().getString("mDoctorHosName");
        this.mViewId = this.getArguments().getString("viewId");
        this.applicationChannel = this.getArguments().getInt("applicationChannels");
        this.vPatientAgressDialog = PatientAgressDialog.newInstance(this.mDoctorHosName, diaName);
        this.dispatchEvent();
        if (this.mConsuStatus == 4627) {
            this.vShareSignLayout.setVisibility(8);
        }
    }

    private void dispatchEvent() {
        this.vPatientSign.setOnClickListener(v -> this.vPatientAgressDialog.show(this.getChildFragmentManager(), this.getContext().getResources().getString(R.string.consultation_consent_book)));
        this.vShare.setOnClickListener(v -> this.mOrderApplySignPresenter.getShareUrl());
        this.vUploadSign.setOnClickListener(v -> {
            if (this.isWriteSign) {
                this.isWriteSign = false;
            }
            this.startForResult((ISupportFragment)UploadPatientSignFragment.newInstance(this.mOrderId + "", this.mImgUpUrl), 1);
        });
        this.vPatientAgressDialog.setOnClickListener(v -> {
            this.isWriteSign = true;
            this.vPatientAgressDialog.dismiss();
            this.startForResult((ISupportFragment)PatientSignFragment.newInstance(this.mOrderId + "", this.mHandWriteUrl), 2);
        });
        this.vCommit.setOnClickListener(v -> {
            Log.i((String)TAG, (String)("dispatchEvent: mTag:" + this.mTag));
            if (TextUtils.isEmpty((CharSequence)this.mImgUpUrl) && TextUtils.isEmpty((CharSequence)this.mHandWriteUrl)) {
                ToastUtils.showLong((CharSequence)"\u8bf7\u4e0a\u4f20\u7b7e\u7f72\u56fe\u7247");
                return;
            }
            String signUrl = null;
            if (!TextUtils.isEmpty((CharSequence)this.mImgUpUrl)) {
                signUrl = this.mImgUpUrl;
            }
            if (!TextUtils.isEmpty((CharSequence)this.mHandWriteUrl)) {
                signUrl = this.mHandWriteUrl;
            }
            this.mOrderApplySignPresenter.uploadSign(this.mOrderId + "", signUrl, this.mTag);
        });
    }

    public void onFragmentResult(int requestCode, int resultCode, Bundle data) {
        super.onFragmentResult(requestCode, resultCode, data);
        if (data != null) {
            if (requestCode == 1) {
                this.mImgUpUrl = data.getString("url");
                this.vPatientSign.setText((CharSequence)this.getContext().getResources().getString(R.string.please_sign));
                this.vUploadSign.setText((CharSequence)this.getContext().getResources().getString(R.string.check));
                this.mHandWriteUrl = null;
            } else if (requestCode == 2) {
                this.mHandWriteUrl = data.getString("url");
                this.mTag = data.getString("tag");
                this.vPatientSign.setText((CharSequence)"\u5df2\u7b7e\u7f72");
                this.vUploadSign.setText((CharSequence)this.getContext().getResources().getString(R.string.please_upload));
                this.mImgUpUrl = null;
            }
        }
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_order_apply_sign;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public boolean onBackPressedSupport() {
        if (isFinishActivity) {
            this.getActivity().finish();
            return true;
        }
        return super.onBackPressedSupport();
    }

    public void finishCurrentView() {
        if (isFinishActivity) {
            this.getActivity().finish();
        } else {
            this.pop();
        }
    }

    @Override
    public void success() {
        this.start((ISupportFragment)OrderApplySuccessFragment.newInstance(this.mViewId, this.applicationChannel));
    }

    @Override
    public void toShare(String shareUrl) {
        new ShareToPatientSignDialog(this.mContext, shareUrl, this.mOrderId).show();
    }
}

