/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import butterknife.BindView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.util.ActivityUtils;
import com.kangxin.common.byh.util.QRCodeUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.presenter.IOrderApplySuccessPresenter;
import com.kangxin.doctor.worktable.presenter.IPayPresenter;
import com.kangxin.doctor.worktable.presenter.clc.ClcOrderApplySuccPresent;
import com.kangxin.doctor.worktable.presenter.clc.ClcPayPresent;
import com.kangxin.doctor.worktable.presenter.impl2.BHOrderApplySuccessPresenter;
import com.kangxin.doctor.worktable.presenter.impl2.PayPresenter;
import com.kangxin.doctor.worktable.view.IOrderApplySuccessView;
import com.kangxin.doctor.worktable.view.IPayStatusListenerView;
import org.jetbrains.annotations.NotNull;

public class OrderApplySuccessFragment
extends BaseFragment
implements IToolView,
IOrderApplySuccessView,
IPayStatusListenerView {
    @BindView(value=2131428188)
    ImageView vImage;
    @BindView(value=2131428125)
    TextView vContentTitle;
    @BindView(value=2131428124)
    TextView vContent;
    @BindView(value=2131428220)
    TextView vPatientInfo;
    @BindView(value=2131428136)
    TextView vDoctorInfo;
    @BindView(value=2131428148)
    TextView vExpertInfo;
    @BindView(value=2131428209)
    TextView vOrderType;
    @BindView(value=2131428086)
    TextView vAmount;
    @BindView(value=2131428094)
    TextView vBackHome;
    @BindView(value=2131428235)
    ImageView vPayQrcode;
    @BindView(value=2131427469)
    TextView vDiaInfoLabelView;
    @BindView(value=2131427813)
    TextView vDiaExpertLabelView;
    @BindView(value=2131427797)
    TextView vDiaTypeLabelView;
    @BindView(value=2131427790)
    TextView vDiaAmountLabelView;
    int applicationChannel;
    private IOrderApplySuccessPresenter mOrderApplySuccessPresenter;
    private IPayPresenter payPresenter;
    private static boolean isFinishActivity = false;
    @Autowired
    IUpdateVerStatus mUpdateVerStatus;
    private int mConsuStatus;
    private String mDiaName = "";

    public static OrderApplySuccessFragment newInstance(String orderViewId, int applicationChannel) {
        return OrderApplySuccessFragment.newInstance(orderViewId, "", "", "", 1, applicationChannel);
    }

    public static OrderApplySuccessFragment newInstance(String orderViewId, int applicationChannel, boolean finishActivity) {
        isFinishActivity = finishActivity;
        return OrderApplySuccessFragment.newInstance(orderViewId, "", "", "", 1, applicationChannel);
    }

    public static OrderApplySuccessFragment newInstance(String orderViewId, String title, String contentTitle, String content, int type, int applicationChannel) {
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("contentTitle", contentTitle);
        bundle.putString("content", content);
        bundle.putString("orderUuid", orderViewId);
        bundle.putInt("type", type);
        bundle.putInt("applicationChannel", applicationChannel);
        OrderApplySuccessFragment orderApplySuccFragment = new OrderApplySuccessFragment();
        orderApplySuccFragment.setArguments(bundle);
        return orderApplySuccFragment;
    }

    public void init() {
        this.mConsuStatus = this.mUpdateVerStatus.getConsuStatus(this.getMContext());
        if (this.mConsuStatus == 4626) {
            this.mDiaName = "\u4f1a\u8bca";
            this.mOrderApplySuccessPresenter = new BHOrderApplySuccessPresenter(this);
            this.payPresenter = new PayPresenter(this);
        } else if (this.mConsuStatus == 4627) {
            this.mDiaName = "\u95e8\u8bca";
            this.mOrderApplySuccessPresenter = new ClcOrderApplySuccPresent(this);
            this.payPresenter = new ClcPayPresent(this);
        }
        this.vDiaInfoLabelView.setText((CharSequence)(this.mDiaName + "\u57fa\u672c\u4fe1\u606f"));
        this.vDiaExpertLabelView.setText((CharSequence)(this.mDiaName + "\u4e13\u5bb6"));
        this.vDiaTypeLabelView.setText((CharSequence)(this.mDiaName + "\u7c7b\u578b"));
        this.vDiaAmountLabelView.setText((CharSequence)(this.mDiaName + "\u8d39\u7528"));
        String title = this.getArguments().getString("title");
        String contentTitle = this.getArguments().getString("contentTitle");
        String content = this.getArguments().getString("content");
        int type = this.getArguments().getInt("type");
        String orderViewId = this.getArguments().getString("orderUuid");
        this.applicationChannel = this.getArguments().getInt("applicationChannel");
        this.vToolTitleTextView.setText((CharSequence)title);
        this.vToolLeftImage.setVisibility(4);
        this.fullView(contentTitle, content, title, R.mipmap.work_ic_launcher);
        this.dispatchEvent();
        this.mOrderApplySuccessPresenter.getOrderDetail(orderViewId);
    }

    private void fullView(String title, String contentTitle, String content, int mitmapId) {
        this.vToolTitleTextView.setText((CharSequence)title);
        this.vContentTitle.setText((CharSequence)contentTitle);
        this.vContent.setText((CharSequence)content);
        this.vImage.setImageResource(mitmapId);
    }

    private void dispatchEvent() {
        this.vBackHome.setOnClickListener(v -> {
            LogUtils.i((Object[])new Object[]{"\u8fd4\u56de1"});
            ActivityUtils.addActivity((Activity)this._mActivity);
            ActivityUtils.closeActivity();
        });
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_order_apply_success;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        if (isFinishActivity) {
            this.getActivity().finish();
        } else {
            this.pop();
        }
    }

    public boolean onBackPressedSupport() {
        if (isFinishActivity) {
            this.getActivity().finish();
            return true;
        }
        return super.onBackPressedSupport();
    }

    @Override
    public void fullOrderDetail(OrderDetailEntity result) {
        boolean b;
        this.applicationChannel = result.getOrderApplicationChannels();
        String patientInfo = result.getPatientName() + " " + result.getPatientAge() + " " + (result.getPatientSex() == 1 ? "\u7537" : "\u5973");
        this.vPatientInfo.setText((CharSequence)patientInfo);
        this.vDoctorInfo.setText((CharSequence)(result.getDocHosName() + " " + result.getDocName()));
        this.vExpertInfo.setText((CharSequence)(result.getExpertHosName() + " " + result.getExpertName()));
        boolean bl = b = result.getOrderType() == 4;
        if (b) {
            this.vOrderType.setText((CharSequence)this.getContext().getResources().getString(R.string.video));
        } else {
            this.vOrderType.setText((CharSequence)this.getContext().getResources().getString(R.string.graphic));
        }
        this.vAmount.setText((CharSequence)(result.getOrderPrice() + "\u5143"));
        if (this.applicationChannel == 30 && StringUtils.isEmpty((CharSequence)result.getExpertName())) {
            this.vExpertInfo.setText((CharSequence)"\u5f85\u5206\u914d");
            this.vAmount.setText((CharSequence)"\u6682\u65e0");
        }
        int orderStatus = result.getOrderStatus();
        if (this.applicationChannel == 20 || this.applicationChannel == 10) {
            if (orderStatus == 5) {
                this.fullView("\u7533\u8bf7\u5f85\u7b7e\u7f72", this.mDiaName + "\u7533\u8bf7\u5f85\u60a3\u8005\u7b7e\u7f72", "\u7b49\u5f85\u60a3\u8005\u7b7e\u7f72\uff0c\u7b7e\u7f72\u540e\u7533\u8bf7\u7acb\u5373\u751f\u6548", R.mipmap.ic_message_wait);
            } else if (orderStatus == 10) {
                if (result.getPayType() == 1) {
                    this.fullView("\u5f85\u63a5\u8bca", this.mDiaName + "\u7533\u8bf7\u6210\u529f", "\u8ba2\u5355\u5df2\u6210\u529f\u63d0\u4ea4\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u4e13\u5bb6\u63a5\u8bca", R.mipmap.ic_message_ok);
                } else {
                    QRCodeUtil.bindQrImage((Context)this.mContext, null, (String)result.getPayQrcode(), (int)120, (ImageView)this.vPayQrcode);
                    this.vPayQrcode.setVisibility(0);
                    this.fullView("\u7533\u8bf7\u5f85\u652f\u4ed8", this.mDiaName + "\u7533\u8bf7\u5f85\u60a3\u8005\u652f\u4ed8", "\u7b49\u5f85\u60a3\u8005\u652f\u4ed8\uff0c\u652f\u4ed8\u540e\u7533\u8bf7\u7acb\u5373\u751f\u6548", R.mipmap.ic_message_wait);
                    this.payPresenter.startPayStatusListener(result.getOrderViewId());
                }
            } else {
                this.fullView("\u7533\u8bf7\u6210\u529f", this.mDiaName + "\u7533\u8bf7\u6210\u529f", "\u8ba2\u5355\u5df2\u6210\u529f\u63d0\u4ea4\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u4e13\u5bb6\u63a5\u8bca", R.mipmap.ic_message_ok);
            }
        } else if (this.applicationChannel == 30) {
            this.fullView("\u7533\u8bf7\u6210\u529f", this.mDiaName + "\u7533\u8bf7\u6210\u529f", "\u8ba2\u5355\u5df2\u6210\u529f\u63d0\u4ea4\u81f3\u7ba1\u7406\u5458\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u5206\u914d\u4e13\u5bb6", R.mipmap.ic_message_ok);
        }
        if (orderStatus == 50) {
            this.fullView("\u7533\u8bf7\u5df2\u53d6\u6d88", this.mDiaName + "\u7533\u8bf7\u5df2\u53d6\u6d88", "\u5f88\u62b1\u6b49\uff0c\u672c\u6b21" + this.mDiaName + "\u5df2\u53d6\u6d88", R.mipmap.ic_message_fail);
        }
    }

    @Override
    public void paySuccess() {
        ToastUtils.showShort((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f");
        this.payPresenter.closePayStatusListener();
        this._mActivity.finish();
    }

    @Override
    public void payFail() {
    }

    public void onDestroy() {
        this.payPresenter.closePayStatusListener();
        super.onDestroy();
    }
}

