/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.activity.MulitImageShowActivity;
import com.kangxin.common.byh.adapter.SelectImageListAdapter;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.response.PatientDetailEntity;
import com.kangxin.common.byh.inter.IPatientCaseUpdateEvent;
import com.kangxin.common.byh.present.IOrderDetailPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.byh.widget.SelectImageDecoration;
import com.kangxin.doctor.worktable.OrderApplySignFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.activity.DicomActivity;
import com.kangxin.doctor.worktable.fragment.v2.BHOrderApplyFragment;
import com.kangxin.doctor.worktable.fragment.v2.BHPayFragmentDialog;
import com.kangxin.doctor.worktable.presenter.IPayPresenter;
import com.kangxin.doctor.worktable.presenter.clc.ClcOrderDetailPresent;
import com.kangxin.doctor.worktable.presenter.clc.ClcPayPresent;
import com.kangxin.doctor.worktable.presenter.impl2.BHOrderDetailPresenter;
import com.kangxin.doctor.worktable.presenter.impl2.PayPresenter;
import com.kangxin.doctor.worktable.util.SkipUtil;
import com.kangxin.doctor.worktable.view.IOrderDetailView;
import com.kangxin.doctor.worktable.view.IPayStatusListenerView;
import java.util.ArrayList;
import java.util.List;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.Subscribe;
import org.jetbrains.annotations.NotNull;

@Route(path="/orders/detail/OrderDetailFragmentV2")
public class OrderDetailFragmentV2
extends BaseFragment
implements IToolView,
IOrderDetailView,
IPayStatusListenerView {
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    @BindView(value=2131428207)
    TextView vOrderStatusContent;
    @BindView(value=2131428206)
    TextView vOrderStatus;
    @BindView(value=2131428209)
    TextView vOrderType;
    @BindView(value=2131428203)
    TextView vOrderNumber;
    @BindView(value=2131428204)
    TextView vOrderPayTime;
    @BindView(value=2131428205)
    TextView vOrderPrice;
    @BindView(value=2131428114)
    TextView vConType;
    @BindView(value=2131428109)
    TextView vConApplyTime;
    @BindView(value=2131428110)
    TextView vConDoctorName;
    @BindView(value=2131428112)
    TextView vConExpertName;
    @BindView(value=2131428113)
    TextView vConStartTime;
    @BindView(value=2131428111)
    TextView vConEndTime;
    @BindView(value=2131427469)
    TextView vConsuInfoView;
    @BindView(value=2131427473)
    TextView vConsulationType;
    @BindView(value=2131427468)
    TextView vConsuExpertView;
    @BindView(value=2131428137)
    TextView vEditCase;
    @BindView(value=2131428225)
    TextView vPatientName;
    @BindView(value=2131428230)
    TextView vPatientSex;
    @BindView(value=2131428213)
    TextView vPatientAge;
    @BindView(value=2131428222)
    TextView vPatientMainSuit;
    @BindView(value=2131428228)
    TextView vPatientPreHistory;
    @BindView(value=2131428226)
    TextView vPatientNowHistory;
    @BindView(value=2131428218)
    TextView vPatientFamilyHistory;
    @BindView(value=2131428224)
    TextView vPatientMedicalHistory;
    @BindView(value=2131428217)
    TextView vPatientConMd;
    @BindView(value=2131427645)
    TextView mHzmdView;
    @BindView(value=2131428219)
    TextView vPatientFirstResult;
    @BindView(value=2131428234)
    TextView vPay;
    @BindView(value=2131428099)
    TextView vCancleOrder;
    @BindView(value=2131428287)
    TextView vToSign;
    @BindView(value=2131428193)
    TextView vLookDicom;
    SelectImageListAdapter adapter;
    IOrderDetailPresenter mOrderDetailPresenter;
    IPayPresenter payPresenter;
    private String orderViewId = "";
    private OrderDetailEntity orderDetailEntity;
    @Autowired
    IUpdateVerStatus mUpdateVerStatus;
    private int mConsuStatus;

    public static OrderDetailFragmentV2 newInstance(String orderViewId) {
        OrderDetailFragmentV2 orderDetailFragmentV2 = new OrderDetailFragmentV2();
        Bundle bundle = new Bundle();
        bundle.putString("orderViewId", orderViewId);
        orderDetailFragmentV2.setArguments(bundle);
        return orderDetailFragmentV2;
    }

    public void init() {
        this.mConsuStatus = this.mUpdateVerStatus.getConsuStatus(this.getMContext());
        if (this.mConsuStatus == 4626) {
            this.vToolTitleTextView.setText((CharSequence)"\u4f1a\u8bca\u8ba2\u5355");
            this.vConsuInfoView.setText((CharSequence)"\u4f1a\u8bca\u4fe1\u606f");
            this.vConsulationType.setText((CharSequence)"\u4f1a\u8bca\u5f62\u5f0f:");
            this.vConsuExpertView.setText((CharSequence)"\u4f1a\u8bca\u4e13\u5bb6:");
            this.vOrderType.setText((CharSequence)"\u8fdc\u7a0b\u4f1a\u8bca");
            this.mHzmdView.setText((CharSequence)"\u4f1a\u8bca\u76ee\u7684");
            this.mOrderDetailPresenter = new BHOrderDetailPresenter(this);
            this.payPresenter = new PayPresenter(this);
        } else if (this.mConsuStatus == 4627) {
            this.vEditCase.setVisibility(8);
            this.mHzmdView.setText((CharSequence)"\u95e8\u8bca\u76ee\u7684");
            this.vToolTitleTextView.setText((CharSequence)"\u95e8\u8bca\u8ba2\u5355");
            this.vConsuInfoView.setText((CharSequence)"\u95e8\u8bca\u4fe1\u606f");
            this.vConsulationType.setText((CharSequence)"\u95e8\u8bca\u5f62\u5f0f:");
            this.vConsuExpertView.setText((CharSequence)"\u95e8\u8bca\u4e13\u5bb6:");
            this.vOrderType.setText((CharSequence)"\u8fdc\u7a0b\u95e8\u8bca");
            this.mOrderDetailPresenter = new ClcOrderDetailPresent(this);
            this.payPresenter = new ClcPayPresent(this);
        }
        this.orderViewId = this.getArguments().getString("orderViewId");
        this.vToolLeftImage.setVisibility(0);
        this.adapter = new SelectImageListAdapter(null, true);
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.mContext, 4));
        this.vRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SelectImageDecoration(10));
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.vRecyclerView.setNestedScrollingEnabled(false);
        this.dispatchEvent();
        this.mOrderDetailPresenter.getOrderDetail(this.orderViewId);
    }

    private void switchStyle() {
        String docId;
        this.vPay.setVisibility(8);
        this.vToSign.setVisibility(8);
        this.vCancleOrder.setVisibility(8);
        int orderStatus = this.orderDetailEntity.getOrderStatus();
        if (orderStatus == 5) {
            this.vToSign.setVisibility(0);
            this.vCancleOrder.setVisibility(0);
        } else if (orderStatus == 10) {
            this.vPay.setVisibility(0);
            this.vCancleOrder.setVisibility(0);
        } else if (orderStatus != 30 || orderStatus != 50 || orderStatus != 40) {
            this.vCancleOrder.setVisibility(0);
        }
        if (orderStatus == 50) {
            this.vCancleOrder.setVisibility(8);
        }
        if (orderStatus == 40) {
            this.vCancleOrder.setVisibility(8);
            this.vEditCase.setVisibility(8);
        }
        if (orderStatus == 30) {
            this.vCancleOrder.setVisibility(8);
        }
        if (StringUtils.isEmpty((CharSequence)this.orderDetailEntity.getDcmFileUrl())) {
            this.vLookDicom.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)(docId = VertifyDataUtil.getInstance((Context)this.mContext).getDoctorId()))) {
            if (this.orderDetailEntity.getExpertId() == Integer.parseInt(docId)) {
                this.vEditCase.setVisibility(8);
            }
            if (this.orderDetailEntity.getDocId() != Integer.parseInt(docId)) {
                this.vCancleOrder.setVisibility(8);
            }
        }
    }

    private void dispatchEvent() {
        this.adapter.setOnItemChildClickListener((adapter1, view, position) -> {
            Bundle bundle = new Bundle();
            bundle.putStringArrayList("images", this.adapter.getImageDatas2());
            bundle.putInt("position", position);
            SkipUtil.skipActivity((Activity)this._mActivity, MulitImageShowActivity.class, bundle);
        });
        this.vEditCase.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OrderDetailFragmentV2.this.start((ISupportFragment)BHOrderApplyFragment.newInstance(OrderDetailFragmentV2.this.orderDetailEntity, true));
            }
        });
        this.vLookDicom.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OrderDetailFragmentV2.this.mOrderDetailPresenter.getDicomInfo(OrderDetailFragmentV2.this.orderDetailEntity.getDcmFileUrl());
            }
        });
        this.vCancleOrder.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                new AlertDialog.Builder(OrderDetailFragmentV2.this.mContext).setTitle((CharSequence)"\u53d6\u6d88\u8ba2\u5355").setPositiveButton((CharSequence)"\u786e\u8ba4\u53d6\u6d88", (dialog, which) -> OrderDetailFragmentV2.this.mOrderDetailPresenter.cancleOrder(OrderDetailFragmentV2.this.orderDetailEntity.getOrderId() + "", "\u6682\u65e0\u539f\u56e0")).setNegativeButton((CharSequence)"\u8fd4\u56de", (dialog, which) -> dialog.dismiss()).show();
            }
        });
        this.vPay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BHPayFragmentDialog bhPayFragmentDialog = BHPayFragmentDialog.newInstance(OrderDetailFragmentV2.this.orderDetailEntity.getOrderPrice() + "", OrderDetailFragmentV2.this.orderDetailEntity.getPayQrcode());
                bhPayFragmentDialog.show(OrderDetailFragmentV2.this.getChildFragmentManager(), "\u652f\u4ed8");
                OrderDetailFragmentV2.this.payPresenter.startPayStatusListener(OrderDetailFragmentV2.this.orderDetailEntity.getOrderViewId());
            }
        });
        this.vToSign.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OrderDetailFragmentV2.this.start((ISupportFragment)OrderApplySignFragment.newInstance(OrderDetailFragmentV2.this.orderDetailEntity.getOrderId(), OrderDetailFragmentV2.this.orderViewId, OrderDetailFragmentV2.this.orderDetailEntity.getDocHosName(), OrderDetailFragmentV2.this.orderDetailEntity.getOrderApplicationChannels()));
            }
        });
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_order_detail_v2;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this._mActivity.finish();
    }

    @Override
    public void bindOrderDetail(OrderDetailEntity data) {
        this.orderDetailEntity = data;
        this.orderStatus(data.getOrderStatus());
        this.mineApply(data);
        this.consulationInfo(data);
        this.switchStyle();
    }

    @Override
    public void cancleSuccess() {
        this.getActivity().finish();
    }

    @Override
    public void toDicom(String title, String url) {
        Intent intent = new Intent((Context)this._mActivity, DicomActivity.class);
        intent.putExtra("loadUrl", url);
        intent.putExtra("title", title);
        this.startActivity(intent);
    }

    private void consulationInfo(OrderDetailEntity data) {
        this.vPatientName.setText((CharSequence)data.getPatientName());
        this.vPatientAge.setText((CharSequence)(data.getPatientAge() + "\u5c81"));
        this.vPatientSex.setText((CharSequence)(data.getPatientSex() == 1 ? "\u7537" : "\u5973"));
        this.vPatientMainSuit.setText((CharSequence)data.getPatCaseMainSuit());
        this.vPatientPreHistory.setText((CharSequence)data.getPastHistory());
        this.vPatientNowHistory.setText((CharSequence)data.getPresentHistory());
        this.vPatientFamilyHistory.setText((CharSequence)data.getPatCaseFamilyHistory());
        this.vPatientMedicalHistory.setText((CharSequence)data.getPatCaseMedicationHistory());
        this.vPatientFirstResult.setText((CharSequence)data.getPatPrimaryDiagno());
        this.vPatientConMd.setText((CharSequence)data.getPatCaseConsultAim());
        List caseAttachmentList = data.getCaseAttachmentList();
        if (caseAttachmentList == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < caseAttachmentList.size(); ++i) {
            list.add(((PatientDetailEntity.AttchMentEntity)caseAttachmentList.get(i)).getUrl());
        }
        this.adapter.setImageNewData(list);
        this.adapter.notifyDataSetChanged();
    }

    private void mineApply(OrderDetailEntity data) {
        switch (data.getOrderApplicationChannels()) {
            case 10: {
                this.vOrderType.setText((CharSequence)"\u533b\u8054\u4f53\u4f1a\u8bca");
                break;
            }
            case 20: {
                this.vOrderType.setText((CharSequence)"\u540d\u9662\u4e13\u5bb6");
                break;
            }
            case 30: {
                this.vOrderType.setText((CharSequence)"\u5feb\u901f\u5206\u914d");
            }
        }
        this.vOrderNumber.setText((CharSequence)data.getOrderViewId());
        if (data.getPayTime() != null) {
            this.vOrderPayTime.setText((CharSequence)(data.getPayTime() + ""));
        } else {
            this.vOrderPayTime.setText((CharSequence)"\u6682\u65e0");
        }
        this.vOrderPrice.setText((CharSequence)(data.getOrderPrice() + ""));
        String orderTypeName = "";
        switch (data.getOrderType()) {
            case 4: {
                orderTypeName = "\u89c6\u9891\u4f1a\u8bca";
                break;
            }
            case 5: {
                orderTypeName = "\u56fe\u6587\u4f1a\u8bca";
                break;
            }
            case 6: {
                orderTypeName = "\u8fdc\u7a0b\u95e8\u8bca";
            }
        }
        this.vConType.setText((CharSequence)orderTypeName);
        this.vConApplyTime.setText((CharSequence)(data.getOrderCreateTimeStr() + ""));
        this.vConDoctorName.setText((CharSequence)(data.getDocHosName() + " " + data.getDocDepName() + " " + data.getDocName()));
        this.vConExpertName.setText((CharSequence)(data.getExpertHosName() + " " + data.getExpertDepName() + " " + data.getExpertName()));
        if (data.getOrderUpdateTimeStr() != null) {
            this.vConStartTime.setText((CharSequence)data.getOrderBeginTime());
        }
        this.vConEndTime.setText((CharSequence)data.getOrderFinishTime());
    }

    private void orderStatus(int orderStatus) {
        String conName = "";
        if (this.mConsuStatus == 4626) {
            conName = "\u4f1a\u8bca";
        } else if (this.mConsuStatus == 4627) {
            conName = "\u95e8\u8bca";
        }
        switch (orderStatus) {
            case 6: {
                this.bindOrderStatus("\u65b0\u7533\u8bf7", "\u6536\u5230\u4e00\u4e2a\u65b0\u7533\u8bf7\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u8fdb\u884c" + conName + "\u7533\u8bf7\u3002");
                break;
            }
            case 10: {
                this.bindOrderStatus("\u5f85\u652f\u4ed8", conName + "\u7533\u8bf7\u5f85\u60a3\u8005\u652f\u4ed8\uff0c\u652f\u4ed8\u540e\u7533\u8bf7\u7acb\u5373\u751f\u6548\u3002");
                break;
            }
            case 8: {
                this.bindOrderStatus("\u5f85\u5206\u914d\u4e13\u5bb6", "\u8ba2\u5355\u5df2\u7ecf\u63d0\u4ea4\u81f3\u533b\u9662\u7ba1\u7406\u5458\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u5206\u914d\u4e13\u5bb6\u3002");
                break;
            }
            case 5: {
                this.bindOrderStatus("\u5f85\u60a3\u8005\u7b7e\u7f72", "\u9009\u62e9\u7b7e\u7f72\u65b9\u5f0f\u7b49\u5f85\u60a3\u8005\u7b7e\u7f72\u3002");
                break;
            }
            case 20: {
                this.bindOrderStatus("\u5f85\u4e13\u5bb6\u63a5\u8bca", "\u60a8\u7684" + conName + "\u7533\u8bf7\u5df2\u53d1\u9001\u7ed9\u5bf9\u65b9\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u63a5\u8bca\u3002");
                break;
            }
            case 30: {
                this.bindOrderStatus("\u8fdb\u884c\u4e2d", conName + "\u6b63\u5728\u8fdb\u884c\u4e2d\u3002");
                break;
            }
            case 0: {
                break;
            }
            case 40: {
                this.bindOrderStatus("\u5df2\u5b8c\u6210", conName + "\u5df2\u5b8c\u6210\u3002");
                break;
            }
            case 50: {
                this.bindOrderStatus("\u5df2\u53d6\u6d88", "\u672c\u6b21" + conName + "\u5df2\u53d6\u6d88\uff0c\u5982\u5df2\u652f\u4ed8\u9000\u6b3e\u5c06\u4e8e1-15\u4e2a\u5de5\u4f5c\u65e5\u539f\u8def\u9000\u56de\u652f\u4ed8\u8d26\u6237\u3002");
                break;
            }
        }
    }

    private void bindOrderStatus(String status, String content) {
        this.vOrderStatus.setText((CharSequence)status);
        this.vOrderStatusContent.setText((CharSequence)content);
    }

    @Subscribe
    public void update(IPatientCaseUpdateEvent event) {
        this.mOrderDetailPresenter.getOrderDetail(this.orderViewId);
    }

    @Override
    public void paySuccess() {
        ToastUtils.showShort((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f");
        this._mActivity.runOnUiThread(() -> this.mOrderDetailPresenter.getOrderDetail(this.orderViewId));
    }

    @Override
    public void payFail() {
    }

    public void onDestroy() {
        super.onDestroy();
        this.payPresenter.closePayStatusListener();
    }
}

