/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.StringUtils;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.activity.MulitImageShowActivity;
import com.kangxin.common.byh.adapter.SelectImageListAdapter;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.response.PatientDetailEntity;
import com.kangxin.common.byh.inter.IPatientCaseUpdateEvent;
import com.kangxin.common.byh.present.IOrderDetailPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.activity.DicomActivity;
import com.kangxin.doctor.worktable.fragment.v2.BHOrderApplyFragment;
import com.kangxin.doctor.worktable.presenter.IPatientCasePresenter;
import com.kangxin.doctor.worktable.presenter.clc.ClcOrderDetailPresent;
import com.kangxin.doctor.worktable.presenter.clc.ClcPatiCasePresent;
import com.kangxin.doctor.worktable.presenter.impl.PatientCasePresenter;
import com.kangxin.doctor.worktable.presenter.impl2.BHOrderDetailPresenter;
import com.kangxin.doctor.worktable.util.SkipUtil;
import com.kangxin.doctor.worktable.view.IOrderDetailView;
import com.kangxin.doctor.worktable.view.IPatientCaseView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.Subscribe;
import org.jetbrains.annotations.NotNull;

@Route(path="/patient/patient_case")
public class PatientCaseFragment
extends BaseFragment
implements IToolView,
IPatientCaseView,
IOrderDetailView {
    OrderDetailEntity orderDetailEntity;
    @BindView(value=2131428225)
    TextView vPatientName;
    @BindView(value=2131428230)
    TextView vPatientSex;
    @BindView(value=2131428213)
    TextView vPatientAge;
    @BindView(value=2131428215)
    TextView vPatientCard;
    @BindView(value=2131428227)
    TextView vPatientPhone;
    @BindView(value=2131428221)
    TextView vPatientInvitation;
    @BindView(value=2131428172)
    TextView vHistory;
    @BindView(value=2131428200)
    TextView vNowHistory;
    @BindView(value=2131428194)
    TextView vMainSuit;
    @BindView(value=2131428196)
    TextView vMudi;
    @BindView(value=2131428164)
    TextView vFamilyHistory;
    @BindView(value=2131428306)
    TextView vYaowuHistory;
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    @BindView(value=2131428193)
    TextView vLookDicom;
    @BindView(value=2131427644)
    TextView mHuizhenMudi;
    private SelectImageListAdapter selectImageListAdapter;
    private boolean isFinishActivity = false;
    @BindView(value=2131428295)
    TextView vUpdate;
    private boolean isShowUpdate;
    private IPatientCasePresenter patientCasePresenter;
    private IOrderDetailPresenter orderDetailPresenter;

    public static PatientCaseFragment newInstance(OrderDetailEntity orderDetailEntity, boolean isShowUpdate) {
        PatientCaseFragment patientCaseFragment = new PatientCaseFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable("orderDetailEntity", (Serializable)orderDetailEntity);
        bundle.putBoolean("isShowUpdate", isShowUpdate);
        patientCaseFragment.setArguments(bundle);
        return patientCaseFragment;
    }

    public static PatientCaseFragment newInstance(OrderDetailEntity orderDetailEntity) {
        return PatientCaseFragment.newInstance(orderDetailEntity, false);
    }

    public void init() {
        this.orderDetailEntity = (OrderDetailEntity)this.getArguments().getSerializable("orderDetailEntity");
        this.isShowUpdate = this.getArguments().getBoolean("isShowUpdate");
        this.isFinishActivity = this.getArguments().getBoolean("isFinishActivity");
        String actionTitle = this.getArguments().getString("IM_CHECK_CASE_KEY");
        IUpdateVerStatus updateVerStatus = (IUpdateVerStatus)ARouter.getInstance().build("/service_update/SERVICE_UPDATE_VER_STATUS").navigation();
        if (updateVerStatus != null) {
            int consuStatus = updateVerStatus.getConsuStatus(this.getMContext());
            if (consuStatus == 4627) {
                this.patientCasePresenter = new ClcPatiCasePresent(this);
                this.orderDetailPresenter = new ClcOrderDetailPresent(this);
                this.vUpdate.setVisibility(8);
                this.mHuizhenMudi.setText((CharSequence)"\u95e8\u8bca\u76ee\u7684");
                this.isShowUpdate = false;
            } else if (consuStatus == 4626) {
                this.mHuizhenMudi.setText((CharSequence)"\u4f1a\u8bca\u76ee\u7684");
                this.patientCasePresenter = new PatientCasePresenter(this);
                this.orderDetailPresenter = new BHOrderDetailPresenter(this);
            }
        }
        if (this.isShowUpdate) {
            this.vUpdate.setVisibility(0);
            this.vUpdate.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PatientCaseFragment.this.start((ISupportFragment)BHOrderApplyFragment.newInstance(PatientCaseFragment.this.orderDetailEntity, true));
                }
            });
        }
        if (this.orderDetailEntity == null) {
            return;
        }
        if (this.orderDetailEntity.getExpertId() == Integer.parseInt(VertifyDataUtil.getInstance((Context)this.mContext).getDoctorId())) {
            this.vUpdate.setVisibility(8);
        }
        if (TextUtils.isEmpty((CharSequence)actionTitle)) {
            this.vToolTitleTextView.setText((CharSequence)"\u60a3\u8005\u8be6\u60c5");
        } else {
            this.vToolTitleTextView.setText((CharSequence)actionTitle);
        }
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 5));
        this.vLookDicom.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PatientCaseFragment.this.orderDetailPresenter.getDicomInfo(PatientCaseFragment.this.orderDetailEntity.getDcmFileUrl());
            }
        });
        this.patientCasePresenter.requestPatientCase(this.orderDetailEntity.getOrderViewId());
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_patient_case;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        if (this.isFinishActivity) {
            this.getActivity().finish();
        } else {
            this.pop();
        }
    }

    @Subscribe
    public void updatePatientCase(IPatientCaseUpdateEvent patientCaseUpdate) {
        this.patientCasePresenter.requestPatientCase(this.orderDetailEntity.getOrderViewId());
    }

    public boolean onBackPressedSupport() {
        if (this.isFinishActivity) {
            this.getActivity().finish();
        } else {
            this.pop();
        }
        return true;
    }

    @Override
    public void fullPatientCase(OrderDetailEntity result) {
        this.orderDetailEntity = result;
        if (this.orderDetailEntity.getExpertId() == Integer.parseInt(VertifyDataUtil.getInstance((Context)this.mContext).getDoctorId())) {
            this.vUpdate.setVisibility(8);
        }
        this.vPatientName.setText((CharSequence)result.getPatientName());
        this.vPatientSex.setText((CharSequence)(result.getPatientSex() == 1 ? "\u7537" : "\u5973"));
        this.vPatientAge.setText((CharSequence)(result.getPatientAge() + ""));
        String card = result.getPatIdCard() + "";
        if (card.length() == 18) {
            String card2 = card.replaceAll("(\\d{6})\\d{8}(\\w{4})", "$1******$2");
            this.vPatientCard.setText((CharSequence)card2);
        }
        this.vPatientPhone.setText((CharSequence)(result.getPatientTel() + ""));
        this.vPatientInvitation.setText((CharSequence)result.getPatPrimaryDiagno());
        this.vHistory.setText((CharSequence)(result.getPastHistory() + ""));
        this.vNowHistory.setText((CharSequence)(result.getPresentHistory() + ""));
        this.vMainSuit.setText((CharSequence)(result.getPatCaseMainSuit() + ""));
        this.vMudi.setText((CharSequence)(result.getPatCaseConsultAim() + ""));
        this.vFamilyHistory.setText((CharSequence)result.getPatCaseFamilyHistory());
        this.vYaowuHistory.setText((CharSequence)result.getPatCaseMedicationHistory());
        List caseAttachmentList = result.getCaseAttachmentList();
        ArrayList<String> images = new ArrayList<String>();
        if (caseAttachmentList != null) {
            for (PatientDetailEntity.AttchMentEntity temp : caseAttachmentList) {
                images.add(temp.getUrl());
            }
        }
        this.selectImageListAdapter = new SelectImageListAdapter(images, true);
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)this.selectImageListAdapter);
        this.selectImageListAdapter.setOnItemChildClickListener(new SelectImageListAdapter.OnItemChildClickListener(){

            public void onDelete(int position) {
            }

            public void onLook(int position) {
                Bundle bundle = new Bundle();
                List imageDatas = PatientCaseFragment.this.selectImageListAdapter.getImageDatas();
                ArrayList<String> images = new ArrayList<String>();
                for (int i = 0; i < imageDatas.size(); ++i) {
                    String s = (String)imageDatas.get(i);
                    if (StringUtils.isEmpty((CharSequence)s)) continue;
                    images.add(s);
                }
                bundle.putStringArrayList("images", images);
                bundle.putInt("position", position);
                SkipUtil.skipActivity((Activity)PatientCaseFragment.this._mActivity, MulitImageShowActivity.class, bundle);
            }

            public void onAdd() {
            }
        });
    }

    @Override
    public void bindOrderDetail(OrderDetailEntity data) {
    }

    @Override
    public void cancleSuccess() {
    }

    @Override
    public void toDicom(String title, String url) {
        Intent intent = new Intent((Context)this._mActivity, DicomActivity.class);
        intent.putExtra("loadUrl", url);
        intent.putExtra("title", title);
        this.startActivity(intent);
    }
}

