/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.blankj.utilcode.util.StringUtils;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.kangxin.common.byh.activity.MulitImageShowActivity;
import com.kangxin.common.byh.adapter.SelectImageListAdapter;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.response.PatientDetailEntity;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.util.SkipUtil;
import java.util.ArrayList;
import java.util.List;

public class PatientCaseFragmentDialog
extends BottomSheetDialog {
    OrderDetailEntity orderDetailEntity;
    @BindView(value=2131428225)
    TextView vPatientName;
    @BindView(value=2131428230)
    TextView vPatientSex;
    @BindView(value=2131428213)
    TextView vPatientAge;
    @BindView(value=2131428215)
    TextView vPatientCard;
    @BindView(value=2131428227)
    TextView vPatientPhone;
    @BindView(value=2131428216)
    TextView vPatientCase;
    @BindView(value=2131428221)
    TextView vPatientInvitation;
    @BindView(value=2131428172)
    TextView vHistory;
    @BindView(value=2131428200)
    TextView vNowHistory;
    @BindView(value=2131428194)
    TextView vMainSuit;
    @BindView(value=2131428196)
    TextView vMudi;
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    View rootView;

    public PatientCaseFragmentDialog(@NonNull Context context, OrderDetailEntity orderDetailEntity) {
        super(context);
        this.orderDetailEntity = orderDetailEntity;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.rootView = this.getLayoutInflater().inflate(R.layout.worktab_by_fragment_patient_case, null);
        if (this.orderDetailEntity == null) {
            return;
        }
        TextView title = (TextView)this.rootView.findViewById(R.id.vToolBar);
        title.setText((CharSequence)"\u67e5\u770b\u75c5\u4f8b");
        this.vPatientName.setText((CharSequence)this.orderDetailEntity.getPatientName());
        this.vPatientSex.setText((CharSequence)(this.orderDetailEntity.getPatientSex() == 1 ? "\u7537" : "\u5973"));
        this.vPatientAge.setText((CharSequence)(this.orderDetailEntity.getPatientAge() + ""));
        this.vPatientCard.setText((CharSequence)(this.orderDetailEntity.getPatIdCard() + ""));
        this.vPatientPhone.setText((CharSequence)(this.orderDetailEntity.getPatientTel() + ""));
        this.vPatientCard.setText((CharSequence)(this.orderDetailEntity.getPatIdCard() + ""));
        this.vPatientInvitation.setText((CharSequence)"\u521d\u6b65\u8bca\u65ad");
        this.vHistory.setText((CharSequence)(this.orderDetailEntity.getPresentHistory() + ""));
        this.vNowHistory.setText((CharSequence)(this.orderDetailEntity.getPastHistory() + ""));
        this.vMainSuit.setText((CharSequence)(this.orderDetailEntity.getPatCaseMainSuit() + ""));
        this.vMudi.setText((CharSequence)(this.orderDetailEntity.getPatCaseConsultAim() + ""));
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 5));
        List caseAttachmentList = this.orderDetailEntity.getCaseAttachmentList();
        ArrayList<String> images = new ArrayList<String>();
        for (PatientDetailEntity.AttchMentEntity temp : caseAttachmentList) {
            images.add(temp.getUrl());
        }
        final SelectImageListAdapter selectImageListAdapter = new SelectImageListAdapter(images, true);
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)selectImageListAdapter);
        selectImageListAdapter.setOnItemChildClickListener(new SelectImageListAdapter.OnItemChildClickListener(){

            public void onDelete(int position) {
            }

            public void onLook(int position) {
                Bundle bundle = new Bundle();
                List imageDatas = selectImageListAdapter.getImageDatas();
                ArrayList<String> images = new ArrayList<String>();
                for (int i = 0; i < imageDatas.size(); ++i) {
                    String s = (String)imageDatas.get(i);
                    if (StringUtils.isEmpty((CharSequence)s)) continue;
                    images.add(s);
                }
                bundle.putStringArrayList("images", images);
                bundle.putInt("position", position);
                SkipUtil.skipActivity(PatientCaseFragmentDialog.this.getOwnerActivity(), MulitImageShowActivity.class, bundle);
            }

            public void onAdd() {
            }
        });
    }
}

