/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import butterknife.BindView;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.v2.PatientRelationEntityV2;
import com.kangxin.common.widget.LinePathView;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.v2.BHRelationShipAdapter;
import com.kangxin.doctor.worktable.presenter.IPatientSignPresenter;
import com.kangxin.doctor.worktable.presenter.impl2.BHPatientSignPresenter;
import com.kangxin.doctor.worktable.view.IPatientSignView;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PatientSignFragment
extends BaseFragment
implements IToolView,
IPatientSignView {
    private static final int REQUEST_WRITE_SIGN = 2;
    @BindView(value=2131428254)
    Spinner vRelationShip;
    @BindView(value=2131428266)
    TextView vSavePatientSign;
    @BindView(value=2131428103)
    TextView vClear;
    @BindView(value=2131428232)
    LinePathView vPatientSign;
    String signPath;
    private BHRelationShipAdapter mRelationShipAdapter;
    private IPatientSignPresenter mPatientSignPresenter = new BHPatientSignPresenter(this);
    private String tag = null;
    private String mOrderId;

    public static PatientSignFragment newInstance(String mOrderId, String mSignUrl) {
        PatientSignFragment patientSignFragment = new PatientSignFragment();
        patientSignFragment.mOrderId = mOrderId;
        if (mSignUrl == null) {
            mSignUrl = "";
        }
        patientSignFragment.signPath = mSignUrl;
        Bundle bundle = new Bundle();
        bundle.putString("mOrderId", mOrderId);
        bundle.putString("signPath", mSignUrl);
        patientSignFragment.setArguments(bundle);
        return patientSignFragment;
    }

    public void init() {
        this.mOrderId = this.getArguments().getString("mOrderId");
        this.signPath = this.getArguments().getString("signPath");
        this.vToolTitleTextView.setText((CharSequence)"\u77e5\u60c5\u540c\u610f\u4e66\u7b7e\u5b57");
        this.landscapeWindow();
        this.mRelationShipAdapter = new BHRelationShipAdapter(this.mContext, new ArrayList<PatientRelationEntityV2>());
        this.vRelationShip.setAdapter((SpinnerAdapter)this.mRelationShipAdapter);
        this.dispatchEvent();
    }

    public void onSupportVisible() {
        super.onSupportVisible();
        this.mPatientSignPresenter.getRelationShip();
    }

    private void dispatchEvent() {
        this.vClear.setOnClickListener(v -> this.vPatientSign.clear());
        this.vSavePatientSign.setOnClickListener(v -> {
            if (!this.vPatientSign.getTouched()) {
                return;
            }
            if (this.tag == null) {
                ToastUtils.showShort((CharSequence)"\u8bf7\u7b49\u5f85\u5173\u7cfb\u5217\u8868\u52a0\u8f7d\u5b8c\u6210\u540e\u91cd\u8bd5...");
                return;
            }
            String fileUrl = this.vPatientSign.saveBitmap("/patientsign.png");
            this.mPatientSignPresenter.uploadPatientWriteSign(this.mOrderId, fileUrl, this.tag);
        });
        this.vRelationShip.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                PatientSignFragment.this.tag = (String)view.getTag(R.layout.by_item_text);
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_patient_sign;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.portraitWindow();
        this.pop();
    }

    @Override
    public void bindData(List result) {
        this.mRelationShipAdapter.setData(result);
    }

    @Override
    public void saveSuccess(String url, String tag) {
        Bundle bundle = new Bundle();
        bundle.putString("url", url);
        bundle.putString("tag", tag);
        this.setFragmentResult(2, bundle);
        this.finishCurrentView();
    }

    public boolean onBackPressedSupport() {
        this.portraitWindow();
        return super.onBackPressedSupport();
    }
}

