/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import butterknife.BindView;
import com.google.android.material.tabs.TabLayout;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.util.TabLayoutHelper;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.PatientsListAdapter;
import com.kangxin.doctor.worktable.entity.DoctorManagerPatientsInfoDataEntity;
import com.kangxin.doctor.worktable.util.TimeUtil;
import org.jetbrains.annotations.NotNull;

public class PatientsDetailsFragment
extends BaseFragment
implements IToolView {
    @BindView(value=2131427834)
    TabLayout vTabLayout;
    @BindView(value=2131427837)
    ViewPager vViewPager;
    private TextView mPatientsNameTv;
    private TextView mGenderTv;
    private TextView mAgeTv;
    private TextView mIdNumberTv;
    private TextView mPhoneNumTv;
    private TextView mCreateTimeTv;
    private int mPatientInfoId;

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)"\u4fe1\u606f\u8be6\u60c5");
        this.initViews();
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            DoctorManagerPatientsInfoDataEntity.PageDataBean pageDataBean = (DoctorManagerPatientsInfoDataEntity.PageDataBean)bundle.getSerializable("pageDataBean");
            this.mPatientsNameTv.setText((CharSequence)pageDataBean.getName());
            this.mGenderTv.setText((CharSequence)(pageDataBean.getGender() == 1 ? "\u7537" : "\u5973"));
            this.mAgeTv.setText((CharSequence)(pageDataBean.getAge() + ""));
            this.mIdNumberTv.setText((CharSequence)pageDataBean.getIdCard());
            this.mPhoneNumTv.setText((CharSequence)pageDataBean.getMobileNumber());
            String createDate = TimeUtil.utc2Local(pageDataBean.getCreateTime());
            this.mCreateTimeTv.setText((CharSequence)createDate);
            this.mPatientInfoId = pageDataBean.getPatientInfoId();
        }
        this.vViewPager.setAdapter((PagerAdapter)new PatientsListAdapter(this.getChildFragmentManager(), this.mPatientInfoId));
        this.vTabLayout.setupWithViewPager(this.vViewPager);
    }

    private void initViews() {
        this.mPatientsNameTv = (TextView)this.findViewById(this.rootView, R.id.patients_name_value_tv);
        this.mGenderTv = (TextView)this.findViewById(this.rootView, R.id.gender_value_tv);
        this.mAgeTv = (TextView)this.findViewById(this.rootView, R.id.age_value_tv);
        this.mIdNumberTv = (TextView)this.findViewById(this.rootView, R.id.id_number_value_tv);
        this.mPhoneNumTv = (TextView)this.findViewById(this.rootView, R.id.contact_phonenum_value_tv);
        this.mCreateTimeTv = (TextView)this.findViewById(this.rootView, R.id.create_time_value_tv);
        this.vTabLayout.setTabMode(1);
        this.setTabLayout();
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_patients_info_details;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }

    private void setTabLayout() {
        new TabLayoutHelper.Builder(this.vTabLayout).setIndicatorColor(this.getResources().getColor(R.color.colorPrimary)).setIndicatorHeight(4).setIndicatorWith(100).setTabItemMarginLeft(20).setIndicatorDrawable(R.drawable.bg_tab_blue).setNormalTextColor(this.getResources().getColor(R.color.color_666666)).setSelectedTextColor(this.getResources().getColor(R.color.colorPrimary)).setSelectedBold(false).setIndicatorMargin(40).setTabItemPadding(20).build(15.0f);
    }
}

